/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.jws.JWSBuilder;
import org.jboss.resteasy.jwt.JsonSerialization;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.SkeletonKeyScope;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.RealmManager;

public class TokenManager {
    protected static final Logger logger = Logger.getLogger(TokenManager.class);
    protected Map<String, AccessCodeEntry> accessCodeMap = new ConcurrentHashMap<String, AccessCodeEntry>();

    public void clearAccessCodes() {
        this.accessCodeMap.clear();
    }

    public AccessCodeEntry getAccessCode(String key) {
        return this.accessCodeMap.get(key);
    }

    public AccessCodeEntry pullAccessCode(String key) {
        return this.accessCodeMap.remove(key);
    }

    public AccessCodeEntry createAccessCode(String scopeParam, String state, String redirect, RealmModel realm, UserModel client, UserModel user) {
        Set scope;
        boolean applicationResource = realm.hasRole(client, realm.getRole("KEYCLOAK__APPLICATION"));
        AccessCodeEntry code = new AccessCodeEntry();
        SkeletonKeyScope scopeMap = null;
        if (scopeParam != null) {
            scopeMap = this.decodeScope(scopeParam);
        }
        List<RoleModel> realmRolesRequested = code.getRealmRolesRequested();
        MultivaluedMap<String, RoleModel> resourceRolesRequested = code.getResourceRolesRequested();
        Set realmMapping = realm.getRoleMappingValues(user);
        if (realmMapping != null && realmMapping.size() > 0 && (scopeMap == null || scopeMap.containsKey((Object)"realm")) && (scope = realm.getScopeMappingValues(client)).size() > 0) {
            HashSet scopeRequest = scopeMap != null ? new HashSet(scopeMap.get((Object)"realm")) : null;
            for (String role : realmMapping) {
                if (scopeRequest != null && !scopeRequest.contains(role) || !scope.contains(role)) continue;
                realmRolesRequested.add(realm.getRole(role));
            }
        }
        for (ApplicationModel resource : realm.getApplications()) {
            Set scope2;
            if (applicationResource && resource.getApplicationUser().getLoginName().equals(client.getLoginName())) {
                for (String role : resource.getRoleMappingValues(user)) {
                    resourceRolesRequested.addAll((Object)resource.getName(), (Object[])new RoleModel[]{resource.getRole(role)});
                }
                continue;
            }
            Set mapping = resource.getRoleMappingValues(user);
            if (mapping == null || mapping.size() <= 0 || scopeMap != null && !scopeMap.containsKey((Object)resource.getName()) || (scope2 = resource.getScopeMappingValues(client)).size() <= 0) continue;
            HashSet scopeRequest = scopeMap != null ? new HashSet(scopeMap.get((Object)resource.getName())) : null;
            for (String role : mapping) {
                if (scopeRequest != null && !scopeRequest.contains(role) || !scope2.contains(role)) continue;
                resourceRolesRequested.add((Object)resource.getName(), (Object)resource.getRole(role));
            }
        }
        this.createToken(code, realm, client, user);
        code.setRealm(realm);
        code.setExpiration(System.currentTimeMillis() / 1000L + (long)realm.getAccessCodeLifespan());
        code.setClient(client);
        code.setUser(user);
        code.setState(state);
        code.setRedirectUri(redirect);
        this.accessCodeMap.put(code.getId(), code);
        String accessCode = null;
        try {
            accessCode = new JWSBuilder().content(code.getId().getBytes("UTF-8")).rsa256(realm.getPrivateKey());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        code.setCode(accessCode);
        return code;
    }

    protected SkeletonKeyToken initToken(RealmModel realm, UserModel client, UserModel user) {
        Set allowedOrigins;
        SkeletonKeyToken token = new SkeletonKeyToken();
        token.id(RealmManager.generateId());
        token.principal(user.getLoginName());
        token.audience(realm.getName());
        token.issuedNow();
        token.issuedFor(client.getLoginName());
        if (realm.getTokenLifespan() > 0) {
            token.expiration(System.currentTimeMillis() / 1000L + (long)realm.getTokenLifespan());
        }
        if ((allowedOrigins = client.getWebOrigins()) != null) {
            token.setAllowedOrigins(allowedOrigins);
        }
        return token;
    }

    protected void createToken(AccessCodeEntry accessCodeEntry, RealmModel realm, UserModel client, UserModel user) {
        SkeletonKeyToken token = this.initToken(realm, client, user);
        if (accessCodeEntry.getRealmRolesRequested().size() > 0) {
            SkeletonKeyToken.Access access = new SkeletonKeyToken.Access();
            for (RoleModel role : accessCodeEntry.getRealmRolesRequested()) {
                access.addRole(role.getName());
            }
            token.setRealmAccess(access);
        }
        if (accessCodeEntry.getResourceRolesRequested().size() > 0) {
            Map resourceMap = realm.getApplicationNameMap();
            for (String resourceName : accessCodeEntry.getResourceRolesRequested().keySet()) {
                ApplicationModel resource = (ApplicationModel)resourceMap.get(resourceName);
                SkeletonKeyToken.Access access = token.addAccess(resourceName).verifyCaller(Boolean.valueOf(resource.isSurrogateAuthRequired()));
                for (RoleModel role : (List)accessCodeEntry.getResourceRolesRequested().get((Object)resourceName)) {
                    access.addRole(role.getName());
                }
            }
        }
        accessCodeEntry.setToken(token);
    }

    public String encodeScope(SkeletonKeyScope scope) {
        String token = null;
        try {
            token = JsonSerialization.toString((Object)scope, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Base64Url.encode((byte[])token.getBytes());
    }

    public SkeletonKeyScope decodeScope(String scopeParam) {
        SkeletonKeyScope scope = null;
        byte[] bytes = Base64Url.decode((String)scopeParam);
        try {
            scope = (SkeletonKeyScope)JsonSerialization.fromBytes(SkeletonKeyScope.class, (byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return scope;
    }

    public SkeletonKeyToken createAccessToken(RealmModel realm, UserModel user) {
        Set realmMapping;
        List resources = realm.getApplications();
        SkeletonKeyToken token = new SkeletonKeyToken();
        token.id(RealmManager.generateId());
        token.issuedNow();
        token.principal(user.getLoginName());
        token.audience(realm.getId());
        if (realm.getTokenLifespan() > 0) {
            token.expiration(System.currentTimeMillis() / 1000L + (long)realm.getTokenLifespan());
        }
        if ((realmMapping = realm.getRoleMappingValues(user)) != null && realmMapping.size() > 0) {
            SkeletonKeyToken.Access access = new SkeletonKeyToken.Access();
            for (String role : realmMapping) {
                access.addRole(role);
            }
            token.setRealmAccess(access);
        }
        if (resources != null) {
            for (ApplicationModel resource : resources) {
                Set mapping = resource.getRoleMappingValues(user);
                if (mapping == null) continue;
                SkeletonKeyToken.Access access = token.addAccess(resource.getName()).verifyCaller(Boolean.valueOf(resource.isSurrogateAuthRequired()));
                for (String role : mapping) {
                    access.addRole(role);
                }
            }
        }
        return token;
    }

    public String encodeToken(RealmModel realm, Object token) {
        byte[] tokenBytes = null;
        try {
            tokenBytes = JsonSerialization.toByteArray((Object)token, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String encodedToken = new JWSBuilder().content(tokenBytes).rsa256(realm.getPrivateKey());
        return encodedToken;
    }
}

