/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.SkeletonKeyContextResolver;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelProvider;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.QRCodeResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SaasService;
import org.keycloak.services.resources.SocialResource;

public class KeycloakApplication
extends Application {
    private static final Logger log = Logger.getLogger(KeycloakApplication.class);
    private static final String MODEL_PROVIDER = "keycloak.model";
    private static final String DEFAULT_MODEL_PROVIDER = "jpa";
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected KeycloakSessionFactory factory = KeycloakApplication.createSessionFactory();

    public KeycloakApplication(@Context ServletContext context) {
        context.setAttribute(KeycloakSessionFactory.class.getName(), (Object)this.factory);
        TokenManager tokenManager = new TokenManager();
        this.singletons.add(new RealmsResource(tokenManager));
        this.singletons.add(new SaasService(tokenManager));
        this.singletons.add(new SocialResource(tokenManager, new SocialRequestManager()));
        this.classes.add(SkeletonKeyContextResolver.class);
        this.classes.add(QRCodeResource.class);
    }

    public static KeycloakSessionFactory createSessionFactory() {
        ServiceLoader<ModelProvider> providers = ServiceLoader.load(ModelProvider.class);
        String configuredProvider = System.getProperty(MODEL_PROVIDER);
        ModelProvider provider = null;
        if (configuredProvider != null) {
            for (ModelProvider p : providers) {
                if (!p.getId().equals(configuredProvider)) continue;
                provider = p;
            }
        } else {
            for (ModelProvider p : providers) {
                if (provider == null) {
                    provider = p;
                }
                if (!p.getId().equals(DEFAULT_MODEL_PROVIDER)) continue;
                provider = p;
                break;
            }
        }
        if (provider != null) {
            log.debug("Model provider: " + provider.getId());
            return provider.createFactory();
        }
        throw new RuntimeException("Model provider not found");
    }

    public KeycloakSessionFactory getFactory() {
        return this.factory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

