/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.security.PublicKey;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.jose.jws.JWSInput;
import org.jboss.resteasy.jose.jws.crypto.RSAProvider;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.keycloak.jaxrs.JaxrsOAuthClient;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.admin.RealmsAdminResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;

@Path(value="/saas")
public class SaasService {
    protected static final Logger logger = Logger.getLogger(SaasService.class);
    public static final String REALM_CREATOR_ROLE = "realm-creator";
    public static final String SAAS_IDENTITY_COOKIE = "KEYCLOAK_SAAS_IDENTITY";
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Providers providers;
    protected String adminPath = "/admin/index.html";
    protected AuthenticationManager authManager = new AuthenticationManager();
    protected TokenManager tokenManager;

    public SaasService(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    @Path(value="keepalive")
    @GET
    @NoCache
    public Response keepalive(@Context HttpHeaders headers) {
        logger.debug("keepalive");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        if (realm == null) {
            throw new NotFoundException();
        }
        UserModel user = this.authManager.authenticateSaasIdentityCookie(realm, this.uriInfo, headers);
        if (user == null) {
            return Response.status((int)401).build();
        }
        NewCookie refreshCookie = this.authManager.createSaasIdentityCookie(realm, user, this.uriInfo);
        return Response.noContent().cookie(new NewCookie[]{refreshCookie}).build();
    }

    @Path(value="whoami")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response whoAmI(@Context HttpHeaders headers) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        if (realm == null) {
            throw new NotFoundException();
        }
        UserModel user = this.authManager.authenticateSaasIdentityCookie(realm, this.uriInfo, headers);
        if (user == null) {
            return Response.status((int)401).build();
        }
        return Response.ok((Object)new WhoAmI(user.getLoginName(), user.getLoginName())).build();
    }

    @Path(value="isLoggedIn.js")
    @GET
    @Produces(value={"application/javascript"})
    @NoCache
    public String isLoggedIn(@Context HttpHeaders headers) {
        logger.debug("WHOAMI Javascript start.");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        if (realm == null) {
            return "var keycloakCookieLoggedIn = false;";
        }
        UserModel user = this.authManager.authenticateSaasIdentityCookie(realm, this.uriInfo, headers);
        if (user == null) {
            return "var keycloakCookieLoggedIn = false;";
        }
        logger.debug("WHOAMI: " + user.getLoginName());
        return "var keycloakCookieLoggedIn = true;";
    }

    public static UriBuilder contextRoot(UriInfo uriInfo) {
        return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).replacePath("/auth-server");
    }

    public static UriBuilder saasCookiePath(UriInfo uriInfo) {
        return SaasService.contextRoot(uriInfo).path("rest").path(SaasService.class);
    }

    @Path(value="admin/realms")
    public RealmsAdminResource getRealmsAdmin(@Context HttpHeaders headers) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel saasRealm = this.getAdminstrationRealm(realmManager);
        if (saasRealm == null) {
            throw new NotFoundException();
        }
        UserModel admin = this.authManager.authenticateSaasIdentity(saasRealm, this.uriInfo, headers);
        if (admin == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        ApplicationModel adminConsole = (ApplicationModel)saasRealm.getApplicationNameMap().get("Admin Console");
        if (adminConsole == null) {
            throw new NotFoundException();
        }
        RoleModel adminRole = adminConsole.getRole("admin");
        if (!adminConsole.hasRole(admin, adminRole)) {
            logger.warn("not a Realm admin");
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        RealmsAdminResource adminResource = new RealmsAdminResource(admin);
        this.resourceContext.initResource((Object)adminResource);
        return adminResource;
    }

    @Path(value="login")
    @GET
    @NoCache
    public Response loginPage(@QueryParam(value="path") String path) {
        logger.debug("loginPage ********************** <---");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        this.authManager.expireSaasIdentityCookie(this.uriInfo);
        JaxrsOAuthClient oauth = new JaxrsOAuthClient();
        String authUrl = TokenService.loginPageUrl(this.uriInfo).build(new Object[]{"Keycloak Administration"}).toString();
        logger.debug("authUrl: {0}", new Object[]{authUrl});
        oauth.setAuthUrl(authUrl);
        oauth.setClientId("Admin Console");
        URI redirectUri = this.uriInfo.getBaseUriBuilder().path(SaasService.class).path(SaasService.class, "loginRedirect").build(new Object[0]);
        logger.debug("redirectUri: {0}", new Object[]{redirectUri.toString()});
        oauth.setStateCookiePath(redirectUri.getPath());
        return oauth.redirect(this.uriInfo, redirectUri.toString(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="login-redirect")
    @GET
    @NoCache
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @Context HttpHeaders headers) {
        try {
            logger.info("loginRedirect ********************** <---");
            if (error != null) {
                logger.debug("error from oauth");
                throw new ForbiddenException("error");
            }
            RealmManager realmManager = new RealmManager(this.session);
            RealmModel realm = this.getAdminstrationRealm(realmManager);
            if (!realm.isEnabled()) {
                logger.debug("realm not enabled");
                throw new ForbiddenException();
            }
            ApplicationModel adminConsole = (ApplicationModel)realm.getApplicationNameMap().get("Admin Console");
            UserModel adminConsoleUser = adminConsole.getApplicationUser();
            if (!adminConsole.isEnabled() || !adminConsoleUser.isEnabled()) {
                logger.debug("admin app not enabled");
                throw new ForbiddenException();
            }
            if (code == null) {
                logger.debug("code not specified");
                throw new BadRequestException();
            }
            if (state == null) {
                logger.debug("state not specified");
                throw new BadRequestException();
            }
            String path = new JaxrsOAuthClient().checkStateCookie(this.uriInfo, headers);
            JWSInput input = new JWSInput(code, this.providers);
            boolean verifiedCode = false;
            try {
                verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)realm.getPublicKey());
            }
            catch (Exception ignored) {
                logger.debug("Failed to verify signature", (Throwable)ignored);
            }
            if (!verifiedCode) {
                logger.debug("unverified access code");
                throw new BadRequestException();
            }
            String key = (String)input.readContent(String.class);
            AccessCodeEntry accessCode = this.tokenManager.pullAccessCode(key);
            if (accessCode == null) {
                logger.debug("bad access code");
                throw new BadRequestException();
            }
            if (accessCode.isExpired()) {
                logger.debug("access code expired");
                throw new BadRequestException();
            }
            if (!accessCode.getToken().isActive()) {
                logger.debug("access token expired");
                throw new BadRequestException();
            }
            if (!accessCode.getRealm().getId().equals(realm.getId())) {
                logger.debug("bad realm");
                throw new BadRequestException();
            }
            if (!adminConsoleUser.getLoginName().equals(accessCode.getClient().getLoginName())) {
                logger.debug("bad client");
                throw new BadRequestException();
            }
            if (!adminConsole.hasRole(accessCode.getUser(), "admin")) {
                logger.debug("not allowed");
                throw new ForbiddenException();
            }
            logger.debug("loginRedirect SUCCESS");
            NewCookie cookie = this.authManager.createSaasIdentityCookie(realm, accessCode.getUser(), this.uriInfo);
            URI redirectUri = SaasService.contextRoot(this.uriInfo).path(this.adminPath).build(new Object[0]);
            if (path != null) {
                redirectUri = redirectUri.resolve("#" + UriBuilder.fromPath((String)path).build(new Object[0]).toString());
            }
            Response response = Response.status((int)302).cookie(new NewCookie[]{cookie}).location(redirectUri).build();
            return response;
        }
        finally {
            this.authManager.expireCookie("OAuth_Token_Request_State", this.uriInfo.getAbsolutePath().getPath());
        }
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout() {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        this.authManager.expireSaasIdentityCookie(this.uriInfo);
        this.authManager.expireIdentityCookie(realm, this.uriInfo);
        return Response.status((int)302).location(this.uriInfo.getBaseUriBuilder().path(SaasService.class).path(SaasService.class, "loginPage").build(new Object[0])).build();
    }

    @Path(value="logout-cookie")
    @GET
    @NoCache
    public void logoutCookie() {
        logger.debug("*** logoutCookie");
        this.authManager.expireSaasIdentityCookie(this.uriInfo);
    }

    @Path(value="login")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processLogin(MultivaluedMap<String, String> formData) {
        logger.debug("processLogin start");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        if (realm == null) {
            throw new NotFoundException();
        }
        ApplicationModel adminConsole = (ApplicationModel)realm.getApplicationNameMap().get("Admin Console");
        UserModel adminConsoleUser = adminConsole.getApplicationUser();
        if (!realm.isEnabled()) {
            throw new NotImplementedYetException();
        }
        String username = (String)formData.getFirst((Object)"username");
        UserModel user = realm.getUser(username);
        AuthenticationManager.AuthenticationStatus status = this.authManager.authenticateForm(realm, user, formData);
        OAuthFlows oauth = Flows.oauth(realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        switch (status) {
            case SUCCESS: {
                NewCookie cookie = this.authManager.createSaasIdentityCookie(realm, user, this.uriInfo);
                return Response.status((int)302).cookie(new NewCookie[]{cookie}).location(SaasService.contextRoot(this.uriInfo).path(this.adminPath).build(new Object[0])).build();
            }
            case ACCOUNT_DISABLED: {
                return Flows.forms(realm, this.request, this.uriInfo).setError("accountDisabled").setFormData(formData).forwardToLogin();
            }
            case ACTIONS_REQUIRED: {
                return oauth.processAccessCode(null, "n", SaasService.contextRoot(this.uriInfo).path(this.adminPath).build(new Object[0]).toString(), adminConsoleUser, user);
            }
        }
        return Flows.forms(realm, this.request, this.uriInfo).setError("invalidUser").setFormData(formData).forwardToLogin();
    }

    protected RealmModel getAdminstrationRealm(RealmManager realmManager) {
        return realmManager.getKeycloakAdminstrationRealm();
    }

    public static class WhoAmI {
        protected String userId;
        protected String displayName;

        public WhoAmI() {
        }

        public WhoAmI(String userId, String displayName) {
            this.userId = userId;
            this.displayName = displayName;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

