/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.spi.ServiceRegistry;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.RequestDetails;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;

@Path(value="/social")
public class SocialResource {
    protected static Logger logger = Logger.getLogger(SocialResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    private HttpRequest request;
    @Context
    private HttpResponse response;
    @Context
    ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;
    private SocialRequestManager socialRequestManager;
    private TokenManager tokenManager;
    private AuthenticationManager authManager = new AuthenticationManager();

    public SocialResource(TokenManager tokenManager, SocialRequestManager socialRequestManager) {
        this.tokenManager = tokenManager;
        this.socialRequestManager = socialRequestManager;
    }

    @GET
    @Path(value="callback")
    public Response callback() throws URISyntaxException {
        Map<String, String[]> queryParams = this.getQueryParams();
        RequestDetails requestData = this.getRequestDetails(queryParams);
        SocialProvider provider = this.getProvider(requestData.getProviderId());
        String realmId = requestData.getClientAttribute("realmId");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealm(realmId);
        OAuthFlows oauth = Flows.oauth(realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!realm.isEnabled()) {
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        String clientId = (String)requestData.getClientAttributes().get("clientId");
        UserModel client = realm.getUser(clientId);
        if (client == null) {
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        String key = (String)realm.getSocialConfig().get(requestData.getProviderId() + ".key");
        String secret = (String)realm.getSocialConfig().get(requestData.getProviderId() + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        AuthCallback callback = new AuthCallback(requestData.getSocialAttributes(), queryParams);
        SocialUser socialUser = null;
        try {
            socialUser = provider.processCallback(config, callback);
        }
        catch (SocialProviderException e) {
            logger.warn("Failed to process social callback", (Throwable)e);
            return oauth.forwardToSecurityFailure("Failed to process social callback");
        }
        SocialLinkModel socialLink = new SocialLinkModel(provider.getId(), socialUser.getUsername());
        UserModel user = realm.getUserBySocialLink(socialLink);
        if (user == null) {
            if (!realm.isRegistrationAllowed()) {
                return oauth.forwardToSecurityFailure("Registration not allowed");
            }
            if (realm.isAutomaticRegistrationAfterSocialLogin()) {
                if (realm.getUser(socialUser.getUsername()) != null) {
                    throw new IllegalStateException("Username " + socialUser.getUsername() + " already registered in the realm. TODO: bind accounts...");
                }
                user = realm.addUser(socialUser.getUsername());
                user.setEnabled(true);
                user.setFirstName(socialUser.getFirstName());
                user.setLastName(socialUser.getLastName());
                user.setEmail(socialUser.getEmail());
                realm.addSocialLink(user, socialLink);
            } else {
                MultivaluedMap<String, String> formData = this.fillRegistrationFormWithSocialData(socialUser);
                String requestId = UUID.randomUUID().toString();
                this.socialRequestManager.addRequest(requestId, RequestDetails.create((RequestDetails)requestData).build());
                boolean secureOnly = !realm.isSslNotRequired();
                String cookiePath = Urls.socialBase(this.uriInfo.getBaseUri()).build(new Object[0]).getPath();
                logger.debug("creating cookie for social registration - name: {0} path: {1}", new Object[]{"SOCIAL_REGISTRATION_COOKIE", cookiePath});
                NewCookie newCookie = new NewCookie("SOCIAL_REGISTRATION_COOKIE", requestId, cookiePath, null, "Added social cookie", -1, secureOnly);
                this.response.addNewCookie(newCookie);
                return Flows.forms(realm, this.request, this.uriInfo).setFormData(formData).setSocialRegistration(true).forwardToRegistration();
            }
        }
        if (!user.isEnabled()) {
            return oauth.forwardToSecurityFailure("Your account is not enabled.");
        }
        String scope = (String)requestData.getClientAttributes().get("scope");
        String state = (String)requestData.getClientAttributes().get("state");
        String redirectUri = (String)requestData.getClientAttributes().get("redirectUri");
        return oauth.processAccessCode(scope, state, redirectUri, client, user);
    }

    @GET
    @Path(value="{realm}/login")
    public Response redirectToProviderAuth(@PathParam(value="realm") String realmId, @QueryParam(value="provider_id") String providerId, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scope, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirectUri) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealm(realmId);
        SocialProvider provider = this.getProvider(providerId);
        if (provider == null) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Social provider not found").forwardToErrorPage();
        }
        String key = (String)realm.getSocialConfig().get(providerId + ".key");
        String secret = (String)realm.getSocialConfig().get(providerId + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        try {
            AuthRequest authRequest = provider.getAuthUrl(config);
            RequestDetails socialRequest = RequestDetails.create((String)providerId).putSocialAttributes(authRequest.getAttributes()).putClientAttribute("realmId", realmId).putClientAttribute("clientId", clientId).putClientAttribute("scope", scope).putClientAttribute("state", state).putClientAttribute("redirectUri", redirectUri).build();
            this.socialRequestManager.addRequest(authRequest.getId(), socialRequest);
            return Response.status((Response.Status)Response.Status.FOUND).location(authRequest.getAuthUri()).build();
        }
        catch (Throwable t) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Failed to redirect to social auth").forwardToErrorPage();
        }
    }

    @POST
    @Path(value="{realm}/socialRegistration")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response socialRegistration(@PathParam(value="realm") String realmId, MultivaluedMap<String, String> formData) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealm(realmId);
        Cookie cookie = (Cookie)this.headers.getCookies().get("SOCIAL_REGISTRATION_COOKIE");
        if (cookie == null) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Social registration cookie not found").forwardToErrorPage();
        }
        String requestId = cookie.getValue();
        if (!this.socialRequestManager.isRequestId(requestId)) {
            logger.error("Unknown requestId found in cookie. Maybe it's expired. requestId=" + requestId);
            return Flows.forms(realm, this.request, this.uriInfo).setError("Unknown requestId found in cookie. Maybe it's expired.").forwardToErrorPage();
        }
        RequestDetails requestData = this.socialRequestManager.getData(requestId);
        if (realm == null || !realm.isEnabled()) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Realm doesn't exists or is not enabled.").forwardToErrorPage();
        }
        TokenService tokenService = new TokenService(realm, this.tokenManager);
        this.resourceContext.initResource((Object)tokenService);
        String clientId = requestData.getClientAttribute("clientId");
        String scope = requestData.getClientAttribute("scope");
        String state = requestData.getClientAttribute("state");
        String redirectUri = requestData.getClientAttribute("redirectUri");
        Response response1 = tokenService.processRegisterImpl(clientId, scope, state, redirectUri, formData, true);
        if (response1 != null || this.request.wasForwarded()) {
            logger.warn("Registration attempt wasn't successful. Request already forwarded or redirected.");
            return response1;
        }
        String username = (String)formData.getFirst((Object)"username");
        UserModel user = realm.getUser(username);
        if (user == null) {
            throw new IllegalStateException("User " + username + " not found in the realm");
        }
        realm.addSocialLink(user, new SocialLinkModel(requestData.getProviderId(), username));
        String cookiePath = Urls.socialBase(this.uriInfo.getBaseUri()).build(new Object[0]).getPath();
        NewCookie newCookie = new NewCookie("SOCIAL_REGISTRATION_COOKIE", "", cookiePath, null, "Expire social cookie", 0, false);
        logger.debug("Expiring social registration cookie: {0}, path: {1}", new Object[]{"SOCIAL_REGISTRATION_COOKIE", cookiePath});
        this.response.addNewCookie(newCookie);
        this.socialRequestManager.retrieveData(requestId);
        return tokenService.processLogin(clientId, scope, state, redirectUri, formData);
    }

    private RequestDetails getRequestDetails(Map<String, String[]> queryParams) {
        Iterator<SocialProvider> itr = ServiceRegistry.lookupProviders(SocialProvider.class);
        while (itr.hasNext()) {
            String requestId;
            SocialProvider provider = itr.next();
            if (!queryParams.containsKey(provider.getRequestIdParamName()) || !this.socialRequestManager.isRequestId(requestId = queryParams.get(provider.getRequestIdParamName())[0])) continue;
            return this.socialRequestManager.retrieveData(requestId);
        }
        return null;
    }

    private SocialProvider getProvider(String providerId) {
        Iterator<SocialProvider> itr = ServiceRegistry.lookupProviders(SocialProvider.class);
        while (itr.hasNext()) {
            SocialProvider provider = itr.next();
            if (!provider.getId().equals(providerId)) continue;
            return provider;
        }
        return null;
    }

    private Map<String, String[]> getQueryParams() {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            queryParams.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]));
        }
        return queryParams;
    }

    protected MultivaluedMap<String, String> fillRegistrationFormWithSocialData(SocialUser socialUser) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.putSingle((Object)"username", (Object)socialUser.getUsername());
        if (socialUser.getEmail() != null) {
            formData.putSingle((Object)"email", (Object)socialUser.getEmail());
        }
        String fullName = null;
        fullName = socialUser.getFirstName() == null ? socialUser.getLastName() : (socialUser.getLastName() == null ? socialUser.getFirstName() : socialUser.getFirstName() + " " + socialUser.getLastName());
        formData.putSingle((Object)"name", (Object)fullName);
        return formData;
    }
}

