/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.SaasService;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.flows.Flows;

public class RealmsAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmsAdminResource.class);
    protected UserModel admin;
    public static final CacheControl noCache = new CacheControl();
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;

    public RealmsAdminResource(UserModel admin) {
        this.admin = admin;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<RealmRepresentation> getRealms() {
        logger.debug("getRealms()");
        RealmManager realmManager = new RealmManager(this.session);
        List realms = this.session.getRealms(this.admin);
        ArrayList<RealmRepresentation> reps = new ArrayList<RealmRepresentation>();
        for (RealmModel realm : realms) {
            reps.add(RealmManager.toRepresentation(realm));
        }
        return reps;
    }

    public static UriBuilder realmUrl(UriInfo uriInfo) {
        return RealmsAdminResource.realmsUrl(uriInfo).path("{id}");
    }

    public static UriBuilder realmsUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(SaasService.class).path(SaasService.class, "getRealmsAdmin");
    }

    @POST
    @Consumes(value={"application/json"})
    public Response importRealm(@Context UriInfo uriInfo, RealmRepresentation rep) {
        logger.debug("importRealm: {0}", new Object[]{rep.getRealm()});
        RealmManager realmManager = new RealmManager(this.session);
        if (realmManager.getRealm(rep.getRealm()) != null) {
            return Flows.errors().exists("Realm " + rep.getRealm() + " already exists");
        }
        RealmModel realm = realmManager.importRealm(rep, this.admin);
        URI location = RealmsAdminResource.realmUrl(uriInfo).build(new Object[]{realm.getId()});
        logger.debug("imported realm success, sending back: {0}", new Object[]{location.toString()});
        return Response.created((URI)location).build();
    }

    @Path(value="{id}")
    public RealmAdminResource getRealmAdmin(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealm(id);
        if (realm == null) {
            throw new NotFoundException();
        }
        RealmAdminResource adminResource = new RealmAdminResource(this.admin, realm);
        this.resourceContext.initResource((Object)adminResource);
        return adminResource;
    }

    static {
        noCache.setNoCache(true);
    }
}

