/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.flows.Flows;

public class RoleContainerResource {
    protected RoleContainerModel roleContainer;

    public RoleContainerResource(RoleContainerModel roleContainer) {
        this.roleContainer = roleContainer;
    }

    @Path(value="roles")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<RoleRepresentation> getRoles() {
        List roleModels = this.roleContainer.getRoles();
        ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roleModels) {
            if (roleModel.getName().startsWith("KEYCLOAK_")) continue;
            RoleRepresentation role = new RoleRepresentation(roleModel.getName(), roleModel.getDescription());
            role.setId(roleModel.getId());
            roles.add(role);
        }
        return roles;
    }

    @Path(value="roles/{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="id") String id) {
        RoleModel roleModel = this.roleContainer.getRoleById(id);
        if (roleModel == null || roleModel.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException();
        }
        RoleRepresentation rep = new RoleRepresentation(roleModel.getName(), roleModel.getDescription());
        rep.setId(roleModel.getId());
        return rep;
    }

    @Path(value="roles/{id}")
    @DELETE
    @NoCache
    public void deleteRole(@PathParam(value="id") String id) {
        if (!this.roleContainer.removeRole(id)) {
            throw new NotFoundException();
        }
    }

    @Path(value="roles/{id}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRole(@PathParam(value="id") String id, RoleRepresentation rep) {
        RoleModel role = this.roleContainer.getRoleById(id);
        if (role == null || role.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException();
        }
        role.setName(rep.getName());
        role.setDescription(rep.getDescription());
    }

    @Path(value="roles")
    @POST
    @Consumes(value={"application/json"})
    public Response createRole(@Context UriInfo uriInfo, RoleRepresentation rep) {
        if (this.roleContainer.getRole(rep.getName()) != null || rep.getName().startsWith("KEYCLOAK_")) {
            return Flows.errors().exists("Role with name " + rep.getName() + " already exists");
        }
        RoleModel role = this.roleContainer.addRole(rep.getName());
        if (role == null) {
            throw new NotFoundException();
        }
        role.setDescription(rep.getDescription());
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(role.getId()).build(new Object[0])).build();
    }
}

