/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.flows.FormFlows;
import org.keycloak.social.SocialProvider;

public interface FormService {
    public String getId();

    public String process(String var1, FormServiceDataBean var2);

    public static class FormServiceDataBean {
        private RealmModel realm;
        private UserModel userModel;
        private String message;
        private FormFlows.MessageType messageType;
        private MultivaluedMap<String, String> formData;
        private Map<String, String> queryParams;
        private URI baseURI;
        private List<SocialProvider> socialProviders;
        private Boolean socialRegistration;
        private String code;
        private String contextPath;
        private MultivaluedMap<String, RoleModel> oAuthResourceRolesRequested;
        private List<RoleModel> oAuthRealmRolesRequested;
        private UserModel oAuthClient;
        private String oAuthCode;
        private String oAuthAction;

        public Boolean getSocialRegistration() {
            return this.socialRegistration;
        }

        public void setSocialRegistration(Boolean socialRegistration) {
            this.socialRegistration = socialRegistration;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        public FormServiceDataBean(RealmModel realm, UserModel userModel, MultivaluedMap<String, String> formData, Map<String, String> queryParams, String message) {
            this.realm = realm;
            this.userModel = userModel;
            this.formData = formData;
            this.queryParams = queryParams;
            this.message = message;
            this.socialProviders = new LinkedList<SocialProvider>();
            Map socialConfig = realm.getSocialConfig();
            if (socialConfig != null) {
                Iterator<SocialProvider> itr = ServiceRegistry.lookupProviders(SocialProvider.class);
                while (itr.hasNext()) {
                    SocialProvider p = itr.next();
                    if (!socialConfig.containsKey(p.getId() + ".key") || !socialConfig.containsKey(p.getId() + ".secret")) continue;
                    this.socialProviders.add(p);
                }
            }
        }

        public URI getBaseURI() {
            return this.baseURI;
        }

        public void setBaseURI(URI baseURI) {
            this.baseURI = baseURI;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public MultivaluedMap<String, String> getFormData() {
            return this.formData;
        }

        public Map<String, String> getQueryParams() {
            return this.queryParams;
        }

        public String getQueryParam(String key) {
            return this.queryParams != null ? this.queryParams.get(key) : null;
        }

        public void setFormData(MultivaluedMap<String, String> formData) {
            this.formData = formData;
        }

        public RealmModel getRealm() {
            return this.realm;
        }

        public RealmModel setRealm(RealmModel realm) {
            return realm;
        }

        public UserModel getUserModel() {
            return this.userModel;
        }

        public void setUserModel(UserModel userModel) {
            this.userModel = userModel;
        }

        public List<SocialProvider> getSocialProviders() {
            return this.socialProviders;
        }

        public FormFlows.MessageType getMessageType() {
            return this.messageType;
        }

        public void setMessageType(FormFlows.MessageType messageType) {
            this.messageType = messageType;
        }

        public String getOAuthAction() {
            return this.oAuthAction;
        }

        public void setOAuthAction(String action) {
            this.oAuthAction = action;
        }

        public MultivaluedMap<String, RoleModel> getOAuthResourceRolesRequested() {
            return this.oAuthResourceRolesRequested;
        }

        public void setOAuthResourceRolesRequested(MultivaluedMap<String, RoleModel> resourceRolesRequested) {
            this.oAuthResourceRolesRequested = resourceRolesRequested;
        }

        public List<RoleModel> getOAuthRealmRolesRequested() {
            return this.oAuthRealmRolesRequested;
        }

        public void setOAuthRealmRolesRequested(List<RoleModel> realmRolesRequested) {
            this.oAuthRealmRolesRequested = realmRolesRequested;
        }

        public UserModel getOAuthClient() {
            return this.oAuthClient;
        }

        public void setOAuthClient(UserModel client) {
            this.oAuthClient = client;
        }

        public String getOAuthCode() {
            return this.oAuthCode;
        }

        public void setOAuthCode(String oAuthCode) {
            this.oAuthCode = oAuthCode;
        }
    }
}

