/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.jose.jws.JWSBuilder;
import org.jboss.resteasy.jwt.JsonSerialization;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SaasService;

public class AuthenticationManager {
    protected Logger logger = Logger.getLogger(AuthenticationManager.class);
    public static final String FORM_USERNAME = "username";
    public static final String KEYCLOAK_IDENTITY_COOKIE = "KEYCLOAK_IDENTITY";

    public SkeletonKeyToken createIdentityToken(RealmModel realm, String username) {
        SkeletonKeyToken token = new SkeletonKeyToken();
        token.id(RealmManager.generateId());
        token.issuedNow();
        token.principal(username);
        token.audience(realm.getId());
        if (realm.getTokenLifespan() > 0) {
            token.expiration(System.currentTimeMillis() / 1000L + (long)realm.getTokenLifespan());
        }
        return token;
    }

    public NewCookie createLoginCookie(RealmModel realm, UserModel user, UriInfo uriInfo) {
        String cookieName = KEYCLOAK_IDENTITY_COOKIE;
        URI uri = RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getId()});
        String cookiePath = uri.getPath();
        return this.createLoginCookie(realm, user, null, cookieName, cookiePath);
    }

    public NewCookie createSaasIdentityCookie(RealmModel realm, UserModel user, UriInfo uriInfo) {
        String cookieName = "KEYCLOAK_SAAS_IDENTITY";
        URI uri = SaasService.saasCookiePath(uriInfo).build(new Object[0]);
        String cookiePath = uri.getPath();
        return this.createLoginCookie(realm, user, null, cookieName, cookiePath);
    }

    public NewCookie createAccountIdentityCookie(RealmModel realm, UserModel user, UserModel client, URI uri) {
        String cookieName = "KEYCLOAK_ACCOUNT_IDENTITY";
        String cookiePath = uri.getPath();
        return this.createLoginCookie(realm, user, client, cookieName, cookiePath);
    }

    protected NewCookie createLoginCookie(RealmModel realm, UserModel user, UserModel client, String cookieName, String cookiePath) {
        SkeletonKeyToken identityToken = this.createIdentityToken(realm, user.getLoginName());
        if (client != null) {
            identityToken.issuedFor(client.getLoginName());
        }
        String encoded = this.encodeToken(realm, identityToken);
        boolean secureOnly = !realm.isSslNotRequired();
        this.logger.debug("creatingLoginCookie - name: {0} path: {1}", new Object[]{cookieName, cookiePath});
        NewCookie cookie = new NewCookie(cookieName, encoded, cookiePath, null, null, -1, secureOnly, true);
        return cookie;
    }

    protected String encodeToken(RealmModel realm, Object token) {
        byte[] tokenBytes = null;
        try {
            tokenBytes = JsonSerialization.toByteArray((Object)token, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String encodedToken = new JWSBuilder().content(tokenBytes).rsa256(realm.getPrivateKey());
        return encodedToken;
    }

    public void expireIdentityCookie(RealmModel realm, UriInfo uriInfo) {
        URI uri = RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getId()});
        this.logger.debug("Expiring identity cookie");
        String path = uri.getPath();
        String cookieName = KEYCLOAK_IDENTITY_COOKIE;
        this.expireCookie(cookieName, path);
    }

    public void expireSaasIdentityCookie(UriInfo uriInfo) {
        URI uri = SaasService.saasCookiePath(uriInfo).build(new Object[0]);
        String cookiePath = uri.getPath();
        this.expireCookie("KEYCLOAK_SAAS_IDENTITY", cookiePath);
    }

    public void expireAccountIdentityCookie(URI uri) {
        String cookiePath = uri.getPath();
        this.expireCookie("KEYCLOAK_ACCOUNT_IDENTITY", cookiePath);
    }

    public void expireCookie(String cookieName, String path) {
        HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
        if (response == null) {
            this.logger.debug("can't expire identity cookie, no HttpResponse");
            return;
        }
        this.logger.debug("Expiring cookie: {0} path: {1}", new Object[]{cookieName, path});
        NewCookie expireIt = new NewCookie(cookieName, "", path, null, "Expiring cookie", 0, false);
        response.addNewCookie(expireIt);
    }

    public UserModel authenticateIdentityCookie(RealmModel realm, UriInfo uriInfo, HttpHeaders headers) {
        String cookieName = KEYCLOAK_IDENTITY_COOKIE;
        Auth auth = this.authenticateIdentityCookie(realm, uriInfo, headers, cookieName);
        return auth != null ? auth.getUser() : null;
    }

    public UserModel authenticateSaasIdentityCookie(RealmModel realm, UriInfo uriInfo, HttpHeaders headers) {
        String cookieName = "KEYCLOAK_SAAS_IDENTITY";
        Auth auth = this.authenticateIdentityCookie(realm, uriInfo, headers, cookieName);
        return auth != null ? auth.getUser() : null;
    }

    public Auth authenticateAccountIdentityCookie(RealmModel realm, UriInfo uriInfo, HttpHeaders headers) {
        String cookieName = "KEYCLOAK_ACCOUNT_IDENTITY";
        return this.authenticateIdentityCookie(realm, uriInfo, headers, cookieName);
    }

    public UserModel authenticateSaasIdentity(RealmModel realm, UriInfo uriInfo, HttpHeaders headers) {
        UserModel user = this.authenticateSaasIdentityCookie(realm, uriInfo, headers);
        if (user != null) {
            return user;
        }
        Auth auth = this.authenticateBearerToken(realm, headers);
        return auth != null ? auth.getUser() : null;
    }

    public Auth authenticateAccountIdentity(RealmModel realm, UriInfo uriInfo, HttpHeaders headers) {
        Auth auth = this.authenticateAccountIdentityCookie(realm, uriInfo, headers);
        if (auth != null) {
            return auth;
        }
        return this.authenticateBearerToken(realm, headers);
    }

    protected Auth authenticateIdentityCookie(RealmModel realm, UriInfo uriInfo, HttpHeaders headers, String cookieName) {
        Cookie cookie = (Cookie)headers.getCookies().get(cookieName);
        if (cookie == null) {
            this.logger.debug("authenticateCookie could not find cookie: {0}", new Object[]{cookieName});
            return null;
        }
        String tokenString = cookie.getValue();
        try {
            SkeletonKeyToken token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)realm.getPublicKey(), (String)realm.getId());
            if (!token.isActive()) {
                this.logger.debug("identity cookie expired");
                this.expireIdentityCookie(realm, uriInfo);
                return null;
            }
            Auth auth = new Auth(token);
            UserModel user = realm.getUser(token.getPrincipal());
            if (user == null || !user.isEnabled()) {
                this.logger.debug("Unknown user in identity cookie");
                this.expireIdentityCookie(realm, uriInfo);
                return null;
            }
            auth.setUser(user);
            if (token.getIssuedFor() != null) {
                UserModel client = realm.getUser(token.getIssuedFor());
                if (client == null || !client.isEnabled()) {
                    this.logger.debug("Unknown client in identity cookie");
                    this.expireIdentityCookie(realm, uriInfo);
                    return null;
                }
                auth.setClient(client);
            }
            return auth;
        }
        catch (VerificationException e) {
            this.logger.debug("Failed to verify identity cookie", (Throwable)e);
            this.expireIdentityCookie(realm, uriInfo);
            return null;
        }
    }

    public Auth authenticateBearerToken(RealmModel realm, HttpHeaders headers) {
        String tokenString = null;
        String authHeader = headers.getHeaderString("Authorization");
        if (authHeader == null) {
            return null;
        }
        String[] split = authHeader.trim().split("\\s+");
        if (split == null || split.length != 2) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        if (!split[0].equalsIgnoreCase("Bearer")) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        tokenString = split[1];
        try {
            SkeletonKeyToken token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)realm.getPublicKey(), (String)realm.getId());
            if (!token.isActive()) {
                throw new NotAuthorizedException((Object)"token_expired", new Object[0]);
            }
            Auth auth = new Auth(token);
            UserModel user = realm.getUser(token.getPrincipal());
            if (user == null || !user.isEnabled()) {
                throw new NotAuthorizedException((Object)"invalid_user", new Object[0]);
            }
            auth.setUser(user);
            if (token.getIssuedFor() != null) {
                UserModel client = realm.getUser(token.getIssuedFor());
                if (client == null || !client.isEnabled()) {
                    throw new NotAuthorizedException((Object)"invalid_user", new Object[0]);
                }
                auth.setClient(client);
            }
            return auth;
        }
        catch (VerificationException e) {
            this.logger.error("Failed to verify token", (Throwable)e);
            throw new NotAuthorizedException((Object)"invalid_token", new Object[0]);
        }
    }

    public AuthenticationStatus authenticateForm(RealmModel realm, UserModel user, MultivaluedMap<String, String> formData) {
        if (user == null) {
            this.logger.debug("Not Authenticated! Incorrect user name");
            return AuthenticationStatus.INVALID_USER;
        }
        if (!user.isEnabled()) {
            this.logger.debug("Account is disabled, contact admin.");
            return AuthenticationStatus.ACCOUNT_DISABLED;
        }
        HashSet<String> types = new HashSet<String>();
        List requiredCredentials = null;
        requiredCredentials = realm.hasRole(user, "KEYCLOAK__APPLICATION") ? realm.getRequiredApplicationCredentials() : (realm.hasRole(user, "KEYCLOAK__IDENTITY_REQUESTER") ? realm.getRequiredOAuthClientCredentials() : realm.getRequiredCredentials());
        for (RequiredCredentialModel credential : requiredCredentials) {
            types.add(credential.getType());
        }
        if (types.contains("password")) {
            String password = (String)formData.getFirst((Object)"password");
            if (password == null) {
                this.logger.warn("Password not provided");
                return AuthenticationStatus.MISSING_PASSWORD;
            }
            if (user.isTotp()) {
                String token = (String)formData.getFirst((Object)"totp");
                if (token == null) {
                    this.logger.warn("TOTP token not provided");
                    return AuthenticationStatus.MISSING_TOTP;
                }
                this.logger.debug("validating TOTP");
                if (!realm.validateTOTP(user, password, token)) {
                    return AuthenticationStatus.INVALID_CREDENTIALS;
                }
            } else {
                this.logger.debug("validating password for user: " + user.getLoginName());
                if (!realm.validatePassword(user, password)) {
                    return AuthenticationStatus.INVALID_CREDENTIALS;
                }
            }
            if (!user.getRequiredActions().isEmpty()) {
                return AuthenticationStatus.ACTIONS_REQUIRED;
            }
            return AuthenticationStatus.SUCCESS;
        }
        this.logger.warn("Do not know how to authenticate user");
        return AuthenticationStatus.FAILED;
    }

    public static class Auth {
        private SkeletonKeyToken token;
        private UserModel user;
        private UserModel client;

        public Auth(SkeletonKeyToken token) {
            this.token = token;
        }

        public SkeletonKeyToken getToken() {
            return this.token;
        }

        public UserModel getUser() {
            return this.user;
        }

        public UserModel getClient() {
            return this.client;
        }

        void setUser(UserModel user) {
            this.user = user;
        }

        void setClient(UserModel client) {
            this.client = client;
        }
    }

    public static enum AuthenticationStatus {
        SUCCESS,
        ACCOUNT_DISABLED,
        ACTIONS_REQUIRED,
        INVALID_USER,
        INVALID_CREDENTIALS,
        MISSING_PASSWORD,
        MISSING_TOTP,
        FAILED;

    }
}

