/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.representations.idm.ApplicationInstallationRepresentation;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;

public class ApplicationResource
extends RoleContainerResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    protected ApplicationModel application;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;

    public ApplicationResource(RealmModel realm, ApplicationModel applicationModel, KeycloakSession session) {
        super((RoleContainerModel)applicationModel);
        this.realm = realm;
        this.application = applicationModel;
        this.session = session;
    }

    @PUT
    @Consumes(value={"application/json"})
    public void update(ApplicationRepresentation rep) {
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        applicationManager.updateApplication(rep, this.application);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ApplicationRepresentation getApplication() {
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        return applicationManager.toRepresentation(this.application);
    }

    @GET
    @NoCache
    @Path(value="installation")
    @Produces(value={"application/json"})
    public String getInstallation() throws IOException {
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        ApplicationInstallationRepresentation rep = applicationManager.toInstallationRepresentation(this.realm, this.application, this.uriInfo.getBaseUri());
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rep);
    }

    @DELETE
    @NoCache
    public void deleteApplication() {
        this.realm.removeApplication(this.application.getId());
    }

    @Path(value="credentials")
    @PUT
    @Consumes(value={"application/json"})
    public void updateCredentials(List<CredentialRepresentation> credentials) {
        logger.debug("updateCredentials");
        if (credentials == null) {
            return;
        }
        for (CredentialRepresentation rep : credentials) {
            UserCredentialModel cred = RealmManager.fromRepresentation(rep);
            this.realm.updateCredential(this.application.getApplicationUser(), cred);
        }
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.application.getApplicationUser(), this.session);
    }

    @Path(value="allowed-origins")
    @GET
    @Produces(value={"application/json"})
    public Set<String> getAllowedOrigins() {
        return this.application.getApplicationUser().getWebOrigins();
    }

    @Path(value="allowed-origins")
    @PUT
    @Consumes(value={"application/json"})
    public void updateAllowedOrigins(Set<String> allowedOrigins) {
        this.application.getApplicationUser().setWebOrigins(allowedOrigins);
    }

    @Path(value="allowed-origins")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteAllowedOrigins(Set<String> allowedOrigins) {
        for (String origin : allowedOrigins) {
            this.application.getApplicationUser().removeWebOrigin(origin);
        }
    }
}

