/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.ApplicationResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.flows.Flows;

public class ApplicationsResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;

    public ApplicationsResource(RealmModel realm) {
        this.realm = realm;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<ApplicationRepresentation> getApplications() {
        ArrayList<ApplicationRepresentation> rep = new ArrayList<ApplicationRepresentation>();
        List applicationModels = this.realm.getApplications();
        ApplicationManager resourceManager = new ApplicationManager(new RealmManager(this.session));
        for (ApplicationModel applicationModel : applicationModels) {
            rep.add(resourceManager.toRepresentation(applicationModel));
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createApplication(@Context UriInfo uriInfo, ApplicationRepresentation rep) {
        if (this.realm.getApplicationNameMap().containsKey(rep.getName())) {
            return Flows.errors().exists("Application " + rep.getName() + " already exists");
        }
        ApplicationManager resourceManager = new ApplicationManager(new RealmManager(this.session));
        ApplicationModel applicationModel = resourceManager.createApplication(this.realm, rep);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(applicationModel.getId()).build(new Object[0])).build();
    }

    @Path(value="{id}")
    public ApplicationResource getApplication(@PathParam(value="id") String id) {
        ApplicationModel applicationModel = this.realm.getApplicationById(id);
        if (applicationModel == null) {
            throw new NotFoundException();
        }
        ApplicationResource applicationResource = new ApplicationResource(this.realm, applicationModel, this.session);
        this.resourceContext.initResource((Object)applicationResource);
        return applicationResource;
    }
}

