/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.headers;

import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.headers.DefaultSecurityHeadersOptions;
import org.keycloak.headers.SecurityHeadersOptions;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class DefaultSecurityHeadersProvider
implements SecurityHeadersProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultSecurityHeadersProvider.class);
    private final Map<String, String> headerValues;
    private final KeycloakSession session;
    private DefaultSecurityHeadersOptions options;

    public DefaultSecurityHeadersProvider(KeycloakSession session) {
        this.session = session;
        RealmModel realm = session.getContext().getRealm();
        this.headerValues = realm != null ? realm.getBrowserSecurityHeaders() : BrowserSecurityHeaders.defaultHeaders;
    }

    public SecurityHeadersOptions options() {
        if (this.options == null) {
            this.options = new DefaultSecurityHeadersOptions();
        }
        return this.options;
    }

    public void addHeaders(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.options != null && this.options.isSkipHeaders()) {
            return;
        }
        MediaType requestType = requestContext.getMediaType();
        MediaType responseType = responseContext.getMediaType();
        MultivaluedMap headers = responseContext.getHeaders();
        if (responseType == null && !this.isEmptyMediaTypeAllowed(requestContext, responseContext)) {
            LOGGER.errorv("MediaType not set on path {0}, with response status {1}", (Object)this.session.getContext().getUri().getRequestUri().getPath(), (Object)responseContext.getStatus());
            throw new InternalServerErrorException();
        }
        if (this.isRest(requestType, responseType)) {
            this.addRestHeaders((MultivaluedMap<String, Object>)headers);
        } else if (this.isHtml(requestType, responseType)) {
            this.addHtmlHeaders((MultivaluedMap<String, Object>)headers);
        } else {
            this.addGenericHeaders((MultivaluedMap<String, Object>)headers);
        }
    }

    private void addGenericHeaders(MultivaluedMap<String, Object> headers) {
        this.addHeader("strictTransportSecurity", headers);
        this.addHeader("xContentTypeOptions", headers);
        this.addHeader("xXSSProtection", headers);
    }

    private void addRestHeaders(MultivaluedMap<String, Object> headers) {
        this.addHeader("strictTransportSecurity", headers);
        this.addHeader("xFrameOptions", headers);
        this.addHeader("xContentTypeOptions", headers);
        this.addHeader("xXSSProtection", headers);
    }

    private void addHtmlHeaders(MultivaluedMap<String, Object> headers) {
        BrowserSecurityHeaders.headerAttributeMap.keySet().forEach(k -> this.addHeader((String)k, headers));
        if (this.options != null) {
            String allowedFrameSrc;
            BrowserSecurityHeaders.ContentSecurityPolicyBuilder csp = BrowserSecurityHeaders.ContentSecurityPolicyBuilder.create();
            if (this.options.isAllowAnyFrameAncestor()) {
                headers.remove((Object)"X-Frame-Options");
                csp.frameAncestors(null);
            }
            if ((allowedFrameSrc = this.options.getAllowedFrameSrc()) != null) {
                csp.frameSrc(allowedFrameSrc);
            }
            if (BrowserSecurityHeaders.CONTENT_SECURITY_POLICY_DEFAULT.equals(headers.getFirst((Object)"Content-Security-Policy"))) {
                headers.putSingle((Object)"Content-Security-Policy", (Object)csp.build());
            }
        }
    }

    private void addHeader(String key, MultivaluedMap<String, Object> headers) {
        String header = (String)BrowserSecurityHeaders.headerAttributeMap.get(key);
        String value = this.headerValues.get(key);
        if (value != null && !value.isEmpty()) {
            headers.putSingle((Object)header, (Object)value);
        }
    }

    private boolean isEmptyMediaTypeAllowed(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (!responseContext.hasEntity()) {
            if (this.options != null && this.options.isAllowEmptyContentType()) {
                return true;
            }
            int status = responseContext.getStatus();
            if (status == 201 || status == 204 || status == 301 || status == 302 || status == 303 || status == 400 || status == 401 || status == 403 || status == 404) {
                return true;
            }
            if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
                return true;
            }
        }
        return false;
    }

    private boolean isRest(MediaType requestType, MediaType responseType) {
        MediaType mediaType = responseType != null ? responseType : requestType;
        return this.matches(mediaType, MediaType.APPLICATION_JSON_TYPE) || this.matches(mediaType, MediaType.APPLICATION_XML_TYPE);
    }

    private boolean isHtml(MediaType requestType, MediaType responseType) {
        if (this.matches(responseType, MediaType.TEXT_HTML_TYPE)) {
            return true;
        }
        return this.matches(requestType, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private boolean matches(MediaType a, MediaType b) {
        if (a == null) {
            return b == null;
        }
        return a.getType().equalsIgnoreCase(b.getType()) && a.getSubtype().equalsIgnoreCase(b.getSubtype());
    }
}

