/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.validation;

import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.validation.ValidationMessages;

public class ClientValidator {
    public static boolean validate(ClientRepresentation client, ValidationMessages messages) {
        long urisWithFragmentCount;
        boolean isValid = true;
        if (client.getRedirectUris() != null && (urisWithFragmentCount = client.getRedirectUris().stream().filter(p -> p.contains("#")).count()) > 0L) {
            messages.add("redirectUris", "Redirect URIs must not contain an URI fragment", "clientRedirectURIsFragmentError");
            isValid = false;
        }
        if (client.getRootUrl() != null && client.getRootUrl().contains("#")) {
            messages.add("rootUrl", "Root URL must not contain an URL fragment", "clientRootURLFragmentError");
            isValid = false;
        }
        return isValid;
    }
}

