/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.services.clientpolicy.ClientPolicyLogger;
import org.keycloak.services.clientpolicy.ClientPolicyProvider;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class DefaultClientPolicyProvider
implements ClientPolicyProvider {
    private static final Logger logger = Logger.getLogger(DefaultClientPolicyProvider.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;
    private final Map<String, List<ClientPolicyConditionProvider>> conditionsMap = new HashMap<String, List<ClientPolicyConditionProvider>>();
    private final Map<String, List<ClientPolicyExecutorProvider>> executorsMap = new HashMap<String, List<ClientPolicyExecutorProvider>>();

    public DefaultClientPolicyProvider(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    public void close() {
    }

    public List<ClientPolicyConditionProvider> getConditions() {
        return this.getConditions(this.session.getContext().getRealm());
    }

    public List<ClientPolicyExecutorProvider> getExecutors() {
        return this.getExecutors(this.session.getContext().getRealm());
    }

    public String getName() {
        return this.componentModel.getName();
    }

    public String getProviderId() {
        return this.componentModel.getProviderId();
    }

    private List<String> getConditionIds() {
        return this.componentModel.getConfig().getList((Object)"client-policy-condition-ids");
    }

    private List<String> getExecutorIds() {
        return this.componentModel.getConfig().getList((Object)"client-policy-executor-ids");
    }

    private List<ClientPolicyConditionProvider> getConditions(RealmModel realm) {
        List<ClientPolicyConditionProvider> providers = this.conditionsMap.get(realm.getId());
        if (providers == null) {
            providers = new LinkedList<ClientPolicyConditionProvider>();
            List<String> conditionIds = this.getConditionIds();
            if (conditionIds == null || conditionIds.isEmpty()) {
                return null;
            }
            for (String conditionId : conditionIds) {
                ComponentModel cm = this.session.getContext().getRealm().getComponent(conditionId);
                try {
                    ClientPolicyConditionProvider provider = (ClientPolicyConditionProvider)this.session.getProvider(ClientPolicyConditionProvider.class, cm);
                    providers.add(provider);
                    this.session.enlistForClose((Provider)provider);
                    ClientPolicyLogger.logv(logger, "Loaded Condition id = {0}, name = {1}, provider id = {2}", conditionId, cm.getName(), cm.getProviderId());
                }
                catch (Throwable t) {
                    logger.errorv(t, "Failed to load condition {0}", (Object)cm.getId());
                }
            }
            this.conditionsMap.put(realm.getId(), providers);
        } else {
            ClientPolicyLogger.log(logger, "Use cached conditions.");
        }
        return providers;
    }

    private List<ClientPolicyExecutorProvider> getExecutors(RealmModel realm) {
        List<ClientPolicyExecutorProvider> providers = this.executorsMap.get(realm.getId());
        if (providers == null) {
            providers = new LinkedList<ClientPolicyExecutorProvider>();
            List<String> executorIds = this.getExecutorIds();
            if (executorIds == null || executorIds.isEmpty()) {
                return null;
            }
            for (String executorId : executorIds) {
                ComponentModel cm = this.session.getContext().getRealm().getComponent(executorId);
                try {
                    ClientPolicyExecutorProvider provider = (ClientPolicyExecutorProvider)this.session.getProvider(ClientPolicyExecutorProvider.class, cm);
                    providers.add(provider);
                    this.session.enlistForClose((Provider)provider);
                    ClientPolicyLogger.logv(logger, "Loaded Executor id = {0}, name = {1}, provider id = {2}", executorId, cm.getName(), cm.getProviderId());
                }
                catch (Throwable t) {
                    logger.errorv(t, "Failed to load executor {0}", (Object)cm.getId());
                }
            }
            this.executorsMap.put(realm.getId(), providers);
        } else {
            ClientPolicyLogger.log(logger, "Use cached executors.");
        }
        return providers;
    }
}

