/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;
import org.keycloak.authentication.requiredactions.util.UserUpdateProfileContext;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class AttributeFormDataProcessor {
    public static void process(MultivaluedMap<String, String> formData, RealmModel realm, UserModel user) {
        UserUpdateProfileContext userCtx = new UserUpdateProfileContext(realm, user);
        AttributeFormDataProcessor.process(formData, realm, userCtx);
    }

    public static void process(MultivaluedMap<String, String> formData, RealmModel realm, UpdateProfileContext user) {
        for (String key : formData.keySet()) {
            if (!key.startsWith("user.attributes.")) continue;
            String attribute = key.substring("user.attributes.".length());
            List<String> modelVal = user.getAttribute(attribute);
            ArrayList<String> modelValue = modelVal == null ? new ArrayList<String>() : new ArrayList<String>(modelVal);
            int index = 0;
            for (String value : (List)formData.get((Object)key)) {
                AttributeFormDataProcessor.addOrSetValue(modelValue, index, value);
                ++index;
            }
            user.setAttribute(attribute, modelValue);
        }
    }

    private static void addOrSetValue(List<String> list, int index, String value) {
        if (list.size() > index) {
            list.set(index, value);
        } else {
            list.add(value);
        }
    }
}

