/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.encoding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.logging.Logger;
import org.keycloak.encoding.ResourceEncodingProvider;
import org.keycloak.models.KeycloakSession;

public class GzipResourceEncodingProvider
implements ResourceEncodingProvider {
    private static final Logger logger = Logger.getLogger(ResourceEncodingProvider.class);
    private KeycloakSession session;
    private File cacheDir;

    public GzipResourceEncodingProvider(KeycloakSession session, File cacheDir) {
        this.session = session;
        this.cacheDir = cacheDir;
    }

    @Override
    public InputStream getEncodedStream(ResourceEncodingProvider.StreamSupplier producer, String ... path) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cacheDir.getAbsolutePath());
        for (String p : path) {
            sb.append(File.separatorChar);
            sb.append(p);
        }
        sb.append(".gz");
        String filePath = sb.toString();
        try {
            File encodedFile = new File(filePath);
            if (!encodedFile.getCanonicalPath().startsWith(this.cacheDir.getCanonicalPath())) {
                return null;
            }
            if (!encodedFile.exists()) {
                InputStream is = producer.getInputStream();
                if (is != null) {
                    File parent = encodedFile.getParentFile();
                    if (!parent.isDirectory()) {
                        parent.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(encodedFile);
                    GZIPOutputStream gos = new GZIPOutputStream(fos);
                    IOUtils.copy((InputStream)is, (OutputStream)gos);
                    gos.close();
                    is.close();
                } else {
                    encodedFile = null;
                }
            }
            return encodedFile != null ? new FileInputStream(encodedFile) : null;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to encode resource", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getEncoding() {
        return "gzip";
    }
}

