/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.enums.AccountRestApiVersion;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.account.AccountConsole;
import org.keycloak.services.resources.account.AccountFormService;
import org.keycloak.services.resources.account.AccountRestService;
import org.keycloak.services.resources.account.CorsPreflightService;
import org.keycloak.theme.Theme;

public class AccountLoader {
    private KeycloakSession session;
    private EventBuilder event;
    @Context
    private HttpRequest request;
    @Context
    private HttpResponse response;
    private static final Logger logger = Logger.getLogger(AccountLoader.class);

    public AccountLoader(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
    }

    @Path(value="/")
    public Object getAccountService() {
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = this.getAccountManagementClient(realm);
        HttpRequest request = (HttpRequest)this.session.getContext().getContextObject(HttpRequest.class);
        HttpHeaders headers = this.session.getContext().getRequestHeaders();
        MediaType content = headers.getMediaType();
        List accepts = headers.getAcceptableMediaTypes();
        Theme theme = this.getTheme(this.session);
        boolean deprecatedAccount = this.isDeprecatedFormsAccountConsole(theme);
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        if (request.getHttpMethod().equals("OPTIONS")) {
            return new CorsPreflightService(request);
        }
        if ((accepts.contains(MediaType.APPLICATION_JSON_TYPE) || MediaType.APPLICATION_JSON_TYPE.equals((Object)content)) && !uriInfo.getPath().endsWith("keycloak.json")) {
            return this.getAccountRestService(client, null);
        }
        if (deprecatedAccount) {
            AccountFormService accountFormService = new AccountFormService(realm, client, this.event);
            ResteasyProviderFactory.getInstance().injectProperties((Object)accountFormService);
            accountFormService.init();
            return accountFormService;
        }
        AccountConsole console = new AccountConsole(realm, client, theme);
        ResteasyProviderFactory.getInstance().injectProperties((Object)console);
        console.init();
        return console;
    }

    @Path(value="{version : v\\d[0-9a-zA-Z_\\-]*}")
    @Produces(value={"application/json"})
    public Object getVersionedAccountRestService(@PathParam(value="version") String version) {
        if (this.request.getHttpMethod().equals("OPTIONS")) {
            return new CorsPreflightService(this.request);
        }
        return this.getAccountRestService(this.getAccountManagementClient(this.session.getContext().getRealm()), version);
    }

    private Theme getTheme(KeycloakSession session) {
        try {
            return session.theme().getTheme(Theme.Type.ACCOUNT);
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    private boolean isDeprecatedFormsAccountConsole(Theme theme) {
        try {
            return Boolean.parseBoolean(theme.getProperties().getProperty("deprecatedMode", "true"));
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    private AccountRestService getAccountRestService(ClientModel client, String versionStr) {
        AccountRestApiVersion version;
        AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).setAudience(client.getClientId()).authenticate();
        if (authResult == null) {
            throw new NotAuthorizedException((Object)"Bearer token required", new Object[0]);
        }
        Auth auth = new Auth(this.session.getContext().getRealm(), authResult.getToken(), authResult.getUser(), client, authResult.getSession(), false);
        Cors.add(this.request).allowedOrigins(auth.getToken()).allowedMethods("GET", "PUT", "POST", "DELETE").auth().build(this.response);
        if (authResult.getUser().getServiceAccountClientLink() != null) {
            throw new NotAuthorizedException((Object)"Service accounts are not allowed to access this service", new Object[0]);
        }
        if (versionStr == null) {
            version = AccountRestApiVersion.DEFAULT;
        } else {
            version = AccountRestApiVersion.get((String)versionStr);
            if (version == null) {
                throw new NotFoundException("API version not found");
            }
        }
        AccountRestService accountRestService = new AccountRestService(this.session, auth, client, this.event, version);
        ResteasyProviderFactory.getInstance().injectProperties((Object)accountRestService);
        accountRestService.init();
        return accountRestService;
    }

    private ClientModel getAccountManagementClient(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("account");
        if (client == null || !client.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        return client;
    }
}

