/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.rar.AuthorizationRequestParserProvider;
import org.keycloak.rar.AuthorizationRequestContext;

public class AuthorizationContextUtil {
    public static AuthorizationRequestContext getAuthorizationRequestContextFromScopes(KeycloakSession session, String scope) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            throw new RuntimeException("The Dynamic Scopes feature is not enabled and the AuthorizationRequestContext hasn't been generated");
        }
        AuthorizationRequestParserProvider clientScopeParser = (AuthorizationRequestParserProvider)session.getProvider(AuthorizationRequestParserProvider.class, "client-scope");
        if (clientScopeParser == null) {
            throw new RuntimeException(String.format("No provider found for authorization requests parser %1s", "client-scope"));
        }
        return clientScopeParser.parseScopes(scope);
    }
}

