/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseTokenStoreProvider;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;

public class JWTClientSecretAuthenticator
extends AbstractClientAuthenticator {
    private static final Logger logger = Logger.getLogger(JWTClientSecretAuthenticator.class);
    public static final String PROVIDER_ID = "client-secret-jwt";

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        if (!this.isFormDataRequest(context.getHttpRequest())) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Parameter client_assertion_type is missing");
            context.challenge(challengeResponse);
            return;
        }
        MultivaluedMap params = context.getHttpRequest().getDecodedFormParameters();
        String clientAssertionType = (String)params.getFirst((Object)"client_assertion_type");
        String clientAssertion = (String)params.getFirst((Object)"client_assertion");
        if (clientAssertionType == null) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Parameter client_assertion_type is missing");
            context.challenge(challengeResponse);
            return;
        }
        if (!clientAssertionType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Parameter client_assertion_type has value '" + clientAssertionType + "' but expected is '" + "urn:ietf:params:oauth:client-assertion-type:jwt-bearer" + "'");
            context.challenge(challengeResponse);
            return;
        }
        if (clientAssertion == null) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "client_assertion parameter missing");
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, challengeResponse);
            return;
        }
        try {
            boolean signatureValid;
            JWSInput jws = new JWSInput(clientAssertion);
            JsonWebToken token = (JsonWebToken)jws.readJsonContent(JsonWebToken.class);
            RealmModel realm = context.getRealm();
            String clientId = token.getSubject();
            if (clientId == null) {
                throw new RuntimeException("Can't identify client. Subject missing on JWT token");
            }
            if (!clientId.equals(token.getIssuer())) {
                throw new RuntimeException("Issuer mismatch. The issuer should match the subject");
            }
            context.getEvent().client(clientId);
            ClientModel client = realm.getClientByClientId(clientId);
            if (client == null) {
                context.failure(AuthenticationFlowError.CLIENT_NOT_FOUND, null);
                return;
            }
            context.setClient(client);
            if (!client.isEnabled()) {
                context.failure(AuthenticationFlowError.CLIENT_DISABLED, null);
                return;
            }
            String expectedSignatureAlg = OIDCAdvancedConfigWrapper.fromClientModel(client).getTokenEndpointAuthSigningAlg();
            if (jws.getHeader().getAlgorithm() == null || jws.getHeader().getAlgorithm().name() == null) {
                Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "invalid signature algorithm");
                context.challenge(challengeResponse);
                return;
            }
            String actualSignatureAlg = jws.getHeader().getAlgorithm().name();
            if (expectedSignatureAlg != null && !expectedSignatureAlg.equals(actualSignatureAlg)) {
                Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "invalid signature algorithm");
                context.challenge(challengeResponse);
                return;
            }
            String clientSecretString = client.getSecret();
            if (clientSecretString == null) {
                context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, null);
                return;
            }
            try {
                JsonWebToken jwt = (JsonWebToken)context.getSession().tokens().decodeClientJWT(clientAssertion, client, JsonWebToken.class);
                signatureValid = jwt != null;
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                throw new RuntimeException("Signature on JWT token by client secret failed validation", cause);
            }
            if (!signatureValid) {
                throw new RuntimeException("Signature on JWT token by client secret  failed validation");
            }
            String issuerUrl = Urls.realmIssuer(context.getUriInfo().getBaseUri(), realm.getName());
            String tokenUrl = OIDCLoginProtocolService.tokenUrl(context.getUriInfo().getBaseUriBuilder()).build(new Object[]{realm.getName()}).toString();
            if (!token.hasAudience(issuerUrl) && !token.hasAudience(tokenUrl)) {
                throw new RuntimeException("Token audience doesn't match domain. Realm issuer is '" + issuerUrl + "' but audience from token is '" + Arrays.asList(token.getAudience()).toString() + "'");
            }
            if (!token.isActive()) {
                throw new RuntimeException("Token is not active");
            }
            int currentTime = Time.currentTime();
            if (token.getExpiration() == 0 && token.getIssuedAt() + 10 < currentTime) {
                throw new RuntimeException("Token is not active");
            }
            if (token.getId() == null) {
                throw new RuntimeException("Missing ID on the token");
            }
            SingleUseTokenStoreProvider singleUseCache = (SingleUseTokenStoreProvider)context.getSession().getProvider(SingleUseTokenStoreProvider.class);
            int lifespanInSecs = Math.max(token.getExpiration() - currentTime, 10);
            if (!singleUseCache.putIfAbsent(token.getId(), lifespanInSecs)) {
                logger.warnf("Token '%s' already used when authenticating client '%s'.", (Object)token.getId(), (Object)clientId);
                throw new RuntimeException("Token reuse detected");
            }
            logger.tracef("Added token '%s' to single-use cache. Lifespan: %d seconds, client: %s", (Object)token.getId(), (Object)lifespanInSecs, (Object)clientId);
            context.success();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.errorValidatingAssertion(e);
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", "Client authentication with client secret signed JWT failed: " + e.getMessage());
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, challengeResponse);
        }
    }

    public boolean isConfigurable() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return Collections.emptyList();
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("secret", client.getSecret());
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("secret-jwt", props);
        return config;
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        if (loginProtocol.equals("openid-connect")) {
            HashSet<String> results = new HashSet<String>();
            results.add("client_secret_jwt");
            return results;
        }
        return Collections.emptySet();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Signed Jwt with Client Secret";
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getHelpText() {
        return "Validates client based on signed JWT issued by client and signed with the Client Secret";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new LinkedList<ProviderConfigProperty>();
    }
}

