/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PolicyError;

public class PasswordCredentialProvider
implements CredentialProvider<PasswordCredentialModel>,
CredentialInputUpdater.Streams,
CredentialInputValidator,
OnUserCache {
    public static final String PASSWORD_CACHE_KEY = PasswordCredentialProvider.class.getName() + "." + "password";
    private static final Logger logger = Logger.getLogger(PasswordCredentialProvider.class);
    protected final KeycloakSession session;

    public PasswordCredentialProvider(KeycloakSession session) {
        this.session = session;
    }

    protected UserCredentialStore getCredentialStore() {
        return this.session.userCredentialManager();
    }

    public PasswordCredentialModel getPassword(RealmModel realm, UserModel user) {
        List passwords = null;
        if (user instanceof CachedUserModel && !((CachedUserModel)user).isMarkedForEviction()) {
            CachedUserModel cached = (CachedUserModel)user;
            passwords = (List)cached.getCachedWith().get(PASSWORD_CACHE_KEY);
        }
        if (!(user instanceof CachedUserModel) || ((CachedUserModel)user).isMarkedForEviction()) {
            passwords = this.getCredentialStore().getStoredCredentialsByTypeStream(realm, user, this.getType()).collect(Collectors.toList());
        }
        if (passwords == null || passwords.isEmpty()) {
            return null;
        }
        return PasswordCredentialModel.createFromCredentialModel((CredentialModel)((CredentialModel)passwords.get(0)));
    }

    public boolean createCredential(RealmModel realm, UserModel user, String password) {
        PasswordPolicy policy = realm.getPasswordPolicy();
        PolicyError error = ((PasswordPolicyManagerProvider)this.session.getProvider(PasswordPolicyManagerProvider.class)).validate(realm, user, password);
        if (error != null) {
            throw new ModelException(error.getMessage(), error.getParameters());
        }
        PasswordHashProvider hash = this.getHashProvider(policy);
        if (hash == null) {
            return false;
        }
        PasswordCredentialModel credentialModel = hash.encodedCredential(password, policy.getHashIterations());
        credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        this.createCredential(realm, user, credentialModel);
        return true;
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, PasswordCredentialModel credentialModel) {
        CredentialModel createdCredential;
        PasswordPolicy policy = realm.getPasswordPolicy();
        int expiredPasswordsPolicyValue = policy.getExpiredPasswords();
        PasswordCredentialModel oldPassword = this.getPassword(realm, user);
        if (credentialModel.getCreatedDate() == null) {
            credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        }
        if (oldPassword == null) {
            createdCredential = this.getCredentialStore().createCredential(realm, user, (CredentialModel)credentialModel);
        } else {
            credentialModel.setId(oldPassword.getId());
            this.getCredentialStore().updateCredential(realm, user, (CredentialModel)credentialModel);
            createdCredential = credentialModel;
            if (expiredPasswordsPolicyValue > 1) {
                oldPassword.setId(null);
                oldPassword.setType("password-history");
                this.getCredentialStore().createCredential(realm, user, (CredentialModel)oldPassword);
            }
        }
        int passwordHistoryListMaxSize = Math.max(0, expiredPasswordsPolicyValue - 1);
        this.getCredentialStore().getStoredCredentialsByTypeStream(realm, user, "password-history").sorted(CredentialModel.comparingByStartDateDesc()).skip(passwordHistoryListMaxSize).collect(Collectors.toList()).forEach(p -> this.getCredentialStore().removeStoredCredential(realm, user, p.getId()));
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        return createdCredential;
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        return this.getCredentialStore().removeStoredCredential(realm, user, credentialId);
    }

    public PasswordCredentialModel getCredentialFromModel(CredentialModel model) {
        return PasswordCredentialModel.createFromCredentialModel((CredentialModel)model);
    }

    protected PasswordHashProvider getHashProvider(PasswordPolicy policy) {
        PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        if (hash == null) {
            logger.warnv("Realm PasswordPolicy PasswordHashProvider {0} not found", (Object)policy.getHashAlgorithm());
            return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, "pbkdf2-sha256");
        }
        return hash;
    }

    public boolean supportsCredentialType(String credentialType) {
        return credentialType.equals(this.getType());
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        return this.createCredential(realm, user, input.getChallengeResponse());
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getPassword(realm, user) != null;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            logger.debug((Object)"Expected instance of UserCredentialModel for CredentialInput");
            return false;
        }
        if (input.getChallengeResponse() == null) {
            logger.debugv("Input password was null for user {0} ", (Object)user.getUsername());
            return false;
        }
        PasswordCredentialModel password = this.getPassword(realm, user);
        if (password == null) {
            logger.debugv("No password cached or stored for user {0} ", (Object)user.getUsername());
            return false;
        }
        PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, password.getPasswordCredentialData().getAlgorithm());
        if (hash == null) {
            logger.debugv("PasswordHashProvider {0} not found for user {1} ", (Object)password.getPasswordCredentialData().getAlgorithm(), (Object)user.getUsername());
            return false;
        }
        if (!hash.verify(input.getChallengeResponse(), password)) {
            logger.debugv("Failed password validation for user {0} ", (Object)user.getUsername());
            return false;
        }
        PasswordPolicy policy = realm.getPasswordPolicy();
        if (policy == null) {
            return true;
        }
        hash = this.getHashProvider(policy);
        if (hash == null) {
            return true;
        }
        if (hash.policyCheck(policy, password)) {
            return true;
        }
        PasswordCredentialModel newPassword = hash.encodedCredential(input.getChallengeResponse(), policy.getHashIterations());
        newPassword.setId(password.getId());
        newPassword.setCreatedDate(password.getCreatedDate());
        newPassword.setUserLabel(password.getUserLabel());
        this.getCredentialStore().updateCredential(realm, user, (CredentialModel)newPassword);
        UserCache userCache = this.session.userCache();
        if (userCache != null) {
            userCache.evict(realm, user);
        }
        return true;
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        List passwords = this.getCredentialStore().getStoredCredentialsByTypeStream(realm, (UserModel)user, this.getType()).collect(Collectors.toList());
        user.getCachedWith().put(PASSWORD_CACHE_KEY, passwords);
    }

    public String getType() {
        return "password";
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        CredentialTypeMetadata.CredentialTypeMetadataBuilder metadataBuilder = CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.BASIC_AUTHENTICATION).displayName("password-display-name").helpText("password-help-text").iconCssClass("kcAuthenticatorPasswordClass");
        UserModel user = metadataContext.getUser();
        if (user != null && this.session.userCredentialManager().isConfiguredFor(this.session.getContext().getRealm(), user, this.getType())) {
            metadataBuilder.updateAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        } else {
            metadataBuilder.createAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        }
        return metadataBuilder.removeable(false).build(this.session);
    }
}

