/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.RecoveryAuthnCodesCredentialModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.sessions.AuthenticationSessionModel;

public class RecoveryAuthnCodesFormAuthenticator
implements Authenticator {
    private final UserCredentialManager userCredentialManager;

    public RecoveryAuthnCodesFormAuthenticator(KeycloakSession keycloakSession) {
        this.userCredentialManager = keycloakSession.userCredentialManager();
    }

    public void authenticate(AuthenticationFlowContext context) {
        context.challenge(this.createLoginForm(context, false, null, null));
    }

    public void action(AuthenticationFlowContext context) {
        context.getEvent().detail("credential_type", "recovery-authn-codes");
        if (this.isRecoveryAuthnCodeInputValid(context)) {
            context.success();
        }
    }

    private boolean isRecoveryAuthnCodeInputValid(AuthenticationFlowContext authnFlowContext) {
        boolean result = false;
        MultivaluedMap formParamsMap = authnFlowContext.getHttpRequest().getDecodedFormParameters();
        String recoveryAuthnCodeUserInput = (String)formParamsMap.getFirst((Object)"recoveryCodeInput");
        if (ObjectUtil.isBlank((CharSequence)recoveryAuthnCodeUserInput)) {
            authnFlowContext.forceChallenge(this.createLoginForm(authnFlowContext, true, "recovery-codes-error-invalid", "recoveryCodeInput"));
            return result;
        }
        RealmModel targetRealm = authnFlowContext.getRealm();
        UserModel authenticatedUser = authnFlowContext.getUser();
        if (!this.isDisabledByBruteForce(authnFlowContext, authenticatedUser)) {
            boolean isValid = this.userCredentialManager.isValid(targetRealm, authenticatedUser, new CredentialInput[]{UserCredentialModel.buildFromBackupAuthnCode((String)recoveryAuthnCodeUserInput.replace("-", ""))});
            if (!isValid) {
                Response responseChallenge = this.createLoginForm(authnFlowContext, true, "recovery-codes-error-invalid", "recoveryCodeInput");
                authnFlowContext.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, responseChallenge);
            } else {
                result = true;
                Optional optUserCredentialFound = this.userCredentialManager.getStoredCredentialsByTypeStream(targetRealm, authenticatedUser, "recovery-authn-codes").findFirst();
                RecoveryAuthnCodesCredentialModel recoveryCodeCredentialModel = null;
                if (optUserCredentialFound.isPresent() && (recoveryCodeCredentialModel = RecoveryAuthnCodesCredentialModel.createFromCredentialModel((CredentialModel)((CredentialModel)optUserCredentialFound.get()))).allCodesUsed()) {
                    this.userCredentialManager.removeStoredCredential(targetRealm, authenticatedUser, recoveryCodeCredentialModel.getId());
                }
                if (recoveryCodeCredentialModel == null || recoveryCodeCredentialModel.allCodesUsed()) {
                    authenticatedUser.addRequiredAction(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES);
                }
            }
        }
        return result;
    }

    protected boolean isDisabledByBruteForce(AuthenticationFlowContext authnFlowContext, UserModel authenticatedUser) {
        String bruteForceError = this.getDisabledByBruteForceEventError(authnFlowContext, authenticatedUser);
        if (bruteForceError == null) {
            return false;
        }
        authnFlowContext.getEvent().user(authenticatedUser);
        authnFlowContext.getEvent().error(bruteForceError);
        Response challengeResponse = this.createLoginForm(authnFlowContext, false, "invalidUserMessage", "username");
        authnFlowContext.forceChallenge(challengeResponse);
        return true;
    }

    protected String getDisabledByBruteForceEventError(AuthenticationFlowContext authnFlowContext, UserModel authenticatedUser) {
        return AuthenticatorUtils.getDisabledByBruteForceEventError(authnFlowContext, authenticatedUser);
    }

    private Response createLoginForm(AuthenticationFlowContext authnFlowContext, boolean withInvalidUserCredentialsError, String errorToRaise, String fieldError) {
        LoginFormsProvider loginFormsProvider;
        if (withInvalidUserCredentialsError) {
            loginFormsProvider = authnFlowContext.form();
            authnFlowContext.getEvent().user(authnFlowContext.getUser());
            authnFlowContext.getEvent().error("invalid_user_credentials");
            loginFormsProvider.addError(new FormMessage(fieldError, errorToRaise));
        } else {
            loginFormsProvider = authnFlowContext.form().setExecution(authnFlowContext.getExecution().getId());
            if (errorToRaise != null) {
                if (fieldError != null) {
                    loginFormsProvider.addError(new FormMessage(fieldError, errorToRaise));
                } else {
                    loginFormsProvider.setError(errorToRaise, new Object[0]);
                }
            }
        }
        Response challengeResponse = loginFormsProvider.createLoginRecoveryAuthnCode();
        return challengeResponse;
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.userCredentialManager().isConfiguredFor(realm, user, "recovery-authn-codes");
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        authenticationSession.addRequiredAction(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name());
    }

    public void close() {
    }
}

