/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;

public class ClientAccessTypeCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientAccessTypeCondition.class);

    public ClientAccessTypeCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-access-type";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: 
            case TOKEN_REQUEST: 
            case SERVICE_ACCOUNT_TOKEN_REQUEST: 
            case TOKEN_REFRESH: 
            case TOKEN_REVOKE: 
            case TOKEN_INTROSPECT: 
            case USERINFO_REQUEST: 
            case LOGOUT_REQUEST: 
            case UPDATED: 
            case REGISTERED: {
                if (this.isClientAccessTypeMatched()) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private String getClientAccessType() {
        ClientModel client = this.session.getContext().getClient();
        if (client == null) {
            return null;
        }
        if (client.isPublicClient()) {
            return "public";
        }
        if (client.isBearerOnly()) {
            return "bearer-only";
        }
        return "confidential";
    }

    private boolean isClientAccessTypeMatched() {
        String accessType = this.getClientAccessType();
        if (accessType == null) {
            return false;
        }
        List expectedAccessTypes = Optional.ofNullable(((Configuration)this.configuration).getType()).orElse(Collections.emptyList());
        if (logger.isTraceEnabled()) {
            logger.tracev("accessType = {0}", (Object)accessType);
            expectedAccessTypes.stream().forEach(i -> logger.tracev("expected accessType = {0}", i));
        }
        return expectedAccessTypes.stream().anyMatch(i -> i.equals(accessType));
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        protected List<String> type;

        public List<String> getType() {
            return this.type;
        }

        public void setType(List<String> type) {
            this.type = type;
        }
    }
}

