/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.DefaultAttributes;
import org.keycloak.userprofile.DefaultUserProfile;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.UserProfileProviderFactory;
import org.keycloak.userprofile.validator.BlankAttributeValidator;
import org.keycloak.validate.ValidatorConfig;

public abstract class AbstractUserProfileProvider<U extends UserProfileProvider>
implements UserProfileProvider,
UserProfileProviderFactory<U> {
    private static String[] DEFAULT_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp", "userCertificate", "saml.persistent.name.id.for.*", "ENABLED", "EMAIL_VERIFIED", "disabledReason"};
    private static String[] DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES = new String[]{"KERBEROS_PRINCIPAL", "LDAP_ID", "LDAP_ENTRY_DN", "CREATED_TIMESTAMP", "createTimestamp", "modifyTimestamp"};
    private static Pattern readOnlyAttributesPattern = AbstractUserProfileProvider.getRegexPatternString(DEFAULT_READ_ONLY_ATTRIBUTES);
    private static Pattern adminReadOnlyAttributesPattern = AbstractUserProfileProvider.getRegexPatternString(DEFAULT_ADMIN_READ_ONLY_ATTRIBUTES);
    protected final Map<UserProfileContext, UserProfileMetadata> contextualMetadataRegistry;
    protected final KeycloakSession session;

    private static boolean editUsernameCondition(AttributeContext c) {
        KeycloakSession session = c.getSession();
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        switch (c.getContext()) {
            case REGISTRATION_PROFILE: 
            case IDP_REVIEW: {
                return !realm.isRegistrationEmailAsUsername();
            }
            case ACCOUNT_OLD: 
            case ACCOUNT: 
            case UPDATE_PROFILE: {
                return realm.isEditUsernameAllowed();
            }
            case USER_API: {
                return true;
            }
        }
        return false;
    }

    private static boolean readUsernameCondition(AttributeContext c) {
        KeycloakSession session = c.getSession();
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        switch (c.getContext()) {
            case REGISTRATION_PROFILE: 
            case IDP_REVIEW: {
                return !realm.isRegistrationEmailAsUsername();
            }
            case UPDATE_PROFILE: {
                return realm.isEditUsernameAllowed();
            }
            case UPDATE_EMAIL: {
                return false;
            }
        }
        return true;
    }

    private static boolean editEmailCondition(AttributeContext c) {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL) || c.getContext() != UserProfileContext.UPDATE_PROFILE && c.getContext() != UserProfileContext.ACCOUNT;
    }

    private static boolean readEmailCondition(AttributeContext c) {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL) || c.getContext() != UserProfileContext.UPDATE_PROFILE;
    }

    public static Pattern getRegexPatternString(String[] builtinReadOnlyAttributes) {
        if (builtinReadOnlyAttributes != null) {
            ArrayList<String> readOnlyAttributes = new ArrayList<String>(Arrays.asList(builtinReadOnlyAttributes));
            String regexStr = readOnlyAttributes.stream().map(configAttrName -> configAttrName.endsWith("*") ? "^" + Pattern.quote(configAttrName.substring(0, configAttrName.length() - 1)) + ".*$" : "^" + Pattern.quote(configAttrName) + "$").collect(Collectors.joining("|"));
            regexStr = "(?i:" + regexStr + ")";
            return Pattern.compile(regexStr);
        }
        return null;
    }

    public AbstractUserProfileProvider() {
        this(null, new HashMap<UserProfileContext, UserProfileMetadata>());
    }

    public AbstractUserProfileProvider(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> contextualMetadataRegistry) {
        this.session = session;
        this.contextualMetadataRegistry = contextualMetadataRegistry;
    }

    public UserProfile create(UserProfileContext context, UserModel user) {
        return this.createUserProfile(context, user.getAttributes(), user);
    }

    public UserProfile create(UserProfileContext context, Map<String, ?> attributes, UserModel user) {
        return this.createUserProfile(context, attributes, user);
    }

    public UserProfile create(UserProfileContext context, Map<String, ?> attributes) {
        return this.createUserProfile(context, attributes, null);
    }

    public U create(KeycloakSession session) {
        return this.create(session, this.contextualMetadataRegistry);
    }

    public void init(Config.Scope config) {
        this.contextualMetadataRegistry.clear();
        Pattern pattern = AbstractUserProfileProvider.getRegexPatternString(config.getArray("read-only-attributes"));
        AttributeValidatorMetadata readOnlyValidator = null;
        if (pattern != null) {
            readOnlyValidator = this.createReadOnlyAttributeUnchangedValidator(pattern);
        }
        this.addContextualProfileMetadata(this.configureUserProfile(this.createBrokeringProfile(readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.ACCOUNT, readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.ACCOUNT_OLD, readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.REGISTRATION_PROFILE, readOnlyValidator)));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.UPDATE_PROFILE, readOnlyValidator)));
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL)) {
            this.addContextualProfileMetadata(this.configureUserProfile(this.createDefaultProfile(UserProfileContext.UPDATE_EMAIL, readOnlyValidator)));
        }
        this.addContextualProfileMetadata(this.configureUserProfile(this.createRegistrationUserCreationProfile()));
        this.addContextualProfileMetadata(this.configureUserProfile(this.createUserResourceValidation(config)));
    }

    private AttributeValidatorMetadata createReadOnlyAttributeUnchangedValidator(Pattern pattern) {
        return new AttributeValidatorMetadata("up-readonly-attribute-unchanged", ValidatorConfig.builder().config("pattern", (Object)pattern).build());
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getConfiguration() {
        return null;
    }

    public void setConfiguration(String configuration) {
    }

    protected abstract U create(KeycloakSession var1, Map<UserProfileContext, UserProfileMetadata> var2);

    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata) {
        return metadata;
    }

    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata, KeycloakSession session) {
        return metadata;
    }

    private Function<Attributes, UserModel> createUserFactory() {
        return new Function<Attributes, UserModel>(){
            private UserModel user;

            @Override
            public UserModel apply(Attributes attributes) {
                if (this.user == null) {
                    String userName = attributes.getFirstValue("username");
                    if (userName == null) {
                        userName = attributes.getFirstValue("email");
                    }
                    this.user = AbstractUserProfileProvider.this.session.users().addUser(AbstractUserProfileProvider.this.session.getContext().getRealm(), userName);
                }
                return this.user;
            }
        };
    }

    private UserProfile createUserProfile(UserProfileContext context, Map<String, ?> attributes, UserModel user) {
        UserProfileMetadata metadata = this.configureUserProfile(this.contextualMetadataRegistry.get(context), this.session);
        Attributes profileAttributes = this.createAttributes(context, attributes, user, metadata);
        return new DefaultUserProfile(metadata, profileAttributes, this.createUserFactory(), user, this.session);
    }

    protected Attributes createAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata metadata) {
        return new DefaultAttributes(context, attributes, user, metadata, this.session);
    }

    private void addContextualProfileMetadata(UserProfileMetadata metadata) {
        if (this.contextualMetadataRegistry.putIfAbsent(metadata.getContext(), metadata) != null) {
            throw new IllegalStateException("Multiple profile metadata found for context " + metadata.getContext());
        }
    }

    private UserProfileMetadata createRegistrationUserCreationProfile() {
        UserProfileMetadata metadata = new UserProfileMetadata(UserProfileContext.REGISTRATION_USER_CREATION);
        metadata.addAttribute("username", -2, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-registration-email-as-username-username-value"), new AttributeValidatorMetadata("up-registration-username-exists")});
        metadata.addAttribute("email", -1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-registration-email-as-username-email-value")});
        metadata.addAttribute("kc.read.only", 1000, new AttributeValidatorMetadata[]{this.createReadOnlyAttributeUnchangedValidator(readOnlyAttributesPattern)});
        return metadata;
    }

    private UserProfileMetadata createDefaultProfile(UserProfileContext context, AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = new UserProfileMetadata(context);
        metadata.addAttribute("username", -2, AbstractUserProfileProvider::editUsernameCondition, AbstractUserProfileProvider::readUsernameCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-username-has-value"), new AttributeValidatorMetadata("up-username-not-idn-homograph"), new AttributeValidatorMetadata("up-duplicate-username"), new AttributeValidatorMetadata("up-username-mutation")}).setAttributeDisplayName("${username}");
        metadata.addAttribute("email", -1, AbstractUserProfileProvider::editEmailCondition, AbstractUserProfileProvider::readEmailCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingEmailMessage", false)), new AttributeValidatorMetadata("up-duplicate-email"), new AttributeValidatorMetadata("up-email-exists-as-username")}).setAttributeDisplayName("${email}");
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(readOnlyAttributesPattern));
        if (readOnlyValidator != null) {
            readonlyValidators.add(readOnlyValidator);
        }
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        return metadata;
    }

    private UserProfileMetadata createBrokeringProfile(AttributeValidatorMetadata readOnlyValidator) {
        UserProfileMetadata metadata = new UserProfileMetadata(UserProfileContext.IDP_REVIEW);
        metadata.addAttribute("username", -2, AbstractUserProfileProvider::editUsernameCondition, AbstractUserProfileProvider::readUsernameCondition, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-brokering-federated-username-has-value")}).setAttributeDisplayName("${username}");
        metadata.addAttribute("email", -1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingEmailMessage", true))}).setAttributeDisplayName("${email}");
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(readOnlyAttributesPattern));
        if (readOnlyValidator != null) {
            readonlyValidators.add(readOnlyValidator);
        }
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        return metadata;
    }

    private UserProfileMetadata createUserResourceValidation(Config.Scope config) {
        Pattern p = AbstractUserProfileProvider.getRegexPatternString(config.getArray("admin-read-only-attributes"));
        UserProfileMetadata metadata = new UserProfileMetadata(UserProfileContext.USER_API);
        ArrayList<AttributeValidatorMetadata> readonlyValidators = new ArrayList<AttributeValidatorMetadata>();
        if (p != null) {
            readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(p));
        }
        readonlyValidators.add(this.createReadOnlyAttributeUnchangedValidator(adminReadOnlyAttributesPattern));
        metadata.addAttribute("kc.read.only", 1000, readonlyValidators);
        return metadata;
    }
}

