/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractRsaKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigurationBuilder;

public abstract class AbstractImportedRsaKeyProviderFactory
extends AbstractRsaKeyProviderFactory {
    public static final ProviderConfigurationBuilder rsaKeyConfigurationBuilder() {
        return ProviderConfigurationBuilder.create().property(Attributes.PRIORITY_PROPERTY).property(Attributes.ENABLED_PROPERTY).property(Attributes.ACTIVE_PROPERTY).property(Attributes.PRIVATE_KEY_PROPERTY).property(Attributes.CERTIFICATE_PROPERTY);
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        X509Certificate certificate;
        KeyPair keyPair;
        ConfigurationValidationHelper.check((ComponentModel)model).checkLong(Attributes.PRIORITY_PROPERTY, false).checkBoolean(Attributes.ENABLED_PROPERTY, false).checkBoolean(Attributes.ACTIVE_PROPERTY, false).checkSingle(Attributes.PRIVATE_KEY_PROPERTY, true).checkSingle(Attributes.CERTIFICATE_PROPERTY, false);
        try {
            PrivateKey privateKey = PemUtils.decodePrivateKey((String)model.get("privateKey"));
            PublicKey publicKey = KeyUtils.extractPublicKey((PrivateKey)privateKey);
            keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (Throwable t) {
            throw new ComponentValidationException("Failed to decode private key", t);
        }
        if (model.contains("certificate")) {
            certificate = null;
            try {
                certificate = PemUtils.decodeCertificate((String)model.get("certificate"));
            }
            catch (Throwable t) {
                throw new ComponentValidationException("Failed to decode certificate", t);
            }
            if (certificate == null) {
                throw new ComponentValidationException("Failed to decode certificate", new Object[0]);
            }
            if (!certificate.getPublicKey().equals(keyPair.getPublic())) {
                throw new ComponentValidationException("Certificate does not match private key", new Object[0]);
            }
        } else {
            try {
                certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realm.getName());
                model.put("certificate", PemUtils.encodeCertificate((Certificate)certificate));
            }
            catch (Throwable t) {
                throw new ComponentValidationException("Failed to generate self-signed certificate", new Object[0]);
            }
        }
    }

    protected abstract boolean isValidKeyUse(KeyUse var1);

    protected abstract boolean isSupportedRsaAlgorithm(String var1);
}

