/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.ForkFlowException;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;

public class DefaultAuthenticationFlow
implements AuthenticationFlow {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    Response alternativeChallenge = null;
    AuthenticationExecutionModel challengedAlternativeExecution = null;
    boolean alternativeSuccessful = false;
    List<AuthenticationExecutionModel> executions;
    Iterator<AuthenticationExecutionModel> executionIterator;
    AuthenticationProcessor processor;
    AuthenticationFlowModel flow;

    public DefaultAuthenticationFlow(AuthenticationProcessor processor, AuthenticationFlowModel flow) {
        this.processor = processor;
        this.flow = flow;
        this.executions = processor.getRealm().getAuthenticationExecutions(flow.getId());
        this.executionIterator = this.executions.iterator();
    }

    protected boolean isProcessed(AuthenticationExecutionModel model) {
        if (model.isDisabled()) {
            return true;
        }
        ClientSessionModel.ExecutionStatus status = (ClientSessionModel.ExecutionStatus)this.processor.getClientSession().getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == ClientSessionModel.ExecutionStatus.SUCCESS || status == ClientSessionModel.ExecutionStatus.SKIPPED || status == ClientSessionModel.ExecutionStatus.ATTEMPTED || status == ClientSessionModel.ExecutionStatus.SETUP_REQUIRED;
    }

    public Response processAction(String actionExecution) {
        logger.debugv("processAction: {0}", actionExecution);
        while (this.executionIterator.hasNext()) {
            AuthenticationExecutionModel model = this.executionIterator.next();
            logger.debugv("check: {0} requirement: {1}", model.getAuthenticator(), model.getRequirement().toString());
            if (this.isProcessed(model)) {
                logger.debug("execution is processed");
                if (this.alternativeSuccessful || !model.isAlternative() || !this.processor.isSuccessful(model)) continue;
                this.alternativeSuccessful = true;
                continue;
            }
            if (model.isAuthenticatorFlow()) {
                AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
                return authenticationFlow.processAction(actionExecution);
            }
            if (!model.getId().equals(actionExecution)) continue;
            AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
            }
            Authenticator authenticator = (Authenticator)factory.create(this.processor.getSession());
            AuthenticationProcessor.Result result = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
            logger.debugv("action: {0}", model.getAuthenticator());
            authenticator.action((AuthenticationFlowContext)result);
            Response response = this.processResult(result);
            if (response == null) {
                this.processor.getClientSession().removeNote("current.authentication.execution");
                if (result.status == FlowStatus.SUCCESS) {
                    this.processor.setActionSuccessful();
                }
                return this.processFlow();
            }
            return response;
        }
        throw new AuthenticationFlowException("action is not in current execution", AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response processFlow() {
        logger.debug("processFlow");
        while (this.executionIterator.hasNext()) {
            Response redirect;
            AuthenticationExecutionModel model = this.executionIterator.next();
            logger.debugv("check execution: {0} requirement: {1}", model.getAuthenticator(), model.getRequirement().toString());
            if (this.isProcessed(model)) {
                logger.debug("execution is processed");
                if (this.alternativeSuccessful || !model.isAlternative() || !this.processor.isSuccessful(model)) continue;
                this.alternativeSuccessful = true;
                continue;
            }
            if (model.isAlternative() && this.alternativeSuccessful) {
                logger.debug("Skip alternative execution");
                this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                continue;
            }
            if (model.isAuthenticatorFlow()) {
                logger.debug("execution is flow");
                AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
                Response flowChallenge = authenticationFlow.processFlow();
                if (flowChallenge == null) {
                    this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SUCCESS);
                    if (!model.isAlternative()) continue;
                    this.alternativeSuccessful = true;
                    continue;
                }
                if (!model.isAlternative()) {
                    if (model.isRequired()) {
                        this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                        return flowChallenge;
                    }
                    if (model.isOptional()) {
                        this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                        continue;
                    }
                    this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
                this.alternativeChallenge = flowChallenge;
                this.challengedAlternativeExecution = model;
                return flowChallenge;
            }
            AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
            }
            Authenticator authenticator = (Authenticator)factory.create(this.processor.getSession());
            logger.debugv("authenticator: {0}", factory.getId());
            UserModel authUser = this.processor.getClientSession().getAuthenticatedUser();
            if (authenticator.requiresUser() && authUser == null) {
                if (this.alternativeChallenge != null) {
                    this.processor.getClientSession().setExecutionStatus(this.challengedAlternativeExecution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                    return this.alternativeChallenge;
                }
                throw new AuthenticationFlowException("authenticator: " + factory.getId(), AuthenticationFlowError.UNKNOWN_USER);
            }
            boolean configuredFor = false;
            if (authenticator.requiresUser() && authUser != null && !(configuredFor = authenticator.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser))) {
                if (model.isRequired()) {
                    if (factory.isUserSetupAllowed()) {
                        logger.debugv("authenticator SETUP_REQUIRED: {0}", factory.getId());
                        this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                        authenticator.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getClientSession().getAuthenticatedUser());
                        continue;
                    }
                    throw new AuthenticationFlowException(AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED);
                }
                if (model.isOptional()) {
                    this.processor.getClientSession().setExecutionStatus(model.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
            }
            if ((redirect = this.processor.checkWasSuccessfulBrowserAction()) != null) {
                return redirect;
            }
            AuthenticationProcessor.Result context = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
            logger.debug("invoke authenticator.authenticate");
            authenticator.authenticate((AuthenticationFlowContext)context);
            Response response = this.processResult(context);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    public Response processResult(AuthenticationProcessor.Result result) {
        AuthenticationExecutionModel execution = result.getExecution();
        FlowStatus status = result.getStatus();
        switch (status) {
            case SUCCESS: {
                logger.debugv("authenticator SUCCESS: {0}", execution.getAuthenticator());
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.SUCCESS);
                if (execution.isAlternative()) {
                    this.alternativeSuccessful = true;
                }
                return null;
            }
            case FAILED: {
                logger.debugv("authenticator FAILED: {0}", execution.getAuthenticator());
                this.processor.logFailure();
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.FAILED);
                if (result.getChallenge() != null) {
                    return this.sendChallenge(result, execution);
                }
                throw new AuthenticationFlowException(result.getError());
            }
            case FORK: {
                logger.debugv("reset browser login from authenticator: {0}", execution.getAuthenticator());
                this.processor.getClientSession().setNote("current.authentication.execution", execution.getId());
                throw new ForkFlowException(result.getSuccessMessage(), result.getErrorMessage());
            }
            case FORCE_CHALLENGE: {
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case CHALLENGE: {
                logger.debugv("authenticator CHALLENGE: {0}", execution.getAuthenticator());
                if (execution.isRequired()) {
                    this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                    return this.sendChallenge(result, execution);
                }
                UserModel authenticatedUser = this.processor.getClientSession().getAuthenticatedUser();
                if (execution.isOptional() && authenticatedUser != null && result.getAuthenticator().configuredFor(this.processor.getSession(), this.processor.getRealm(), authenticatedUser)) {
                    this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                    return this.sendChallenge(result, execution);
                }
                if (execution.isAlternative()) {
                    this.alternativeChallenge = result.getChallenge();
                    this.challengedAlternativeExecution = execution;
                } else {
                    this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.SKIPPED);
                }
                return null;
            }
            case FAILURE_CHALLENGE: {
                logger.debugv("authenticator FAILURE_CHALLENGE: {0}", execution.getAuthenticator());
                this.processor.logFailure();
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case ATTEMPTED: {
                logger.debugv("authenticator ATTEMPTED: {0}", execution.getAuthenticator());
                if (execution.getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
                    throw new AuthenticationFlowException(AuthenticationFlowError.INVALID_CREDENTIALS);
                }
                this.processor.getClientSession().setExecutionStatus(execution.getId(), ClientSessionModel.ExecutionStatus.ATTEMPTED);
                return null;
            }
            case FLOW_RESET: {
                AuthenticationProcessor.resetFlow(this.processor.getClientSession());
                return this.processor.authenticate();
            }
        }
        logger.debugv("authenticator INTERNAL_ERROR: {0}", execution.getAuthenticator());
        logger.unknownResultStatus();
        throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response sendChallenge(AuthenticationProcessor.Result result, AuthenticationExecutionModel execution) {
        this.processor.getClientSession().setNote("current.authentication.execution", execution.getId());
        return result.getChallenge();
    }
}

