/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.admin.representation.PolicyEvaluationRequest;
import org.keycloak.authorization.admin.representation.PolicyEvaluationResponse;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.common.KeycloakEvaluationContext;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;

public class PolicyEvaluationService {
    private final AuthorizationProvider authorization;
    @Context
    private HttpRequest httpRequest;
    private final ResourceServer resourceServer;

    PolicyEvaluationService(ResourceServer resourceServer, AuthorizationProvider authorization) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void evaluate(PolicyEvaluationRequest evaluationRequest, @Suspended AsyncResponse asyncResponse) {
        EvaluationContext evaluationContext = this.createEvaluationContext(evaluationRequest);
        this.authorization.evaluators().from(this.createPermissions(evaluationRequest, evaluationContext, this.authorization), evaluationContext).evaluate((Decision)this.createDecisionCollector(evaluationRequest, this.authorization, asyncResponse));
    }

    private DecisionResultCollector createDecisionCollector(final PolicyEvaluationRequest evaluationRequest, final AuthorizationProvider authorization, final AsyncResponse asyncResponse) {
        return new DecisionResultCollector(){

            protected void onComplete(List<Result> results) {
                try {
                    asyncResponse.resume((Object)Response.ok((Object)PolicyEvaluationResponse.build(evaluationRequest, results, PolicyEvaluationService.this.resourceServer, authorization)).build());
                }
                catch (Throwable cause) {
                    asyncResponse.resume(cause);
                }
            }

            public void onError(Throwable cause) {
                asyncResponse.resume(cause);
            }
        };
    }

    private EvaluationContext createEvaluationContext(final PolicyEvaluationRequest representation) {
        return new KeycloakEvaluationContext(this.createIdentity(representation), this.authorization.getKeycloakSession()){

            @Override
            public Attributes getAttributes() {
                HashMap attributes = new HashMap(super.getAttributes().toMap());
                Map<String, String> givenAttributes = representation.getContext().get("attributes");
                if (givenAttributes != null) {
                    givenAttributes.forEach((key, entryValue) -> {
                        if (entryValue != null) {
                            ArrayList<String> values = new ArrayList<String>();
                            for (String value : entryValue.split(",")) {
                                values.add(value);
                            }
                            attributes.put(key, values);
                        }
                    });
                }
                return Attributes.from(attributes);
            }
        };
    }

    private List<ResourcePermission> createPermissions(PolicyEvaluationRequest representation, EvaluationContext evaluationContext, AuthorizationProvider authorization) {
        if (representation.isEntitlements()) {
            return Permissions.all(this.resourceServer, evaluationContext.getIdentity(), authorization);
        }
        return representation.getResources().stream().flatMap(resource -> {
            Set<String> givenScopes = resource.getScopes();
            if (givenScopes == null) {
                givenScopes = new HashSet<String>();
            }
            StoreFactory storeFactory = authorization.getStoreFactory();
            List scopes = givenScopes.stream().map(scopeName -> storeFactory.getScopeStore().findByName(scopeName, this.resourceServer.getId())).collect(Collectors.toList());
            if (resource.getId() != null) {
                Resource resourceModel = storeFactory.getResourceStore().findById(resource.getId());
                return Stream.of(new ResourcePermission(resourceModel, scopes, this.resourceServer));
            }
            if (resource.getType() != null) {
                return storeFactory.getResourceStore().findByType(resource.getType()).stream().map(resource1 -> new ResourcePermission(resource1, scopes, this.resourceServer));
            }
            return scopes.stream().map(scope -> new ResourcePermission(null, Arrays.asList(scope), this.resourceServer));
        }).collect(Collectors.toList());
    }

    private KeycloakIdentity createIdentity(PolicyEvaluationRequest representation) {
        UserModel userModel;
        String subject;
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        AccessToken accessToken = new AccessToken();
        accessToken.subject(representation.getUserId());
        accessToken.issuedFor(representation.getClientId());
        accessToken.audience(new String[]{representation.getClientId()});
        accessToken.issuer(Urls.realmIssuer(this.authorization.getKeycloakSession().getContext().getUri().getBaseUri(), realm.getName()));
        accessToken.setRealmAccess(new AccessToken.Access());
        Map claims = accessToken.getOtherClaims();
        Map<String, String> givenAttributes = representation.getContext().get("attributes");
        if (givenAttributes != null) {
            givenAttributes.forEach((key, value) -> claims.put(key, Arrays.asList(value)));
        }
        if ((subject = accessToken.getSubject()) != null && (userModel = this.authorization.getKeycloakSession().users().getUserById(subject, realm)) != null) {
            Set roleMappings = userModel.getRoleMappings();
            roleMappings.stream().map(RoleModel::getName).forEach(roleName -> accessToken.getRealmAccess().addRole(roleName));
            String clientId = representation.getClientId();
            if (clientId != null) {
                ClientModel clientModel = realm.getClientById(clientId);
                accessToken.addAccess(clientModel.getClientId());
                userModel.getClientRoleMappings(clientModel).stream().map(RoleModel::getName).forEach(roleName -> accessToken.getResourceAccess(clientModel.getClientId()).addRole(roleName));
            }
        }
        if (representation.getRoleIds() != null) {
            representation.getRoleIds().forEach(roleName -> accessToken.getRealmAccess().addRole(roleName));
        }
        return new KeycloakIdentity(accessToken, this.authorization.getKeycloakSession());
    }
}

