/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.AccessToken;

public class KeycloakEvaluationContext
implements EvaluationContext {
    private final KeycloakIdentity identity;
    private final KeycloakSession keycloakSession;

    public KeycloakEvaluationContext(KeycloakSession keycloakSession) {
        this(new KeycloakIdentity(keycloakSession), keycloakSession);
    }

    public KeycloakEvaluationContext(KeycloakIdentity identity, KeycloakSession keycloakSession) {
        this.identity = identity;
        this.keycloakSession = keycloakSession;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Attributes getAttributes() {
        List userAgents;
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("kc.time.date_time", Arrays.asList(new SimpleDateFormat("MM/dd/yyyy hh:mm:ss").format(new Date())));
        attributes.put("kc.client.network.ip_address", Arrays.asList(this.keycloakSession.getContext().getConnection().getRemoteAddr()));
        attributes.put("kc.client.network.host", Arrays.asList(this.keycloakSession.getContext().getConnection().getRemoteHost()));
        AccessToken accessToken = this.identity.getAccessToken();
        if (accessToken != null) {
            attributes.put("kc.client.id", Arrays.asList(accessToken.getIssuedFor()));
        }
        if ((userAgents = this.keycloakSession.getContext().getRequestHeaders().getRequestHeader("User-Agent")) != null) {
            attributes.put("kc.client.user_agent", userAgents);
        }
        attributes.put("kc.realm.name", Arrays.asList(this.keycloakSession.getContext().getRealm().getName()));
        return Attributes.from(attributes);
    }
}

