/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;

public class GroupMembershipMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-group-membership-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Group Membership";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map user group membership";
    }

    public static boolean useFullPath(ProtocolMapperModel mappingModel) {
        return "true".equals(mappingModel.getConfig().get("full.path"));
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInAccessToken(mappingModel)) {
            return token;
        }
        this.buildMembership((IDToken)token, mappingModel, userSession);
        return token;
    }

    public void buildMembership(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        LinkedList<String> membership = new LinkedList<String>();
        boolean fullPath = GroupMembershipMapper.useFullPath(mappingModel);
        for (GroupModel group : userSession.getUser().getGroups()) {
            if (fullPath) {
                membership.add(ModelToRepresentation.buildGroupPath((GroupModel)group));
                continue;
            }
            membership.add(group.getName());
        }
        String protocolClaim = (String)mappingModel.getConfig().get("claim.name");
        token.getOtherClaims().put(protocolClaim, membership);
    }

    @Override
    public IDToken transformIDToken(IDToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInIDToken(mappingModel)) {
            return token;
        }
        this.buildMembership(token, mappingModel, userSession);
        return token;
    }

    public static ProtocolMapperModel create(String name, String tokenClaimName, boolean consentRequired, String consentText, boolean accessToken, boolean idToken) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        mapper.setConsentRequired(consentRequired);
        mapper.setConsentText(consentText);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", tokenClaimName);
        if (accessToken) {
            config.put("access.token.claim", "true");
        }
        if (idToken) {
            config.put("id.token.claim", "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName("claim.name");
        property1.setLabel("tokenClaimName.label");
        property1.setType("String");
        property1.setDefaultValue((Object)"groups");
        property1.setHelpText("tokenClaimName.tooltip");
        configProperties.add(property1);
        property1 = new ProviderConfigProperty();
        property1.setName("full.path");
        property1.setLabel("Full group path");
        property1.setType("boolean");
        property1.setDefaultValue((Object)"true");
        property1.setHelpText("Include full path to group i.e. /top/level1/level2, false will just specify the group name");
        configProperties.add(property1);
        property1 = new ProviderConfigProperty();
        property1.setName("id.token.claim");
        property1.setLabel("includeInIdToken.label");
        property1.setType("boolean");
        property1.setDefaultValue((Object)"true");
        property1.setHelpText("includeInIdToken.tooltip");
        configProperties.add(property1);
        property1 = new ProviderConfigProperty();
        property1.setName("access.token.claim");
        property1.setLabel("includeInAccessToken.label");
        property1.setType("boolean");
        property1.setDefaultValue((Object)"true");
        property1.setHelpText("includeInAccessToken.tooltip");
        configProperties.add(property1);
    }
}

