/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;

public class ClientRegistrationService {
    private EventBuilder event;
    @Context
    private KeycloakSession session;

    public ClientRegistrationService(EventBuilder event) {
        this.event = event;
    }

    @Path(value="{provider}")
    public Object provider(@PathParam(value="provider") String providerId) {
        this.checkSsl();
        ClientRegistrationProvider provider = (ClientRegistrationProvider)this.session.getProvider(ClientRegistrationProvider.class, providerId);
        if (provider == null) {
            throw new NotFoundException("Client registration provider not found");
        }
        provider.setEvent(this.event);
        provider.setAuth(new ClientRegistrationAuth(this.session, provider, this.event, providerId));
        return provider;
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.session.getContext().getRealm().getSslRequired().isRequired(this.session.getContext().getConnection())) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }
}

