/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.theme.KeycloakSanitizerPolicy;

public class KeycloakSanitizerMethod
implements TemplateMethodModelEx {
    private static final Pattern HREF_PATTERN = Pattern.compile("\\s+href=\"([^\"]*)\"");

    public Object exec(List list) throws TemplateModelException {
        if (list.isEmpty() || list.get(0) == null) {
            throw new NullPointerException("Can not escape null value.");
        }
        String html = list.get(0).toString();
        String sanitized = KeycloakSanitizerPolicy.POLICY_DEFINITION.sanitize(html);
        return this.fixURLs(sanitized);
    }

    private String fixURLs(String msg) {
        Matcher matcher = HREF_PATTERN.matcher(msg);
        if (matcher.find()) {
            int last = 0;
            StringBuilder result = new StringBuilder(msg.length());
            do {
                String href = matcher.group(1).replaceAll("&#61;", "=").replaceAll("\\.\\.", ".").replaceAll("&amp;", "&");
                result.append(msg.substring(last, matcher.start(1))).append(href);
                last = matcher.end(1);
            } while (matcher.find());
            result.append(msg.substring(last));
            return result.toString();
        }
        return msg;
    }
}

