/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.List;
import java.util.Map;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyResourceService;
import org.keycloak.authorization.admin.PolicyService;
import org.keycloak.authorization.admin.PolicyTypeResourceService;
import org.keycloak.authorization.admin.PolicyTypeService;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class PermissionService
extends PolicyService {
    public PermissionService(ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        super(resourceServer, authorization, auth, adminEvent);
    }

    @Override
    protected PolicyResourceService doCreatePolicyResource(Policy policy) {
        return new PolicyTypeResourceService(policy, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    @Override
    protected PolicyTypeService doCreatePolicyTypeResource(final String type) {
        return new PolicyTypeService(type, this.resourceServer, this.authorization, this.auth, this.adminEvent){

            @Override
            protected List<Object> doSearch(Integer firstResult, Integer maxResult, String fields, Map<Policy.FilterOption, String[]> filters) {
                filters.put(Policy.FilterOption.PERMISSION, new String[]{Boolean.TRUE.toString()});
                filters.put(Policy.FilterOption.TYPE, new String[]{type});
                return super.doSearch(firstResult, maxResult, fields, filters);
            }
        };
    }

    @Override
    protected List<Object> doSearch(Integer firstResult, Integer maxResult, String fields, Map<Policy.FilterOption, String[]> filters) {
        filters.put(Policy.FilterOption.PERMISSION, new String[]{Boolean.TRUE.toString()});
        return super.doSearch(firstResult, maxResult, fields, filters);
    }

    @Override
    protected AbstractPolicyRepresentation toRepresentation(Policy policy, String fields, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation((Policy)policy, (AuthorizationProvider)authorization, (boolean)false, (boolean)false, (fields != null && fields.equals("*") ? 1 : 0) != 0);
    }
}

