/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.LockObjectsForModification;

public class KeycloakIdentity
implements Identity {
    protected final AccessToken accessToken;
    protected final RealmModel realm;
    protected final KeycloakSession keycloakSession;
    protected final Attributes attributes;
    private final boolean resourceServer;
    private final String id;

    public KeycloakIdentity(KeycloakSession keycloakSession) {
        this(Tokens.getAccessToken(keycloakSession), keycloakSession);
    }

    public KeycloakIdentity(KeycloakSession keycloakSession, IDToken token) {
        this(token, keycloakSession, keycloakSession.getContext().getRealm());
    }

    public KeycloakIdentity(IDToken token, KeycloakSession keycloakSession, RealmModel realm) {
        Map resourceAccess;
        if (token == null) {
            throw new ErrorResponseException("invalid_bearer_token", "Could not obtain bearer access_token from request.", Response.Status.FORBIDDEN);
        }
        if (keycloakSession == null) {
            throw new ErrorResponseException("no_keycloak_session", "No keycloak session", Response.Status.FORBIDDEN);
        }
        if (realm == null) {
            throw new ErrorResponseException("no_keycloak_session", "No realm set", Response.Status.FORBIDDEN);
        }
        this.keycloakSession = keycloakSession;
        this.realm = realm;
        HashMap attributes = new HashMap();
        try {
            ObjectNode objectNode = JsonSerialization.createObjectNode((Object)token);
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                JsonNode fieldValue = objectNode.get(fieldName);
                ArrayList<String> values = new ArrayList<String>();
                if (fieldValue.isArray()) {
                    Iterator valueIterator = fieldValue.iterator();
                    while (valueIterator.hasNext()) {
                        values.add(((JsonNode)valueIterator.next()).asText());
                    }
                } else if (!fieldValue.isObject()) {
                    String value = fieldValue.asText();
                    if (StringUtil.isNullOrEmpty((String)value)) continue;
                    values.add(value);
                } else {
                    values.add(fieldValue.toString());
                }
                if (values.isEmpty()) continue;
                attributes.put(fieldName, values);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading attributes from security token.", e);
        }
        if (token instanceof AccessToken) {
            this.accessToken = (AccessToken)AccessToken.class.cast(token);
        } else {
            UserSessionProvider sessions = keycloakSession.sessions();
            UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)keycloakSession, () -> sessions.getUserSession(realm, token.getSessionState()));
            if (userSession == null) {
                userSession = sessions.getOfflineUserSession(realm, token.getSessionState());
            }
            if (userSession == null) {
                throw new RuntimeException("No active session associated with the token");
            }
            ClientModel client = realm.getClientByClientId(token.getIssuedFor());
            AuthenticatedClientSessionModel clientSessionModel = userSession.getAuthenticatedClientSessionByClient(client.getId());
            DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionScopeParameter(clientSessionModel, keycloakSession);
            this.accessToken = new TokenManager().createClientAccessToken(keycloakSession, realm, client, userSession.getUser(), userSession, clientSessionCtx);
        }
        AccessToken.Access realmAccess = this.accessToken.getRealmAccess();
        if (realmAccess != null) {
            attributes.put("kc.realm.roles", realmAccess.getRoles());
        }
        if ((resourceAccess = this.accessToken.getResourceAccess()) != null) {
            resourceAccess.forEach((clientId, access) -> attributes.put("kc.client." + clientId + ".roles", access.getRoles()));
        }
        ClientModel clientModel = this.getTargetClient();
        UserModel clientUser = null;
        if (clientModel != null && clientModel.isServiceAccountsEnabled()) {
            clientUser = this.keycloakSession.users().getServiceAccount(clientModel);
        }
        UserModel userSession = this.getUserFromToken();
        this.resourceServer = clientUser != null && userSession.getId().equals(clientUser.getId());
        this.id = this.resourceServer ? clientModel.getId() : userSession.getId();
        this.attributes = Attributes.from(attributes);
    }

    public KeycloakIdentity(AccessToken accessToken, KeycloakSession keycloakSession) {
        if (accessToken == null) {
            throw new ErrorResponseException("invalid_bearer_token", "Could not obtain bearer access_token from request.", Response.Status.FORBIDDEN);
        }
        if (keycloakSession == null) {
            throw new ErrorResponseException("no_keycloak_session", "No keycloak session", Response.Status.FORBIDDEN);
        }
        this.accessToken = accessToken;
        this.keycloakSession = keycloakSession;
        this.realm = keycloakSession.getContext().getRealm();
        HashMap attributes = new HashMap();
        try {
            UserModel userSession;
            Map resourceAccess;
            ObjectNode objectNode = JsonSerialization.createObjectNode((Object)this.accessToken);
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                JsonNode fieldValue = objectNode.get(fieldName);
                ArrayList<String> values = new ArrayList<String>();
                if (fieldValue.isArray()) {
                    Iterator valueIterator = fieldValue.iterator();
                    while (valueIterator.hasNext()) {
                        values.add(((JsonNode)valueIterator.next()).asText());
                    }
                } else if (fieldValue.isObject()) {
                    values.add(fieldValue.toString());
                } else {
                    String value = fieldValue.asText();
                    if (StringUtil.isNullOrEmpty((String)value)) continue;
                    values.add(value);
                }
                if (values.isEmpty()) continue;
                attributes.put(fieldName, values);
            }
            AccessToken.Access realmAccess = accessToken.getRealmAccess();
            if (realmAccess != null) {
                attributes.put("kc.realm.roles", realmAccess.getRoles());
            }
            if ((resourceAccess = accessToken.getResourceAccess()) != null) {
                resourceAccess.forEach((clientId, access) -> attributes.put("kc.client." + clientId + ".roles", access.getRoles()));
            }
            ClientModel clientModel = this.getTargetClient();
            UserModel clientUser = null;
            if (clientModel != null && clientModel.isServiceAccountsEnabled()) {
                clientUser = this.keycloakSession.users().getServiceAccount(clientModel);
            }
            if ((userSession = this.getUserFromToken()) == null) {
                throw new IllegalArgumentException("User from token not found");
            }
            boolean bl = this.resourceServer = clientUser != null && userSession.getId().equals(clientUser.getId());
            this.id = this.resourceServer ? clientModel.getId() : userSession.getId();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading attributes from security token.", e);
        }
        this.attributes = Attributes.from(attributes);
    }

    public String getId() {
        return this.id;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public boolean isResourceServer() {
        return this.resourceServer;
    }

    private ClientModel getTargetClient() {
        if (this.accessToken.getIssuedFor() != null) {
            return this.realm.getClientByClientId(this.accessToken.getIssuedFor());
        }
        if (this.accessToken.getAudience() != null && this.accessToken.getAudience().length > 0) {
            String audience = this.accessToken.getAudience()[0];
            return this.realm.getClientByClientId(audience);
        }
        return null;
    }

    private UserModel getUserFromToken() {
        if (this.accessToken.getSessionState() == null) {
            return TokenManager.lookupUserFromStatelessToken(this.keycloakSession, this.realm, this.accessToken);
        }
        UserSessionProvider sessions = this.keycloakSession.sessions();
        UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.keycloakSession, () -> sessions.getUserSession(this.realm, this.accessToken.getSessionState()));
        if (userSession == null) {
            userSession = sessions.getOfflineUserSession(this.realm, this.accessToken.getSessionState());
        }
        return userSession.getUser();
    }
}

