/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.broker.saml.SAMLDataMarshaller;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.saml.ArtifactResolver;
import org.keycloak.protocol.saml.ArtifactResolverProcessingException;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.protocol.saml.mappers.SAMLLoginResponseMapper;
import org.keycloak.protocol.saml.mappers.SAMLNameIdMapper;
import org.keycloak.protocol.saml.mappers.SAMLRoleListMapper;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.saml.SAML2ErrorResponseBuilder;
import org.keycloak.saml.SAML2LoginResponseBuilder;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAML2NameIDBuilder;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.XmlKeyInfoKeyNameTransformer;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.w3c.dom.Document;

public class SamlProtocol
implements LoginProtocol {
    public static final String ATTRIBUTE_TRUE_VALUE = "true";
    public static final String ATTRIBUTE_FALSE_VALUE = "false";
    public static final String SAML_ASSERTION_CONSUMER_URL_POST_ATTRIBUTE = "saml_assertion_consumer_url_post";
    public static final String SAML_ASSERTION_CONSUMER_URL_REDIRECT_ATTRIBUTE = "saml_assertion_consumer_url_redirect";
    public static final String SAML_ASSERTION_CONSUMER_URL_ARTIFACT_ATTRIBUTE = "saml_artifact_binding_url";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE = "saml_single_logout_service_url_post";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_ARTIFACT_ATTRIBUTE = "saml_single_logout_service_url_artifact";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE = "saml_single_logout_service_url_redirect";
    public static final String SAML_SINGLE_LOGOUT_SERVICE_URL_SOAP_ATTRIBUTE = "saml_single_logout_service_url_soap";
    public static final String SAML_ARTIFACT_RESOLUTION_SERVICE_URL_ATTRIBUTE = "saml_artifact_resolution_service_url";
    public static final String LOGIN_PROTOCOL = "saml";
    public static final String SAML_BINDING = "saml_binding";
    public static final String SAML_IDP_INITIATED_LOGIN = "saml_idp_initiated_login";
    public static final String SAML_POST_BINDING = "post";
    public static final String SAML_SOAP_BINDING = "soap";
    public static final String SAML_REDIRECT_BINDING = "get";
    public static final String SAML_REQUEST_ID = "SAML_REQUEST_ID";
    public static final String SAML_REQUEST_ID_BROKER = "SAML_REQUEST_ID_BROKER";
    public static final String SAML_LOGOUT_BINDING = "saml.logout.binding";
    public static final String SAML_LOGOUT_ADD_EXTENSIONS_ELEMENT_WITH_KEY_INFO = "saml.logout.addExtensionsElementWithKeyInfo";
    public static final String SAML_SERVER_SIGNATURE_KEYINFO_KEY_NAME_TRANSFORMER = "SAML_SERVER_SIGNATURE_KEYINFO_KEY_NAME_TRANSFORMER";
    public static final String SAML_LOGOUT_REQUEST_ID = "SAML_LOGOUT_REQUEST_ID";
    public static final String SAML_LOGOUT_RELAY_STATE = "SAML_LOGOUT_RELAY_STATE";
    public static final String SAML_LOGOUT_CANONICALIZATION = "SAML_LOGOUT_CANONICALIZATION";
    public static final String SAML_LOGOUT_BINDING_URI = "SAML_LOGOUT_BINDING_URI";
    public static final String SAML_LOGOUT_SIGNATURE_ALGORITHM = "saml.logout.signature.algorithm";
    public static final String SAML_NAME_ID = "SAML_NAME_ID";
    public static final String SAML_NAME_ID_FORMAT = "SAML_NAME_ID_FORMAT";
    public static final String SAML_DEFAULT_NAMEID_FORMAT = JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get();
    public static final String SAML_PERSISTENT_NAME_ID_FOR = "saml.persistent.name.id.for";
    public static final String SAML_IDP_INITIATED_SSO_RELAY_STATE = "saml_idp_initiated_sso_relay_state";
    public static final String SAML_IDP_INITIATED_SSO_URL_NAME = "saml_idp_initiated_sso_url_name";
    public static final String SAML_LOGIN_REQUEST_FORCEAUTHN = "SAML_LOGIN_REQUEST_FORCEAUTHN";
    public static final String SAML_FORCEAUTHN_REQUIREMENT = "true";
    public static final String SAML_LOGOUT_INITIATOR_CLIENT_ID = "SAML_LOGOUT_INITIATOR_CLIENT_ID";
    public static final String USER_SESSION_ID = "userSessionId";
    public static final String CLIENT_SESSION_ID = "clientSessionId";
    protected static final Logger logger = Logger.getLogger(SamlProtocol.class);
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;
    protected HttpHeaders headers;
    protected EventBuilder event;
    protected ArtifactResolver artifactResolver;
    protected SingleUseObjectProvider singleUseStore;

    public SamlProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public SamlProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public SamlProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public SamlProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public SamlProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    private ArtifactResolver getArtifactResolver() {
        if (this.artifactResolver == null) {
            this.artifactResolver = (ArtifactResolver)this.session.getProvider(ArtifactResolver.class);
        }
        return this.artifactResolver;
    }

    private SingleUseObjectProvider getSingleUseStore() {
        if (this.singleUseStore == null) {
            this.singleUseStore = this.session.singleUseObjects();
        }
        return this.singleUseStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response sendError(AuthenticationSessionModel authSession, LoginProtocol.Error error) {
        try {
            ClientModel client = authSession.getClient();
            if ("true".equals(authSession.getClientNote(SAML_IDP_INITIATED_LOGIN))) {
                if (error == LoginProtocol.Error.CANCELLED_BY_USER) {
                    UriBuilder builder = RealmsResource.protocolUrl(this.uriInfo).path(SamlService.class, "idpInitiatedSSO");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("realm", this.realm.getName());
                    params.put("protocol", LOGIN_PROTOCOL);
                    params.put("client", client.getAttribute(SAML_IDP_INITIATED_SSO_URL_NAME));
                    URI redirect = builder.buildFromMap(params);
                    Response response = Response.status((int)302).location(redirect).build();
                    return response;
                }
                Response response = ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, this.translateErrorToIdpInitiatedErrorMessage(error), new Object[0]);
                return response;
            }
            Response response = this.samlErrorMessage(authSession, new SamlClient(client), this.isPostBinding(authSession), authSession.getRedirectUri(), this.translateErrorToSAMLStatus(error), authSession.getClientNote("RelayState"));
            return response;
        }
        finally {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, true);
        }
    }

    private Response samlErrorMessage(AuthenticationSessionModel authSession, SamlClient samlClient, boolean isPostBinding, String destination, JBossSAMLURIConstants statusDetail, String relayState) {
        JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder(this.session).relayState(relayState);
        SAML2ErrorResponseBuilder builder = new SAML2ErrorResponseBuilder().destination(destination).issuer(this.getResponseIssuer(this.realm)).status(statusDetail.get());
        KeyManager keyManager = this.session.keys();
        if (samlClient.requiresRealmSignature()) {
            KeyManager.ActiveRsaKey keys = keyManager.getActiveRsaKey(this.realm);
            String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
            String canonicalization = samlClient.getCanonicalizationMethod();
            if (canonicalization != null) {
                binding.canonicalizationMethod(canonicalization);
            }
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
        }
        try {
            Document document = builder.buildDocument();
            return this.buildErrorResponse(isPostBinding, destination, binding, document);
        }
        catch (Exception e) {
            return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
        }
    }

    protected Response buildErrorResponse(boolean isPostBinding, String destination, JaxrsSAML2BindingBuilder binding, Document document) throws ConfigurationException, ProcessingException, IOException {
        if (isPostBinding) {
            return binding.postBinding(document).response(destination);
        }
        return binding.redirectBinding(document).response(destination);
    }

    private JBossSAMLURIConstants translateErrorToSAMLStatus(LoginProtocol.Error error) {
        switch (error) {
            case CANCELLED_BY_USER: 
            case CANCELLED_AIA: 
            case CONSENT_DENIED: {
                return JBossSAMLURIConstants.STATUS_REQUEST_DENIED;
            }
            case PASSIVE_INTERACTION_REQUIRED: 
            case PASSIVE_LOGIN_REQUIRED: {
                return JBossSAMLURIConstants.STATUS_NO_PASSIVE;
            }
        }
        logger.warn((Object)("Untranslated protocol Error: " + error.name() + " so we return default SAML error"));
        return JBossSAMLURIConstants.STATUS_REQUEST_DENIED;
    }

    private String translateErrorToIdpInitiatedErrorMessage(LoginProtocol.Error error) {
        switch (error) {
            case CONSENT_DENIED: {
                return "consentDenied";
            }
            case PASSIVE_INTERACTION_REQUIRED: 
            case PASSIVE_LOGIN_REQUIRED: {
                return "unexpectedErrorHandlingRequestMessage";
            }
        }
        logger.warn((Object)("Untranslated protocol Error: " + error.name() + " so we return default error message"));
        return "unexpectedErrorHandlingRequestMessage";
    }

    protected String getResponseIssuer(RealmModel realm) {
        return RealmsResource.realmBaseUrl(this.uriInfo).build(new Object[]{realm.getName()}).toString();
    }

    protected boolean isPostBinding(AuthenticationSessionModel authSession) {
        ClientModel client = authSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        return SAML_POST_BINDING.equals(authSession.getClientNote(SAML_BINDING)) || samlClient.forcePostBinding();
    }

    protected boolean isPostBinding(AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        return SAML_POST_BINDING.equals(clientSession.getNote(SAML_BINDING)) || samlClient.forcePostBinding();
    }

    public static boolean isLogoutPostBindingForInitiator(UserSessionModel session) {
        String note = session.getNote(SAML_LOGOUT_BINDING);
        return SAML_POST_BINDING.equals(note);
    }

    protected boolean isLogoutPostBindingForClient(AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        String logoutPostUrl = client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE);
        String logoutRedirectUrl = client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE);
        if (logoutPostUrl == null || logoutPostUrl.trim().isEmpty()) {
            return logoutRedirectUrl == null || logoutRedirectUrl.trim().isEmpty();
        }
        if (samlClient.forcePostBinding()) {
            return true;
        }
        String bindingType = clientSession.getNote(SAML_BINDING);
        if (SAML_POST_BINDING.equals(bindingType)) {
            return true;
        }
        return logoutRedirectUrl == null || logoutRedirectUrl.trim().isEmpty();
    }

    protected String getNameIdFormat(SamlClient samlClient, AuthenticationSessionModel authSession) {
        String nameIdFormat = authSession.getClientNote("NAMEID_FORMAT");
        boolean forceFormat = samlClient.forceNameIDFormat();
        String configuredNameIdFormat = samlClient.getNameIDFormat();
        if ((nameIdFormat == null || forceFormat) && configuredNameIdFormat != null) {
            nameIdFormat = configuredNameIdFormat;
        }
        if (nameIdFormat == null) {
            return SAML_DEFAULT_NAMEID_FORMAT;
        }
        return nameIdFormat;
    }

    protected String getNameId(String nameIdFormat, CommonClientSessionModel clientSession, UserSessionModel userSession) {
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
            String email = userSession.getUser().getEmail();
            if (email == null) {
                logger.debugf("E-mail of the user %s has to be set for %s NameIDFormat", (Object)userSession.getUser().getUsername(), (Object)JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get());
            }
            return email;
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get())) {
            return "G-" + UUID.randomUUID().toString();
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get())) {
            return this.getPersistentNameId(clientSession, userSession);
        }
        if (nameIdFormat.equals(JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get())) {
            return userSession.getUser().getUsername();
        }
        return userSession.getUser().getUsername();
    }

    protected String getPersistentNameId(CommonClientSessionModel clientSession, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        String clientNameId = String.format("%s.%s", SAML_PERSISTENT_NAME_ID_FOR, clientSession.getClient().getClientId());
        String samlPersistentNameId = user.getFirstAttribute(clientNameId);
        if (samlPersistentNameId != null) {
            return samlPersistentNameId;
        }
        String wildcardNameId = String.format("%s.*", SAML_PERSISTENT_NAME_ID_FOR);
        samlPersistentNameId = user.getFirstAttribute(wildcardNameId);
        if (samlPersistentNameId != null) {
            return samlPersistentNameId;
        }
        samlPersistentNameId = "G-" + UUID.randomUUID().toString();
        user.setSingleAttribute(clientNameId, samlPersistentNameId);
        return samlPersistentNameId;
    }

    public Response authenticated(AuthenticationSessionModel authSession, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        String requestID = authSession.getClientNote(SAML_REQUEST_ID);
        String relayState = authSession.getClientNote("RelayState");
        String redirectUri = authSession.getRedirectUri();
        String responseIssuer = this.getResponseIssuer(this.realm);
        String nameIdFormat = this.getNameIdFormat(samlClient, authSession);
        int assertionLifespan = samlClient.getAssertionLifespan();
        SAML2LoginResponseBuilder builder = new SAML2LoginResponseBuilder();
        builder.requestID(requestID).destination(redirectUri).issuer(responseIssuer).assertionExpiration(assertionLifespan <= 0 ? this.realm.getAccessCodeLifespan() : assertionLifespan).subjectExpiration(assertionLifespan <= 0 ? this.realm.getAccessTokenLifespan() : assertionLifespan).sessionExpiration(this.realm.getSsoSessionMaxLifespan()).requestIssuer(clientSession.getClient().getClientId()).authMethod(JBossSAMLURIConstants.AC_UNSPECIFIED.get());
        String sessionIndex = SamlSessionUtils.getSessionIndex(clientSession);
        builder.sessionIndex(sessionIndex);
        if (!samlClient.includeAuthnStatement()) {
            builder.disableAuthnStatement(true);
        }
        builder.includeOneTimeUseCondition(samlClient.includeOneTimeUseCondition());
        LinkedList<ProtocolMapperProcessor<SAMLAttributeStatementMapper>> attributeStatementMappers = new LinkedList<ProtocolMapperProcessor<SAMLAttributeStatementMapper>>();
        LinkedList<ProtocolMapperProcessor<SAMLLoginResponseMapper>> loginResponseMappers = new LinkedList<ProtocolMapperProcessor<SAMLLoginResponseMapper>>();
        AtomicReference<Object> roleListMapper = new AtomicReference<Object>(null);
        LinkedList<ProtocolMapperProcessor<SAMLNameIdMapper>> samlNameIdMappers = new LinkedList<ProtocolMapperProcessor<SAMLNameIdMapper>>();
        ProtocolMapperUtils.getSortedProtocolMappers(this.session, clientSessionCtx).forEach(entry -> {
            ProtocolMapperModel mapping = (ProtocolMapperModel)entry.getKey();
            ProtocolMapper mapper = (ProtocolMapper)entry.getValue();
            if (mapper instanceof SAMLAttributeStatementMapper) {
                attributeStatementMappers.add(new ProtocolMapperProcessor<SAMLAttributeStatementMapper>((SAMLAttributeStatementMapper)mapper, mapping));
            }
            if (mapper instanceof SAMLLoginResponseMapper) {
                loginResponseMappers.add(new ProtocolMapperProcessor<SAMLLoginResponseMapper>((SAMLLoginResponseMapper)mapper, mapping));
            }
            if (mapper instanceof SAMLRoleListMapper) {
                roleListMapper.set(new ProtocolMapperProcessor<SAMLRoleListMapper>((SAMLRoleListMapper)mapper, mapping));
            }
            if (mapper instanceof SAMLNameIdMapper) {
                samlNameIdMappers.add(new ProtocolMapperProcessor<SAMLNameIdMapper>((SAMLNameIdMapper)mapper, mapping));
            }
        });
        Document samlDocument = null;
        ResponseType samlModel = null;
        KeyManager keyManager = this.session.keys();
        KeyWrapper keyPair = keyManager.getActiveKey(this.realm, KeyUse.SIG, "RS256");
        boolean postBinding = this.isPostBinding(authSession);
        String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keyPair.getKid(), keyPair.getCertificate());
        String nameId = this.getSAMLNameId(samlNameIdMappers, nameIdFormat, this.session, userSession, clientSession);
        if (nameId == null) {
            return this.samlErrorMessage(null, samlClient, this.isPostBinding(authSession), redirectUri, JBossSAMLURIConstants.STATUS_INVALID_NAMEIDPOLICY, relayState);
        }
        builder.nameIdentifier(nameIdFormat, nameId);
        clientSession.setNote(SAML_NAME_ID, nameId);
        clientSession.setNote(SAML_NAME_ID_FORMAT, nameIdFormat);
        try {
            if (!postBinding && samlClient.requiresRealmSignature() && samlClient.addExtensionsElementWithKeyInfo()) {
                builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
            }
            samlModel = builder.buildModel();
            AttributeStatementType attributeStatement = this.populateAttributeStatements(attributeStatementMappers, this.session, userSession, clientSession);
            this.populateRoles(roleListMapper.get(), this.session, userSession, clientSessionCtx, attributeStatement);
            if (attributeStatement.getAttributes().size() > 0) {
                AssertionType assertion = ((ResponseType.RTChoiceType)samlModel.getAssertions().get(0)).getAssertion();
                assertion.addStatement((StatementAbstractType)attributeStatement);
            }
            samlModel = this.transformLoginResponse(loginResponseMappers, samlModel, this.session, userSession, clientSessionCtx);
        }
        catch (Exception e) {
            logger.error((Object)"failed", (Throwable)e);
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
        }
        JaxrsSAML2BindingBuilder bindingBuilder = new JaxrsSAML2BindingBuilder(this.session);
        bindingBuilder.relayState(relayState);
        if ("true".equals(clientSession.getNote(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get()))) {
            try {
                return this.buildArtifactAuthenticatedResponse(clientSession, redirectUri, (SAML2Object)samlModel, bindingBuilder);
            }
            catch (Exception e) {
                logger.error((Object)"failed", (Throwable)e);
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
            }
        }
        if (samlClient.requiresRealmSignature() || samlClient.requiresAssertionSignature()) {
            String canonicalization = samlClient.getCanonicalizationMethod();
            if (canonicalization != null) {
                bindingBuilder.canonicalizationMethod(canonicalization);
            }
            ((JaxrsSAML2BindingBuilder)bindingBuilder.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, (PrivateKey)keyPair.getPrivateKey(), (PublicKey)keyPair.getPublicKey(), keyPair.getCertificate());
            if (samlClient.requiresRealmSignature()) {
                bindingBuilder.signDocument();
            }
            if (samlClient.requiresAssertionSignature()) {
                bindingBuilder.signAssertions();
            }
        }
        if (samlClient.requiresEncryption()) {
            PublicKey publicKey = null;
            try {
                publicKey = SamlProtocolUtils.getEncryptionKey(client);
            }
            catch (Exception e) {
                logger.error((Object)"failed", (Throwable)e);
                return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
            }
            bindingBuilder.encrypt(publicKey);
        }
        try {
            samlDocument = builder.buildDocument(samlModel);
            return this.buildAuthenticatedResponse(clientSession, redirectUri, samlDocument, bindingBuilder);
        }
        catch (Exception e) {
            logger.error((Object)"failed", (Throwable)e);
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedToProcessResponseMessage", new Object[0]);
        }
    }

    protected Response buildAuthenticatedResponse(AuthenticatedClientSessionModel clientSession, String redirectUri, Document samlDocument, JaxrsSAML2BindingBuilder bindingBuilder) throws ConfigurationException, ProcessingException, IOException {
        if (this.isPostBinding(clientSession)) {
            return bindingBuilder.postBinding(samlDocument).response(redirectUri);
        }
        return bindingBuilder.redirectBinding(samlDocument).response(redirectUri);
    }

    public AttributeStatementType populateAttributeStatements(List<ProtocolMapperProcessor<SAMLAttributeStatementMapper>> attributeStatementMappers, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        AttributeStatementType attributeStatement = new AttributeStatementType();
        for (ProtocolMapperProcessor<SAMLAttributeStatementMapper> processor : attributeStatementMappers) {
            ((SAMLAttributeStatementMapper)processor.mapper).transformAttributeStatement(attributeStatement, processor.model, session, userSession, clientSession);
        }
        return attributeStatement;
    }

    public ResponseType transformLoginResponse(List<ProtocolMapperProcessor<SAMLLoginResponseMapper>> mappers, ResponseType response, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        for (ProtocolMapperProcessor<SAMLLoginResponseMapper> processor : mappers) {
            response = ((SAMLLoginResponseMapper)processor.mapper).transformLoginResponse(response, processor.model, session, userSession, clientSessionCtx);
        }
        Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(session);
        while (it.hasNext()) {
            response = (ResponseType)it.next().beforeSendingResponse((StatusResponseType)response, clientSessionCtx.getClientSession());
        }
        return response;
    }

    public void populateRoles(ProtocolMapperProcessor<SAMLRoleListMapper> roleListMapper, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx, AttributeStatementType existingAttributeStatement) {
        if (roleListMapper == null) {
            return;
        }
        ((SAMLRoleListMapper)roleListMapper.mapper).mapRoles(existingAttributeStatement, roleListMapper.model, session, userSession, clientSessionCtx);
    }

    protected String getSAMLNameId(List<ProtocolMapperProcessor<SAMLNameIdMapper>> samlNameIdMappers, String nameIdFormat, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        for (ProtocolMapperProcessor<SAMLNameIdMapper> nameIdMap : samlNameIdMappers) {
            if (!nameIdFormat.equals(nameIdMap.model.getConfig().get("mapper.nameid.format"))) continue;
            return ((SAMLNameIdMapper)nameIdMap.mapper).mapperNameId(nameIdFormat, nameIdMap.model, session, userSession, clientSession);
        }
        return this.getNameId(nameIdFormat, (CommonClientSessionModel)clientSession, userSession);
    }

    public static String getLogoutServiceUrl(KeycloakSession session, ClientModel client, String bindingType, boolean backChannelLogout) {
        String logoutServiceUrl = null;
        if (SAML_SOAP_BINDING.equals(bindingType)) {
            logoutServiceUrl = client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_SOAP_ATTRIBUTE);
            return logoutServiceUrl == null || logoutServiceUrl.trim().equals("") ? null : logoutServiceUrl;
        }
        logoutServiceUrl = !backChannelLogout && SamlProtocol.useArtifactForLogout(client) ? client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_ARTIFACT_ATTRIBUTE) : (SAML_POST_BINDING.equals(bindingType) ? client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_POST_ATTRIBUTE) : client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_ATTRIBUTE));
        if (logoutServiceUrl == null) {
            logoutServiceUrl = client.getManagementUrl();
        }
        if (logoutServiceUrl == null || logoutServiceUrl.trim().equals("")) {
            return null;
        }
        return ResourceAdminManager.resolveUri(session, client.getRootUrl(), logoutServiceUrl);
    }

    public static boolean useArtifactForLogout(ClientModel client) {
        return new SamlClient(client).forceArtifactBinding() && client.getAttribute(SAML_SINGLE_LOGOUT_SERVICE_URL_ARTIFACT_ATTRIBUTE) != null;
    }

    public Response frontchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        try {
            boolean postBinding = this.isLogoutPostBindingForClient(clientSession);
            String bindingUri = SamlProtocol.getLogoutServiceUrl(this.session, client, postBinding ? SAML_POST_BINDING : SAML_REDIRECT_BINDING, false);
            if (bindingUri == null) {
                logger.warnf("Failed to logout client %s, skipping this client.  Please configure the logout service url in the admin console for your client applications.", (Object)client.getClientId());
                return null;
            }
            SamlProtocolExtensionsAwareBuilder.NodeGenerator[] extensions = new SamlProtocolExtensionsAwareBuilder.NodeGenerator[]{};
            if (!postBinding && samlClient.requiresRealmSignature() && samlClient.addExtensionsElementWithKeyInfo()) {
                KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(this.realm);
                String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                extensions = new SamlProtocolExtensionsAwareBuilder.NodeGenerator[]{new KeycloakKeySamlExtensionGenerator(keyName)};
            }
            LogoutRequestType logoutRequest = this.createLogoutRequest(bindingUri, clientSession, client, extensions);
            JaxrsSAML2BindingBuilder binding = this.createBindingBuilder(samlClient, "true".equals(clientSession.getNote(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get())));
            if ("true".equals(clientSession.getNote(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get())) && SamlProtocol.useArtifactForLogout(client)) {
                clientSession.setAction(CommonClientSessionModel.Action.LOGGING_OUT.name());
                return this.buildArtifactAuthenticatedResponse(clientSession, bindingUri, (SAML2Object)logoutRequest, binding);
            }
            Document samlDocument = SAML2Request.convert((RequestAbstractType)logoutRequest);
            if (postBinding) {
                return binding.postBinding(samlDocument).request(bindingUri);
            }
            logger.debug((Object)"frontchannel redirect binding");
            return binding.redirectBinding(samlDocument).request(bindingUri);
        }
        catch (IOException | ConfigurationException | ParsingException | ProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Response finishBrowserLogout(UserSessionModel userSession, AuthenticationSessionModel logoutSession) {
        Response response;
        logger.debug((Object)"finishLogout");
        String logoutBindingUri = userSession.getNote(SAML_LOGOUT_BINDING_URI);
        if (logoutBindingUri == null) {
            logger.error((Object)"Can't finish SAML logout as there is no logout binding set.  Please configure the logout service url in the admin console for your client applications.");
            return ErrorPage.error(this.session, null, Response.Status.BAD_REQUEST, "failedLogout", new Object[0]);
        }
        String logoutRelayState = userSession.getNote(SAML_LOGOUT_RELAY_STATE);
        SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
        builder.logoutRequestID(userSession.getNote(SAML_LOGOUT_REQUEST_ID));
        builder.destination(logoutBindingUri);
        builder.issuer(this.getResponseIssuer(this.realm));
        JaxrsSAML2BindingBuilder binding = new JaxrsSAML2BindingBuilder(this.session);
        binding.relayState(logoutRelayState);
        String signingAlgorithm = userSession.getNote(SAML_LOGOUT_SIGNATURE_ALGORITHM);
        boolean postBinding = SamlProtocol.isLogoutPostBindingForInitiator(userSession);
        if (signingAlgorithm != null) {
            boolean addExtension;
            SignatureAlgorithm algorithm = SignatureAlgorithm.valueOf((String)signingAlgorithm);
            String canonicalization = userSession.getNote(SAML_LOGOUT_CANONICALIZATION);
            if (canonicalization != null) {
                binding.canonicalizationMethod(canonicalization);
            }
            KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(this.realm);
            XmlKeyInfoKeyNameTransformer transformer = XmlKeyInfoKeyNameTransformer.from((String)userSession.getNote(SAML_SERVER_SIGNATURE_KEYINFO_KEY_NAME_TRANSFORMER), (XmlKeyInfoKeyNameTransformer)SamlClient.DEFAULT_XML_KEY_INFO_KEY_NAME_TRANSFORMER);
            String keyName = transformer.getKeyName(keys.getKid(), keys.getCertificate());
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(algorithm)).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
            boolean bl = addExtension = !postBinding && Objects.equals("true", userSession.getNote(SAML_LOGOUT_ADD_EXTENSIONS_ELEMENT_WITH_KEY_INFO));
            if (addExtension) {
                builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
            }
        }
        try {
            response = this.buildLogoutResponse(userSession, logoutBindingUri, builder, binding);
        }
        catch (IOException | ConfigurationException | ProcessingException e) {
            throw new RuntimeException(e);
        }
        if (logoutBindingUri != null) {
            this.event.detail("redirect_uri", logoutBindingUri);
        }
        this.event.event(EventType.LOGOUT).detail("auth_method", userSession.getAuthMethod()).client(this.session.getContext().getClient()).user(userSession.getUser()).session(userSession).detail("username", userSession.getLoginUsername()).detail("response_mode", postBinding ? SAML_POST_BINDING : SAML_REDIRECT_BINDING).detail(SAML_LOGOUT_REQUEST_ID, userSession.getNote(SAML_LOGOUT_REQUEST_ID)).success();
        return response;
    }

    protected Response buildLogoutResponse(UserSessionModel userSession, String logoutBindingUri, SAML2LogoutResponseBuilder builder, JaxrsSAML2BindingBuilder binding) throws ConfigurationException, ProcessingException, IOException {
        if ("true".equals(userSession.getNote(JBossSAMLURIConstants.SAML_HTTP_ARTIFACT_BINDING.get()))) {
            return this.buildLogoutArtifactResponse(userSession, logoutBindingUri, builder.buildModel(), binding);
        }
        Document samlDocument = builder.buildDocument();
        if (SamlProtocol.isLogoutPostBindingForInitiator(userSession)) {
            return binding.postBinding(samlDocument).response(logoutBindingUri);
        }
        return binding.redirectBinding(samlDocument).response(logoutBindingUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response backchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        SamlClient samlClient = new SamlClient(client);
        String soapLogoutUrl = SamlProtocol.getLogoutServiceUrl(this.session, client, SAML_SOAP_BINDING, true);
        if (soapLogoutUrl != null) {
            try {
                LogoutRequestType logoutRequest = this.createLogoutRequest(soapLogoutUrl, clientSession, client, new SamlProtocolExtensionsAwareBuilder.NodeGenerator[0]);
                Document samlLogoutRequest = this.createBindingBuilder(samlClient, false).soapBinding(SAML2Request.convert((RequestAbstractType)logoutRequest)).getDocument();
                SOAPMessage soapResponse = Soap.createMessage().addMimeHeader("SOAPAction", "http://www.oasis-open.org/committees/security").addToBody(samlLogoutRequest).call(soapLogoutUrl, this.session);
                Document logoutResponse = Soap.extractSoapMessage(soapResponse);
                SAMLDocumentHolder samlDocResponse = SAML2Response.getSAML2ObjectFromDocument((Document)logoutResponse);
                if (!this.validateLogoutResponse(logoutRequest, samlDocResponse, client)) {
                    return Response.serverError().build();
                }
                return Response.ok().build();
            }
            catch (SOAPException e) {
                logger.warnf((Throwable)e, "Logout failed for client %s", (Object)client.getClientId());
                return Response.serverError().build();
            }
            catch (Exception e) {
                logger.warn((Object)"failed to execute saml soap logout", (Throwable)e);
                return Response.serverError().build();
            }
        }
        logger.warnf("Can't do SOAP backchannel logout. No SingleLogoutService SOAP Binding registered for client %s; fallback on legacy backchannel logout", (Object)client.getClientId());
        String logoutUrl = SamlProtocol.getLogoutServiceUrl(this.session, client, SAML_POST_BINDING, true);
        if (logoutUrl == null) {
            logger.warnf("Can't do backchannel logout. No SingleLogoutService POST Binding registered for client: %s", (Object)client.getClientId());
            return Response.serverError().build();
        }
        String logoutRequestString = null;
        try {
            LogoutRequestType logoutRequest = this.createLogoutRequest(logoutUrl, clientSession, client, new SamlProtocolExtensionsAwareBuilder.NodeGenerator[0]);
            JaxrsSAML2BindingBuilder binding = this.createBindingBuilder(samlClient, false);
            logoutRequestString = binding.postBinding(SAML2Request.convert((RequestAbstractType)logoutRequest)).encoded();
        }
        catch (Exception e) {
            logger.warn((Object)"failed to send saml logout", (Throwable)e);
            return Response.serverError().build();
        }
        CloseableHttpClient httpClient = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).getHttpClient();
        for (int i = 0; i < 2; ++i) {
            try {
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                formparams.add(new BasicNameValuePair("SAMLRequest", logoutRequestString));
                formparams.add(new BasicNameValuePair("BACK_CHANNEL_LOGOUT", "BACK_CHANNEL_LOGOUT"));
                UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
                HttpPost post = new HttpPost(logoutUrl);
                post.setEntity((HttpEntity)form);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                    try {
                        int status = response.getStatusLine().getStatusCode();
                        if (status != 302 || logoutUrl.endsWith("/")) break;
                        String redirect = response.getFirstHeader("Location").getValue();
                        String withSlash = logoutUrl + "/";
                        if (!withSlash.equals(redirect)) break;
                        logoutUrl = withSlash;
                        continue;
                    }
                    finally {
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    }
                }
            }
            catch (IOException e) {
                logger.warn((Object)"failed to send saml logout", (Throwable)e);
                return Response.serverError().build();
            }
        }
        return Response.ok().build();
    }

    private boolean validateLogoutResponse(LogoutRequestType logoutRequest, SAMLDocumentHolder holder, ClientModel client) {
        if (!(holder.getSamlObject() instanceof StatusResponseType)) {
            logger.warn((Object)"Logout response format is not valid");
            return false;
        }
        if (new SamlClient(client).requiresClientSignature()) {
            try {
                SamlProtocolUtils.verifyDocumentSignature(client, holder.getSamlDocument());
            }
            catch (VerificationException ex) {
                logger.warnf("Logout response from client %s contains invalid signature", (Object)client.getClientId());
                return false;
            }
        }
        StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
        String issuer = statusResponse.getIssuer().getValue();
        if (!client.getClientId().equals(issuer)) {
            logger.warn((Object)"Logout response contains wrong 'issuer' value");
            return false;
        }
        if (!logoutRequest.getID().equals(statusResponse.getInResponseTo())) {
            logger.warn((Object)"Logout response contains wrong 'inResponseTo' value");
            return false;
        }
        return true;
    }

    protected LogoutRequestType createLogoutRequest(String logoutUrl, AuthenticatedClientSessionModel clientSession, ClientModel client, SamlProtocolExtensionsAwareBuilder.NodeGenerator ... extensions) throws ConfigurationException {
        SAML2LogoutRequestBuilder logoutBuilder = new SAML2LogoutRequestBuilder().assertionExpiration(this.realm.getAccessCodeLifespan()).issuer(this.getResponseIssuer(this.realm)).userPrincipal(clientSession.getNote(SAML_NAME_ID), clientSession.getNote(SAML_NAME_ID_FORMAT)).destination(logoutUrl);
        String sessionIndex = SamlSessionUtils.getSessionIndex(clientSession);
        logoutBuilder.sessionIndex(sessionIndex);
        for (SamlProtocolExtensionsAwareBuilder.NodeGenerator extension : extensions) {
            logoutBuilder.addExtension(extension);
        }
        LogoutRequestType logoutRequest = logoutBuilder.createLogoutRequest();
        Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(this.session);
        while (it.hasNext()) {
            logoutRequest = it.next().beforeSendingLogoutRequest(logoutRequest, clientSession.getUserSession(), clientSession);
        }
        return logoutRequest;
    }

    public boolean requireReauthentication(UserSessionModel userSession, AuthenticationSessionModel authSession) {
        String requireReauthentication = authSession.getAuthNote(SAML_LOGIN_REQUEST_FORCEAUTHN);
        return Objects.equals("true", requireReauthentication);
    }

    private JaxrsSAML2BindingBuilder createBindingBuilder(SamlClient samlClient, boolean skipRealmSignature) {
        JaxrsSAML2BindingBuilder binding = new JaxrsSAML2BindingBuilder(this.session);
        if (!skipRealmSignature && samlClient.requiresRealmSignature()) {
            KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(this.realm);
            String keyName = samlClient.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signatureAlgorithm(samlClient.getSignatureAlgorithm())).signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signDocument();
        }
        return binding;
    }

    public void close() {
    }

    protected Response buildArtifactAuthenticatedResponse(AuthenticatedClientSessionModel clientSession, String redirectUri, SAML2Object samlDocument, JaxrsSAML2BindingBuilder bindingBuilder) throws ProcessingException, ConfigurationException {
        try {
            String artifact = this.buildArtifactAndStoreResponse(samlDocument, clientSession);
            String relayState = clientSession.getNote("RelayState");
            logger.debugf("Sending artifact %s to client %s", (Object)artifact, (Object)clientSession.getClient().getClientId());
            if (this.isPostBinding(clientSession)) {
                return this.artifactPost(redirectUri, artifact, relayState, bindingBuilder);
            }
            return this.artifactRedirect(redirectUri, artifact, relayState);
        }
        catch (ArtifactResolverProcessingException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    protected Response buildLogoutArtifactResponse(UserSessionModel userSession, String redirectUri, StatusResponseType statusResponseType, JaxrsSAML2BindingBuilder bindingBuilder) throws ProcessingException, ConfigurationException {
        try {
            String artifact = this.buildArtifactAndStoreResponse((SAML2Object)statusResponseType, userSession);
            String relayState = userSession.getNote(SAML_LOGOUT_RELAY_STATE);
            logger.debugf("Sending artifact for LogoutResponse %s to user %s", (Object)artifact, (Object)userSession.getLoginUsername());
            if (SamlProtocol.isLogoutPostBindingForInitiator(userSession)) {
                return this.artifactPost(redirectUri, artifact, relayState, bindingBuilder);
            }
            return this.artifactRedirect(redirectUri, artifact, relayState);
        }
        catch (ArtifactResolverProcessingException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    protected String buildArtifactAndStoreResponse(SAML2Object statusResponseType, UserSessionModel userSession) throws ArtifactResolverProcessingException, ConfigurationException, ProcessingException {
        String clientIdThatInitiatedLogout = userSession.getNote(SAML_LOGOUT_INITIATOR_CLIENT_ID);
        userSession.removeNote(SAML_LOGOUT_INITIATOR_CLIENT_ID);
        AuthenticatedClientSessionModel clientSessionModel = userSession.getAuthenticatedClientSessionByClient(clientIdThatInitiatedLogout);
        if (clientSessionModel == null) {
            throw new IllegalStateException("Initiator client id is unknown when artifact response is created");
        }
        return this.buildArtifactAndStoreResponse(statusResponseType, clientSessionModel);
    }

    protected String buildArtifactAndStoreResponse(SAML2Object saml2Object, AuthenticatedClientSessionModel clientSessionModel) throws ArtifactResolverProcessingException, ProcessingException, ConfigurationException {
        String entityId = RealmsResource.realmBaseUrl(this.uriInfo).build(new Object[]{this.realm.getName()}).toString();
        ArtifactResponseType artifactResponseType = SamlProtocolUtils.buildArtifactResponse(saml2Object, SAML2NameIDBuilder.value((String)this.getResponseIssuer(this.realm)).build());
        SAMLDataMarshaller marshaller = new SAMLDataMarshaller();
        String artifact = this.getArtifactResolver().buildArtifact(clientSessionModel, entityId, marshaller.serialize(artifactResponseType));
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put(USER_SESSION_ID, clientSessionModel.getUserSession().getId());
        notes.put(CLIENT_SESSION_ID, clientSessionModel.getClient().getId());
        this.getSingleUseStore().put(artifact, (long)this.realm.getAccessCodeLifespan(), notes);
        return artifact;
    }

    private Response artifactRedirect(String redirectUri, String artifact, String relayState) {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)redirectUri).replaceQuery(null).queryParam("SAMLart", new Object[]{artifact});
        if (relayState != null) {
            builder.queryParam("RelayState", new Object[]{relayState});
        }
        URI uri = builder.build(new Object[0]);
        return Response.status((int)302).location(uri).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
    }

    private Response artifactPost(String redirectUri, String artifact, String relayState, JaxrsSAML2BindingBuilder bindingBuilder) {
        HashMap<String, String> inputTypes = new HashMap<String, String>();
        inputTypes.put("SAMLart", artifact);
        if (relayState != null) {
            inputTypes.put("RelayState", relayState);
        }
        String str = bindingBuilder.buildHtmlForm(redirectUri, inputTypes);
        return Response.ok((Object)str, (MediaType)MediaType.TEXT_HTML_TYPE).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
    }

    public static class ProtocolMapperProcessor<T> {
        public final T mapper;
        public final ProtocolMapperModel model;

        public ProtocolMapperProcessor(T mapper, ProtocolMapperModel model) {
            this.mapper = mapper;
            this.model = model;
        }
    }
}

