/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.TokenCategory;
import org.keycloak.TokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.CekManagementProvider;
import org.keycloak.crypto.ContentEncryptionProvider;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.keys.loader.PublicKeyStorageManager;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.UserInfoRequestContext;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.util.MtlsHoKTokenUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;
import org.keycloak.utils.OAuth2Error;

public class UserInfoEndpoint {
    private final HttpRequest request;
    private final KeycloakSession session;
    private final ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final AppAuthManager appAuthManager;
    private final RealmModel realm;
    private final OAuth2Error error;
    private Cors cors;
    private String authorization;

    public UserInfoEndpoint(KeycloakSession session, TokenManager tokenManager) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realm = session.getContext().getRealm();
        this.tokenManager = tokenManager;
        this.appAuthManager = new AppAuthManager();
        this.error = new OAuth2Error().json(false).realm(this.realm);
        this.request = session.getContext().getHttpRequest();
    }

    @Path(value="/")
    @OPTIONS
    public Response issueUserInfoPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    @NoCache
    @Produces(value={"application/json", "application/jwt"})
    public Response issueUserInfoGet() {
        this.setupCors();
        String accessToken = AppAuthManager.extractAuthorizationHeaderTokenOrReturnNull(this.session.getContext().getRequestHeaders());
        this.authorization(accessToken);
        return this.issueUserInfo();
    }

    @Path(value="/")
    @POST
    @NoCache
    @Produces(value={"application/json", "application/jwt"})
    public Response issueUserInfoPost() {
        this.setupCors();
        HttpHeaders headers = this.request.getHttpHeaders();
        String accessToken = AppAuthManager.extractAuthorizationHeaderTokenOrReturnNull(headers);
        this.authorization(accessToken);
        try {
            String contentType = headers.getHeaderString("Content-Type");
            MediaType mediaType = MediaType.valueOf((String)contentType);
            if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(mediaType)) {
                MultivaluedMap formParams = this.request.getDecodedFormParameters();
                this.checkAccessTokenDuplicated((MultivaluedMap<String, String>)formParams);
                accessToken = (String)formParams.getFirst((Object)"access_token");
                this.authorization(accessToken);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.issueUserInfo();
    }

    private Response issueUserInfo() {
        Response.ResponseBuilder responseBuilder;
        AccessToken token;
        this.cors.allowAllOrigins();
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new UserInfoRequestContext(this.authorization));
        }
        catch (ClientPolicyException cpe) {
            throw this.error.error(cpe.getError()).errorDescription(cpe.getErrorDetail()).status(cpe.getErrorStatus()).build();
        }
        EventBuilder event = new EventBuilder(this.realm, this.session, this.clientConnection).event(EventType.USER_INFO_REQUEST).detail("auth_method", "validate_access_token");
        if (this.authorization == null) {
            event.error("invalid_token");
            throw this.error.unauthorized();
        }
        ClientModel clientModel = null;
        try {
            TokenVerifier verifier = TokenVerifier.create((String)this.authorization, AccessToken.class).withDefaultChecks().realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            token = (AccessToken)verifier.verify().getToken();
            if (!TokenUtil.hasScope((String)token.getScope(), (String)"openid")) {
                event.error("access_denied");
                throw this.error.insufficientScope("Missing openid scope");
            }
            clientModel = this.realm.getClientByClientId(token.getIssuedFor());
            if (clientModel == null) {
                event.error("client_not_found");
                throw this.error.invalidToken("Client not found");
            }
            this.cors.allowedOrigins(this.session, clientModel);
            TokenVerifier.createWithoutSignature((JsonWebToken)token).withChecks(new TokenVerifier.Predicate[]{TokenManager.NotBeforeCheck.forModel(clientModel), new TokenManager.TokenRevocationCheck(this.session)}).verify();
        }
        catch (VerificationException e) {
            if (clientModel == null) {
                this.cors.allowAllOrigins();
            }
            event.error("invalid_token");
            throw this.error.invalidToken("Token verification failed");
        }
        if (!clientModel.getProtocol().equals("openid-connect")) {
            event.error("invalid_client");
            throw this.error.invalidToken("Wrong client protocol");
        }
        this.session.getContext().setClient(clientModel);
        event.client(clientModel);
        if (!clientModel.isEnabled()) {
            event.error("client_disabled");
            throw this.error.invalidToken("Client disabled");
        }
        UserSessionModel userSession = this.findValidSession(token, event, clientModel);
        UserModel userModel = userSession.getUser();
        if (userModel == null) {
            event.error("user_not_found");
            throw this.error.invalidToken("User not found");
        }
        event.user(userModel).detail("username", userModel.getUsername());
        if (!userModel.isEnabled()) {
            event.error("user_disabled");
            throw this.error.invalidToken("User disabled");
        }
        if (OIDCAdvancedConfigWrapper.fromClientModel(clientModel).isUseMtlsHokToken() && !MtlsHoKTokenUtil.verifyTokenBindingWithClientCertificate(token, this.request, this.session)) {
            event.error("not_allowed");
            throw this.error.invalidToken("Client certificate missing, or its thumbprint and one in the refresh token did NOT match");
        }
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(clientModel.getId());
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionScopeParameter(clientSession, this.session);
        AccessToken userInfo = new AccessToken();
        userInfo = this.tokenManager.transformUserInfoAccessToken(this.session, userInfo, userSession, clientSessionCtx);
        Map<String, Object> claims = this.tokenManager.generateUserInfoClaims(userInfo, userModel);
        OIDCAdvancedConfigWrapper cfg = OIDCAdvancedConfigWrapper.fromClientModel(clientModel);
        if (cfg.isUserInfoSignatureRequired()) {
            String issuerUrl = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName());
            String audience = clientModel.getClientId();
            claims.put("iss", issuerUrl);
            claims.put("aud", audience);
            String signatureAlgorithm = this.session.tokens().signatureAlgorithm(TokenCategory.USERINFO);
            SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, signatureAlgorithm);
            SignatureSignerContext signer = signatureProvider.signer();
            String signedUserInfo = new JWSBuilder().type("JWT").jsonContent(claims).sign(signer);
            try {
                responseBuilder = Response.ok((Object)(cfg.isUserInfoEncryptionRequired() ? this.jweFromContent(signedUserInfo, "JWT") : signedUserInfo)).header("Content-Type", (Object)"application/jwt");
            }
            catch (RuntimeException re) {
                throw this.error.status(Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            event.detail("signature_required", "true");
            event.detail("signature_algorithm", cfg.getUserInfoSignedResponseAlg());
        } else if (cfg.isUserInfoEncryptionRequired()) {
            try {
                responseBuilder = Response.ok((Object)this.jweFromContent(JsonSerialization.writeValueAsString(claims), null)).header("Content-Type", (Object)"application/jwt");
            }
            catch (IOException | RuntimeException ex) {
                throw this.error.status(Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            event.detail("signature_required", "false");
        } else {
            responseBuilder = Response.ok(claims).header("Content-Type", (Object)"application/json");
            event.detail("signature_required", "false");
        }
        event.success();
        return this.cors.builder(responseBuilder).build();
    }

    private String jweFromContent(String content, String jweContentType) {
        String encryptedToken = null;
        String algAlgorithm = this.session.tokens().cekManagementAlgorithm(TokenCategory.USERINFO);
        String encAlgorithm = this.session.tokens().encryptAlgorithm(TokenCategory.USERINFO);
        CekManagementProvider cekManagementProvider = (CekManagementProvider)this.session.getProvider(CekManagementProvider.class, algAlgorithm);
        JWEAlgorithmProvider jweAlgorithmProvider = cekManagementProvider.jweAlgorithmProvider();
        ContentEncryptionProvider contentEncryptionProvider = (ContentEncryptionProvider)this.session.getProvider(ContentEncryptionProvider.class, encAlgorithm);
        JWEEncryptionProvider jweEncryptionProvider = contentEncryptionProvider.jweEncryptionProvider();
        ClientModel client = this.session.getContext().getClient();
        KeyWrapper keyWrapper = PublicKeyStorageManager.getClientPublicKeyWrapper(this.session, client, JWK.Use.ENCRYPTION, algAlgorithm);
        if (keyWrapper == null) {
            throw new RuntimeException("can not get encryption KEK");
        }
        Key encryptionKek = keyWrapper.getPublicKey();
        String encryptionKekId = keyWrapper.getKid();
        try {
            encryptedToken = TokenUtil.jweKeyEncryptionEncode((Key)encryptionKek, (byte[])content.getBytes("UTF-8"), (String)algAlgorithm, (String)encAlgorithm, (String)encryptionKekId, (JWEAlgorithmProvider)jweAlgorithmProvider, (JWEEncryptionProvider)jweEncryptionProvider, (String)jweContentType);
        }
        catch (UnsupportedEncodingException | JWEException e) {
            throw new RuntimeException(e);
        }
        return encryptedToken;
    }

    private UserSessionModel createTransientSessionForClient(AccessToken token, ClientModel client) {
        UserModel user = TokenManager.lookupUserFromStatelessToken(this.session, this.realm, token);
        if (user == null) {
            throw this.error.invalidToken("User not found");
        }
        UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(KeycloakModelUtils.generateId(), this.realm, user, user.getUsername(), this.clientConnection.getRemoteAddr(), "client_auth", false, null, null, UserSessionModel.SessionPersistenceState.TRANSIENT);
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(this.realm);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        authSession.setAuthenticatedUser(userSession.getUser());
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        AuthenticationManager.setClientScopesInSession(authSession);
        TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        return userSession;
    }

    private UserSessionModel findValidSession(AccessToken token, EventBuilder event, ClientModel client) {
        if (token.getSessionState() == null) {
            return this.createTransientSessionForClient(token, client);
        }
        UserSessionModel userSession = new UserSessionCrossDCManager(this.session).getUserSessionWithClient(this.realm, token.getSessionState(), false, client.getId());
        UserSessionModel offlineUserSession = null;
        if (AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.checkTokenIssuedAt(token, userSession, event, client);
            event.session(userSession);
            return userSession;
        }
        offlineUserSession = new UserSessionCrossDCManager(this.session).getUserSessionWithClient(this.realm, token.getSessionState(), true, client.getId());
        if (AuthenticationManager.isOfflineSessionValid(this.realm, offlineUserSession)) {
            this.checkTokenIssuedAt(token, offlineUserSession, event, client);
            event.session(offlineUserSession);
            return offlineUserSession;
        }
        if (userSession == null && offlineUserSession == null) {
            event.error("user_session_not_found");
            throw this.error.invalidToken("User session not found or doesn't have client attached on it");
        }
        if (userSession != null) {
            event.session(userSession);
        } else {
            event.session(offlineUserSession);
        }
        event.error("session_expired");
        throw this.error.invalidToken("Session expired");
    }

    private void checkTokenIssuedAt(AccessToken token, UserSessionModel userSession, EventBuilder event, ClientModel client) {
        if (token.isIssuedBeforeSessionStart((long)userSession.getStarted())) {
            event.error("invalid_token");
            throw this.error.invalidToken("Stale token");
        }
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (token.isIssuedBeforeSessionStart((long)clientSession.getStarted())) {
            event.error("invalid_token");
            throw this.error.invalidToken("Stale token");
        }
    }

    private void checkAccessTokenDuplicated(MultivaluedMap<String, String> formParams) {
        if (formParams.containsKey((Object)"access_token") && ((List)formParams.get((Object)"access_token")).size() != 1) {
            throw this.error.invalidRequest("Duplicate parameter");
        }
    }

    private void setupCors() {
        this.cors = Cors.add(this.request).auth().allowedMethods(this.request.getHttpMethod()).auth().exposedHeaders("Access-Control-Allow-Methods");
        this.error.cors(this.cors);
    }

    private void authorization(String accessToken) {
        if (accessToken != null) {
            if (this.authorization == null) {
                this.authorization = accessToken;
            } else {
                throw this.error.cors(this.cors.allowAllOrigins()).invalidRequest("More than one method used for including an access token");
            }
        }
    }
}

