/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.par.endpoints;

import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.resources.Cors;

public abstract class AbstractParEndpoint {
    protected final KeycloakSession session;
    protected final EventBuilder event;
    protected final RealmModel realm;
    protected Cors cors;
    protected ClientModel client;

    public AbstractParEndpoint(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
        this.realm = session.getContext().getRealm();
    }

    protected void checkSsl() {
        ClientConnection clientConnection = (ClientConnection)this.session.getContext().getContextObject(ClientConnection.class);
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    protected void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    protected void authorizeClient() {
        try {
            AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors);
            this.client = clientAuth.getClient();
            this.event.client(this.client);
            this.cors.allowedOrigins(this.session, this.client);
            if (this.client == null || this.client.isPublicClient()) {
                throw this.throwErrorResponseException("invalid_request", "Client not allowed.", Response.Status.FORBIDDEN);
            }
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Authentication failed.", Response.Status.UNAUTHORIZED);
        }
    }

    protected byte[] getHash(String inputData) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("SHA-256").digest(inputData.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Error calculating hash");
        }
        return hash;
    }

    protected CorsErrorResponseException throwErrorResponseException(String error, String detail, Response.Status status) {
        this.event.detail("detail", detail).error(error);
        return new CorsErrorResponseException(this.cors, error, detail, status);
    }
}

