/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import io.smallrye.common.annotation.NonBlocking;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.health.LoadBalancerCheckProvider;
import org.keycloak.models.KeycloakSession;

@Path(value="/lb-check")
@NonBlocking
public class LoadBalancerResource {
    protected static final Logger logger = Logger.getLogger(LoadBalancerResource.class);
    @Context
    KeycloakSession session;

    @GET
    @Produces(value={"text/plain; charset=utf-8"})
    public Response getStatusForLoadBalancer() {
        Set healthStatusProviders = this.session.getAllProviders(LoadBalancerCheckProvider.class);
        if (healthStatusProviders.stream().anyMatch(LoadBalancerCheckProvider::isDown)) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"DOWN").build();
        }
        return Response.ok().entity((Object)"UP").build();
    }
}

