/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPAttributePermissions;
import org.keycloak.representations.userprofile.config.UPAttributeRequired;
import org.keycloak.representations.userprofile.config.UPAttributeSelector;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.userprofile.config.UPGroup;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.AbstractUserProfileProvider;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.DefaultAttributes;
import org.keycloak.userprofile.LegacyAttributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.config.DeclarativeUserProfileModel;
import org.keycloak.userprofile.config.UPConfigUtils;
import org.keycloak.userprofile.validator.BlankAttributeValidator;
import org.keycloak.validate.ValidatorConfig;

public class DeclarativeUserProfileProvider
extends AbstractUserProfileProvider<UserProfileProvider>
implements AmphibianProviderFactory<UserProfileProvider> {
    public static final String ID = "declarative-user-profile";
    public static final int PROVIDER_PRIORITY = 1;
    public static final String UP_COMPONENT_CONFIG_KEY = "kc.user.profile.config";
    public static final String REALM_USER_PROFILE_ENABLED = "userProfileEnabled";
    private static final String PARSED_CONFIG_COMPONENT_KEY = "kc.user.profile.metadata";
    private static boolean isDeclarativeConfigurationEnabled;
    protected String defaultRawConfig;
    protected UPConfig parsedDefaultRawConfig;

    private static boolean requestedScopePredicate(AttributeContext context, Set<String> configuredScopes) {
        KeycloakSession session = context.getSession();
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        if (authenticationSession == null) {
            return false;
        }
        String requestedScopesString = authenticationSession.getClientNote("scope");
        ClientModel client = authenticationSession.getClient();
        return TokenManager.getRequestedClientScopes(requestedScopesString, client).map(csm -> csm.getName()).anyMatch(configuredScopes::contains);
    }

    public DeclarativeUserProfileProvider() {
    }

    public DeclarativeUserProfileProvider(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> metadataRegistry, String defaultRawConfig, UPConfig parsedDefaultRawConfig) {
        super(session, metadataRegistry);
        this.defaultRawConfig = defaultRawConfig;
        this.parsedDefaultRawConfig = parsedDefaultRawConfig;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected UserProfileProvider create(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> metadataRegistry) {
        return new DeclarativeUserProfileProvider(session, metadataRegistry, this.defaultRawConfig, this.parsedDefaultRawConfig);
    }

    @Override
    protected Attributes createAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata metadata) {
        RealmModel realm = this.session.getContext().getRealm();
        if (this.isEnabled(realm)) {
            if (user != null && user.getServiceAccountClientLink() != null) {
                return new LegacyAttributes(context, attributes, user, metadata, this.session);
            }
            return new DefaultAttributes(context, attributes, user, metadata, this.session);
        }
        return new LegacyAttributes(context, attributes, user, metadata, this.session);
    }

    @Override
    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata) {
        if (isDeclarativeConfigurationEnabled) {
            return this.decorateUserProfileForCache(metadata, this.parsedDefaultRawConfig);
        }
        return metadata;
    }

    @Override
    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata, KeycloakSession session) {
        UserProfileContext context = metadata.getContext();
        UserProfileMetadata decoratedMetadata = metadata.clone();
        RealmModel realm = session.getContext().getRealm();
        if (!this.isEnabled(realm)) {
            if (!context.equals((Object)UserProfileContext.USER_API) && !context.equals((Object)UserProfileContext.UPDATE_EMAIL)) {
                decoratedMetadata.addAttribute("firstName", 1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingFirstNameMessage", metadata.getContext() == UserProfileContext.IDP_REVIEW))}).setAttributeDisplayName("${firstName}");
                decoratedMetadata.addAttribute("lastName", 2, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingLastNameMessage", metadata.getContext() == UserProfileContext.IDP_REVIEW))}).setAttributeDisplayName("${lastName}");
            }
            return decoratedMetadata;
        }
        ComponentModel component = this.getComponentModel().orElse(null);
        if (component == null) {
            return decoratedMetadata;
        }
        ConcurrentHashMap<UserProfileContext, UserProfileMetadata> metadataMap = (ConcurrentHashMap<UserProfileContext, UserProfileMetadata>)component.getNote(PARSED_CONFIG_COMPONENT_KEY);
        if (metadataMap == null) {
            metadataMap = new ConcurrentHashMap<UserProfileContext, UserProfileMetadata>();
            component.setNote(PARSED_CONFIG_COMPONENT_KEY, metadataMap);
        }
        return metadataMap.computeIfAbsent(context, this.createUserDefinedProfileDecorator(session, decoratedMetadata, component));
    }

    public String getHelpText() {
        return null;
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        String upConfigJson = this.getConfigJsonFromComponentModel(model);
        if (!ObjectUtil.isBlank((CharSequence)upConfigJson)) {
            try {
                UPConfig upc = this.parseConfig(upConfigJson);
                List<String> errors = UPConfigUtils.validate(session, upc);
                if (!errors.isEmpty()) {
                    throw new ComponentValidationException(errors.toString(), new Object[0]);
                }
            }
            catch (IOException e) {
                throw new ComponentValidationException(e.getMessage(), (Throwable)e);
            }
        }
        if (model != null) {
            model.removeNote(PARSED_CONFIG_COMPONENT_KEY);
        }
    }

    @Override
    public UPConfig getConfiguration() {
        RealmModel realm = this.session.getContext().getRealm();
        if (!this.isEnabled(realm)) {
            return this.getParsedConfig(this.defaultRawConfig);
        }
        Optional<ComponentModel> component = this.getComponentModel();
        if (component.isPresent()) {
            String cfg = this.getConfigJsonFromComponentModel(component.get());
            if (ObjectUtil.isBlank((CharSequence)cfg)) {
                return this.getParsedConfig(this.defaultRawConfig);
            }
            return this.getParsedConfig(cfg);
        }
        return this.getParsedConfig(this.defaultRawConfig);
    }

    @Override
    public void setConfiguration(String configuration) {
        RealmModel realm = this.session.getContext().getRealm();
        Optional optionalComponent = realm.getComponentsStream(realm.getId(), UserProfileProvider.class.getName()).findAny();
        if (!optionalComponent.isPresent() && ObjectUtil.isBlank((CharSequence)configuration)) {
            return;
        }
        ComponentModel component = optionalComponent.isPresent() ? (ComponentModel)optionalComponent.get() : this.createComponentModel();
        this.removeConfigJsonFromComponentModel(component);
        if (ObjectUtil.isBlank((CharSequence)configuration)) {
            realm.removeComponent(component);
            return;
        }
        component.getConfig().putSingle((Object)UP_COMPONENT_CONFIG_KEY, (Object)configuration);
        realm.updateComponent(component);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name(UP_COMPONENT_CONFIG_KEY).type("String").add().build();
    }

    @Override
    public void init(Config.Scope config) {
        isDeclarativeConfigurationEnabled = Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DECLARATIVE_USER_PROFILE);
        this.defaultRawConfig = UPConfigUtils.readDefaultConfig();
        try {
            this.parsedDefaultRawConfig = this.parseConfig(this.defaultRawConfig);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to parse default user profile configuration", cause);
        }
        super.init(config);
    }

    public int order() {
        return 1;
    }

    private Optional<ComponentModel> getComponentModel() {
        RealmModel realm = this.session.getContext().getRealm();
        return realm.getComponentsStream(realm.getId(), UserProfileProvider.class.getName()).findAny();
    }

    protected UserProfileMetadata decorateUserProfileForCache(UserProfileMetadata decoratedMetadata, UPConfig parsedConfig) {
        UserProfileContext context = decoratedMetadata.getContext();
        if (parsedConfig == null || context == UserProfileContext.UPDATE_EMAIL) {
            return decoratedMetadata;
        }
        Map<String, UPGroup> groupsByName = this.asHashMap(parsedConfig.getGroups());
        int guiOrder = 0;
        for (UPAttribute attrConfig : parsedConfig.getAttributes()) {
            UPAttributeRequired rc;
            String attributeName = attrConfig.getName();
            ArrayList<AttributeValidatorMetadata> validators = new ArrayList<AttributeValidatorMetadata>();
            Map validationsConfig = attrConfig.getValidations();
            if (validationsConfig != null) {
                for (Map.Entry vc : validationsConfig.entrySet()) {
                    validators.add(this.createConfiguredValidator((String)vc.getKey(), (Map)vc.getValue()));
                }
            }
            if ((rc = attrConfig.getRequired()) != null) {
                validators.add(new AttributeValidatorMetadata("up-attribute-required-by-metadata-value"));
            }
            Predicate<Object> required = AttributeMetadata.ALWAYS_FALSE;
            if (rc != null) {
                if (rc.isAlways() || UPConfigUtils.isRoleForContext(context, rc.getRoles())) {
                    required = AttributeMetadata.ALWAYS_TRUE;
                    if (rc.getScopes() != null && !rc.getScopes().isEmpty()) {
                        required = UPConfigUtils.canBeAuthFlowContext(context) ? c -> DeclarativeUserProfileProvider.requestedScopePredicate(c, rc.getScopes()) : AttributeMetadata.ALWAYS_FALSE;
                    }
                } else if (UPConfigUtils.canBeAuthFlowContext(context) && rc.getScopes() != null && !rc.getScopes().isEmpty()) {
                    required = c -> DeclarativeUserProfileProvider.requestedScopePredicate(c, rc.getScopes());
                }
            }
            Predicate<Object> writeAllowed = AttributeMetadata.ALWAYS_FALSE;
            Predicate<Object> readAllowed = AttributeMetadata.ALWAYS_FALSE;
            UPAttributePermissions permissions = attrConfig.getPermissions();
            if (permissions != null) {
                Set viewRoles;
                Set editRoles = permissions.getEdit();
                if (!editRoles.isEmpty()) {
                    writeAllowed = ac -> UPConfigUtils.isRoleForContext(ac.getContext(), editRoles);
                }
                readAllowed = (viewRoles = permissions.getView()).isEmpty() ? writeAllowed : this.createViewAllowedPredicate(writeAllowed, viewRoles);
            }
            Predicate<AttributeContext> selector = AttributeMetadata.ALWAYS_TRUE;
            UPAttributeSelector sc = attrConfig.getSelector();
            if (sc != null && !this.isBuiltInAttribute(attributeName) && UPConfigUtils.canBeAuthFlowContext(context) && sc.getScopes() != null && !sc.getScopes().isEmpty()) {
                selector = c -> DeclarativeUserProfileProvider.requestedScopePredicate(c, sc.getScopes());
            }
            Map annotations = attrConfig.getAnnotations();
            String attributeGroup = attrConfig.getGroup();
            AttributeGroupMetadata groupMetadata = this.toAttributeGroupMeta(groupsByName.get(attributeGroup));
            ++guiOrder;
            validators.add(new AttributeValidatorMetadata("up-immutable-attribute"));
            if (this.isBuiltInAttribute(attributeName)) {
                List existingMetadata;
                if (permissions == null || permissions.isEmpty()) {
                    writeAllowed = AttributeMetadata.ALWAYS_TRUE;
                    readAllowed = AttributeMetadata.ALWAYS_TRUE;
                }
                if ("username".equals(attributeName)) {
                    required = new Predicate<AttributeContext>(){

                        @Override
                        public boolean test(AttributeContext context) {
                            RealmModel realm = context.getSession().getContext().getRealm();
                            return !realm.isRegistrationEmailAsUsername();
                        }
                    };
                }
                if ("email".equals(attributeName) && UserProfileContext.USER_API.equals((Object)context)) {
                    required = new Predicate<AttributeContext>(){

                        @Override
                        public boolean test(AttributeContext context) {
                            UserModel user = context.getUser();
                            if (user != null && user.getServiceAccountClientLink() != null) {
                                return false;
                            }
                            RealmModel realm = context.getSession().getContext().getRealm();
                            return realm.isRegistrationEmailAsUsername();
                        }
                    };
                }
                if ((existingMetadata = decoratedMetadata.getAttribute(attributeName)).isEmpty()) {
                    throw new IllegalStateException("Attribute " + attributeName + " not defined in the context.");
                }
                for (AttributeMetadata metadata : existingMetadata) {
                    metadata.addAnnotations(annotations).setAttributeDisplayName(attrConfig.getDisplayName()).setGuiOrder(guiOrder).setAttributeGroupMetadata(groupMetadata).addReadCondition((Predicate)readAllowed).addWriteCondition((Predicate)writeAllowed).addValidators(validators).setRequired((Predicate)required);
                }
                continue;
            }
            decoratedMetadata.addAttribute(attributeName, guiOrder, validators, selector, (Predicate)writeAllowed, required, (Predicate)readAllowed).addAnnotations(annotations).setAttributeDisplayName(attrConfig.getDisplayName()).setAttributeGroupMetadata(groupMetadata);
        }
        return decoratedMetadata;
    }

    private Map<String, UPGroup> asHashMap(List<UPGroup> groups) {
        return groups.stream().collect(Collectors.toMap(g -> g.getName(), g -> g));
    }

    private AttributeGroupMetadata toAttributeGroupMeta(UPGroup group) {
        if (group == null) {
            return null;
        }
        return new AttributeGroupMetadata(group.getName(), group.getDisplayHeader(), group.getDisplayDescription(), group.getAnnotations());
    }

    private boolean isBuiltInAttribute(String attributeName) {
        return "username".equals(attributeName) || "email".equals(attributeName);
    }

    private boolean isOptionalBuiltInAttribute(String attributeName) {
        return "firstName".equals(attributeName) || "lastName".equals(attributeName);
    }

    private Predicate<AttributeContext> createViewAllowedPredicate(Predicate<AttributeContext> canEdit, Set<String> viewRoles) {
        return ac -> UPConfigUtils.isRoleForContext(ac.getContext(), viewRoles) || canEdit.test((AttributeContext)ac);
    }

    protected UPConfig getParsedConfig(String rawConfig) {
        if (!ObjectUtil.isBlank((CharSequence)rawConfig)) {
            try {
                return this.parseConfig(rawConfig);
            }
            catch (IOException e) {
                throw new RuntimeException("UserProfile configuration for realm '" + this.session.getContext().getRealm().getName() + "' is invalid:" + e.getMessage(), e);
            }
        }
        return null;
    }

    private UPConfig parseConfig(String rawConfig) throws IOException {
        return UPConfigUtils.readConfig(new ByteArrayInputStream(rawConfig.getBytes("UTF-8")));
    }

    protected ComponentModel createComponentModel() {
        RealmModel realm = this.session.getContext().getRealm();
        return realm.addComponentModel((ComponentModel)new DeclarativeUserProfileModel(this.getId()));
    }

    protected AttributeValidatorMetadata createConfiguredValidator(String validator, Map<String, Object> validatorConfig) {
        return new AttributeValidatorMetadata(validator, ValidatorConfig.builder().config(validatorConfig).config("ignore.empty.value", (Object)true).build());
    }

    private String getConfigJsonFromComponentModel(ComponentModel model) {
        if (model == null) {
            return null;
        }
        return model.get(UP_COMPONENT_CONFIG_KEY);
    }

    private void removeConfigJsonFromComponentModel(ComponentModel model) {
        if (model == null) {
            return;
        }
        model.getConfig().remove((Object)UP_COMPONENT_CONFIG_KEY);
    }

    public boolean isEnabled(RealmModel realm) {
        return isDeclarativeConfigurationEnabled && realm.getAttribute(REALM_USER_PROFILE_ENABLED, Boolean.valueOf(false)) != false;
    }

    private Function<UserProfileContext, UserProfileMetadata> createUserDefinedProfileDecorator(KeycloakSession session, UserProfileMetadata decoratedMetadata, ComponentModel component) {
        return c -> {
            UPConfig parsedConfig = this.getParsedConfig(this.getConfigJsonFromComponentModel(component));
            List<String> errors = UPConfigUtils.validate(session, parsedConfig);
            if (!errors.isEmpty()) {
                throw new RuntimeException("UserProfile configuration for realm '" + session.getContext().getRealm().getName() + "' is invalid: " + errors.toString());
            }
            Iterator attributes = decoratedMetadata.getAttributes().iterator();
            while (attributes.hasNext()) {
                AttributeMetadata metadata = (AttributeMetadata)attributes.next();
                String attributeName = metadata.getName();
                if (this.isBuiltInAttribute(attributeName)) {
                    UPAttribute upAttribute = this.parsedDefaultRawConfig.getAttribute(attributeName);
                    Map validations = Optional.ofNullable(upAttribute.getValidations()).orElse(Collections.emptyMap());
                    for (String id : validations.keySet()) {
                        List validators = metadata.getValidators();
                        validators.removeIf(m -> m.getValidatorId().equals(id));
                    }
                    continue;
                }
                if (!this.isOptionalBuiltInAttribute(attributeName)) continue;
                attributes.remove();
            }
            return this.decorateUserProfileForCache(decoratedMetadata, parsedConfig);
        };
    }
}

