/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.keycloak.Config;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.saml.SAMLIdentityProvider;
import org.keycloak.broker.saml.SAMLIdentityProviderConfig;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.saml.v2.util.SAMLMetadataUtil;
import org.keycloak.saml.validators.DestinationValidator;
import org.w3c.dom.Element;

public class SAMLIdentityProviderFactory
extends AbstractIdentityProviderFactory<SAMLIdentityProvider> {
    public static final String PROVIDER_ID = "saml";
    private static final String MACEDIR_ENTITY_CATEGORY = "http://macedir.org/entity-category";
    private static final String REFEDS_HIDE_FROM_DISCOVERY = "http://refeds.org/category/hide-from-discovery";
    private DestinationValidator destinationValidator;

    public String getName() {
        return "SAML v2.0";
    }

    public SAMLIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new SAMLIdentityProvider(session, new SAMLIdentityProviderConfig(model), this.destinationValidator);
    }

    public SAMLIdentityProviderConfig createConfig() {
        return new SAMLIdentityProviderConfig();
    }

    public Map<String, String> parseConfig(KeycloakSession session, InputStream inputStream) {
        try {
            EntityDescriptorType entityType = SAMLMetadataUtil.parseEntityDescriptorType((InputStream)inputStream);
            IDPSSODescriptorType idpDescriptor = SAMLMetadataUtil.locateIDPSSODescriptorType((EntityDescriptorType)entityType);
            if (idpDescriptor != null) {
                SAMLIdentityProviderConfig samlIdentityProviderConfig = new SAMLIdentityProviderConfig();
                String singleSignOnServiceUrl = null;
                boolean postBindingResponse = false;
                boolean postBindingLogout = false;
                for (Object endpoint : idpDescriptor.getSingleSignOnService()) {
                    if (endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) {
                        singleSignOnServiceUrl = endpoint.getLocation().toString();
                        postBindingResponse = true;
                        break;
                    }
                    if (!endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) continue;
                    singleSignOnServiceUrl = endpoint.getLocation().toString();
                }
                String singleLogoutServiceUrl = null;
                for (EndpointType endpoint : idpDescriptor.getSingleLogoutService()) {
                    if (postBindingResponse && endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) {
                        singleLogoutServiceUrl = endpoint.getLocation().toString();
                        postBindingLogout = true;
                        break;
                    }
                    if (postBindingResponse || !endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) continue;
                    singleLogoutServiceUrl = endpoint.getLocation().toString();
                    break;
                }
                samlIdentityProviderConfig.setIdpEntityId(entityType.getEntityID());
                samlIdentityProviderConfig.setSingleLogoutServiceUrl(singleLogoutServiceUrl);
                samlIdentityProviderConfig.setSingleSignOnServiceUrl(singleSignOnServiceUrl);
                samlIdentityProviderConfig.setWantAuthnRequestsSigned(idpDescriptor.isWantAuthnRequestsSigned());
                samlIdentityProviderConfig.setAddExtensionsElementWithKeyInfo(false);
                samlIdentityProviderConfig.setValidateSignature(idpDescriptor.isWantAuthnRequestsSigned());
                samlIdentityProviderConfig.setPostBindingResponse(postBindingResponse);
                samlIdentityProviderConfig.setPostBindingAuthnRequest(postBindingResponse);
                samlIdentityProviderConfig.setPostBindingLogout(postBindingLogout);
                samlIdentityProviderConfig.setLoginHint(false);
                List nameIdFormatList = idpDescriptor.getNameIDFormat();
                if (nameIdFormatList != null && !nameIdFormatList.isEmpty()) {
                    samlIdentityProviderConfig.setNameIDPolicyFormat((String)nameIdFormatList.get(0));
                }
                List keyDescriptor = idpDescriptor.getKeyDescriptor();
                String defaultCertificate = null;
                if (keyDescriptor != null) {
                    for (KeyDescriptorType keyDescriptorType : keyDescriptor) {
                        Element keyInfo = keyDescriptorType.getKeyInfo();
                        Element x509KeyInfo = DocumentUtil.getChildElement((Element)keyInfo, (QName)new QName("dsig", "X509Certificate"));
                        if (KeyTypes.SIGNING.equals((Object)keyDescriptorType.getUse())) {
                            samlIdentityProviderConfig.addSigningCertificate(x509KeyInfo.getTextContent());
                            continue;
                        }
                        if (KeyTypes.ENCRYPTION.equals((Object)keyDescriptorType.getUse())) {
                            samlIdentityProviderConfig.setEncryptionPublicKey(x509KeyInfo.getTextContent());
                            continue;
                        }
                        if (keyDescriptorType.getUse() != null) continue;
                        defaultCertificate = x509KeyInfo.getTextContent();
                    }
                }
                if (defaultCertificate != null) {
                    if (samlIdentityProviderConfig.getSigningCertificates().length == 0) {
                        samlIdentityProviderConfig.addSigningCertificate(defaultCertificate);
                    }
                    if (samlIdentityProviderConfig.getEncryptionPublicKey() == null) {
                        samlIdentityProviderConfig.setEncryptionPublicKey(defaultCertificate);
                    }
                }
                samlIdentityProviderConfig.setEnabledFromMetadata(entityType.getValidUntil() == null || entityType.getValidUntil().toGregorianCalendar().getTime().after(new Date(System.currentTimeMillis())));
                if (entityType.getExtensions() != null && entityType.getExtensions().getEntityAttributes() != null) {
                    for (AttributeType attribute : entityType.getExtensions().getEntityAttributes().getAttribute()) {
                        if (!MACEDIR_ENTITY_CATEGORY.equals(attribute.getName()) || !attribute.getAttributeValue().contains(REFEDS_HIDE_FROM_DISCOVERY)) continue;
                        samlIdentityProviderConfig.setHideOnLogin(true);
                    }
                }
                return samlIdentityProviderConfig.getConfig();
            }
        }
        catch (ParsingException pe) {
            throw new RuntimeException("Could not parse IdP SAML Metadata", pe);
        }
        return new HashMap<String, String>();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        super.init(config);
        this.destinationValidator = DestinationValidator.forProtocolMap((String[])config.getArray("knownProtocols"));
    }
}

