/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ServiceAccountTokenRequestContext;
import org.keycloak.services.clientpolicy.context.ServiceAccountTokenResponseContext;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class ClientCredentialsGrantType
extends OAuth2GrantTypeBase {
    private static final Logger logger = Logger.getLogger(ClientCredentialsGrantType.class);

    public Response process(OAuth2GrantType.Context context) {
        this.setContext(context);
        if (this.client.isBearerOnly()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Bearer-only client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (this.client.isPublicClient()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Public client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (!this.client.isServiceAccountsEnabled()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Client not enabled to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        UserModel clientUser = this.session.users().getServiceAccount(this.client);
        if (clientUser == null || this.client.getProtocolMapperByName("openid-connect", "Client ID") == null) {
            logger.debugf("Service account user for client '%s' not found or default protocol mapper for service account not found. Creating now", (Object)this.client.getClientId());
            new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
            clientUser = this.session.users().getServiceAccount(this.client);
        }
        String clientUsername = clientUser.getUsername();
        this.event.detail("username", clientUsername);
        this.event.user(clientUser);
        if (!clientUser.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "User '" + clientUsername + "' disabled", Response.Status.UNAUTHORIZED);
        }
        String scope = this.getRequestedScopes();
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setAuthenticatedUser(clientUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        UserSessionModel.SessionPersistenceState sessionPersistenceState = UserSessionModel.SessionPersistenceState.PERSISTENT;
        boolean useRefreshToken = this.clientConfig.isUseRefreshTokenForClientCredentialsGrant();
        if (!useRefreshToken) {
            sessionPersistenceState = UserSessionModel.SessionPersistenceState.TRANSIENT;
        }
        UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(authSession.getParentSession().getId(), this.realm, clientUser, clientUsername, this.clientConnection.getRemoteAddr(), "client_auth", false, null, null, sessionPersistenceState);
        this.event.session(userSession);
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("client_id", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteAddr());
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new ServiceAccountTokenRequestContext((MultivaluedMap<String, String>)this.formParams, clientSessionCtx.getClientSession()));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).generateAccessToken();
        if (useRefreshToken) {
            responseBuilder = responseBuilder.generateRefreshToken();
        } else {
            responseBuilder.getAccessToken().setSessionState(null);
        }
        this.checkAndBindMtlsHoKToken(responseBuilder, useRefreshToken);
        String scopeParam = clientSessionCtx.getClientSession().getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new ServiceAccountTokenResponseContext((MultivaluedMap<String, String>)this.formParams, clientSessionCtx.getClientSession(), responseBuilder));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        AccessTokenResponse res = null;
        try {
            res = responseBuilder.build();
        }
        catch (RuntimeException re) {
            if ("can not get encryption KEK".equals(re.getMessage())) {
                throw new CorsErrorResponseException(this.cors, "invalid_request", "can not get encryption KEK", Response.Status.BAD_REQUEST);
            }
            throw re;
        }
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    public EventType getEventType() {
        return EventType.CLIENT_LOGIN;
    }
}

