/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.util.Base64Url;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.account.AccountLinkUriRepresentation;
import org.keycloak.representations.account.LinkedAccountRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.Urls;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.validation.Validation;

public class LinkedAccountsResource {
    private static final Logger logger = Logger.getLogger(LinkedAccountsResource.class);
    private final KeycloakSession session;
    private final HttpRequest request;
    private final EventBuilder event;
    private final UserModel user;
    private final RealmModel realm;
    private final Auth auth;

    public LinkedAccountsResource(KeycloakSession session, HttpRequest request, Auth auth, EventBuilder event, UserModel user) {
        this.session = session;
        this.request = request;
        this.auth = auth;
        this.event = event;
        this.user = user;
        this.realm = session.getContext().getRealm();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response linkedAccounts() {
        this.auth.requireOneOf("manage-account", "view-profile");
        SortedSet<LinkedAccountRepresentation> linkedAccounts = this.getLinkedAccounts(this.session, this.realm, this.user);
        return Cors.add((HttpRequest)this.request, (Response.ResponseBuilder)Response.ok(linkedAccounts)).auth().allowedOrigins(this.auth.getToken()).build();
    }

    private Set<String> findSocialIds() {
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class).map(ProviderFactory::getId).collect(Collectors.toSet());
    }

    public SortedSet<LinkedAccountRepresentation> getLinkedAccounts(KeycloakSession session, RealmModel realm, UserModel user) {
        Set<String> socialIds = this.findSocialIds();
        return realm.getIdentityProvidersStream().filter(IdentityProviderModel::isEnabled).map(provider -> this.toLinkedAccountRepresentation((IdentityProviderModel)provider, socialIds, session.users().getFederatedIdentitiesStream(realm, user))).collect(Collectors.toCollection(TreeSet::new));
    }

    private LinkedAccountRepresentation toLinkedAccountRepresentation(IdentityProviderModel provider, Set<String> socialIds, Stream<FederatedIdentityModel> identities) {
        String providerAlias = provider.getAlias();
        FederatedIdentityModel identity = this.getIdentity(identities, providerAlias);
        String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)this.session, (IdentityProviderModel)provider);
        String guiOrder = provider.getConfig() != null ? (String)provider.getConfig().get("guiOrder") : null;
        LinkedAccountRepresentation rep = new LinkedAccountRepresentation();
        rep.setConnected(identity != null);
        rep.setSocial(socialIds.contains(provider.getProviderId()));
        rep.setProviderAlias(providerAlias);
        rep.setDisplayName(displayName);
        rep.setGuiOrder(guiOrder);
        rep.setProviderName(provider.getAlias());
        if (identity != null) {
            rep.setLinkedUsername(identity.getUserName());
        }
        return rep;
    }

    private FederatedIdentityModel getIdentity(Stream<FederatedIdentityModel> identities, String providerAlias) {
        return identities.filter(model -> Objects.equals(model.getIdentityProvider(), providerAlias)).findFirst().orElse(null);
    }

    @GET
    @Path(value="/{providerAlias}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response buildLinkedAccountURI(@PathParam(value="providerAlias") String providerAlias, @QueryParam(value="redirectUri") String redirectUri) {
        String errorMessage;
        this.auth.require("manage-account");
        if (redirectUri == null) {
            ErrorResponse.error("invalidRedirectUriMessage", Response.Status.BAD_REQUEST);
        }
        if ((errorMessage = this.checkCommonPreconditions(providerAlias)) != null) {
            throw ErrorResponse.error(errorMessage, Response.Status.BAD_REQUEST);
        }
        if (this.auth.getSession() == null) {
            throw ErrorResponse.error("sessionNotActiveMessage", Response.Status.BAD_REQUEST);
        }
        try {
            String nonce = UUID.randomUUID().toString();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String input = nonce + this.auth.getSession().getId() + "account-console" + providerAlias;
            byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
            String hash = Base64Url.encode((byte[])check);
            URI linkUri = Urls.identityProviderLinkRequest(this.session.getContext().getUri().getBaseUri(), providerAlias, this.realm.getName());
            linkUri = UriBuilder.fromUri((URI)linkUri).queryParam("nonce", new Object[]{nonce}).queryParam("hash", new Object[]{hash}).queryParam("client_id", new Object[]{"account-console"}).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]);
            AccountLinkUriRepresentation rep = new AccountLinkUriRepresentation();
            rep.setAccountLinkUri(linkUri);
            rep.setHash(hash);
            rep.setNonce(nonce);
            return Cors.add((HttpRequest)this.request, (Response.ResponseBuilder)Response.ok((Object)rep)).auth().allowedOrigins(this.auth.getToken()).build();
        }
        catch (Exception spe) {
            spe.printStackTrace();
            throw ErrorResponse.error("failedToProcessResponseMessage", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="/{providerAlias}")
    @Produces(value={"application/json"})
    public Response removeLinkedAccount(@PathParam(value="providerAlias") String providerAlias) {
        this.auth.require("manage-account");
        String errorMessage = this.checkCommonPreconditions(providerAlias);
        if (errorMessage != null) {
            throw ErrorResponse.error(errorMessage, Response.Status.BAD_REQUEST);
        }
        FederatedIdentityModel link = this.session.users().getFederatedIdentity(this.realm, this.user, providerAlias);
        if (link == null) {
            throw ErrorResponse.error("federatedIdentityLinkNotActiveMessage", Response.Status.BAD_REQUEST);
        }
        if (this.session.users().getFederatedIdentitiesStream(this.realm, this.user).count() <= 1L && this.user.getFederationLink() == null && !this.isPasswordSet()) {
            throw ErrorResponse.error("federatedIdentityRemovingLastProviderMessage", Response.Status.BAD_REQUEST);
        }
        this.session.users().removeFederatedIdentity(this.realm, this.user, providerAlias);
        logger.debugv("Social provider {0} removed successfully from user {1}", (Object)providerAlias, (Object)this.user.getUsername());
        this.event.event(EventType.REMOVE_FEDERATED_IDENTITY).client(this.auth.getClient()).user(this.auth.getUser()).detail("username", this.auth.getUser().getUsername()).detail("identity_provider", link.getIdentityProvider()).detail("identity_provider_identity", link.getUserName()).success();
        return Cors.add((HttpRequest)this.request, (Response.ResponseBuilder)Response.noContent()).auth().allowedOrigins(this.auth.getToken()).build();
    }

    private String checkCommonPreconditions(String providerAlias) {
        this.auth.require("manage-account");
        if (Validation.isEmpty(providerAlias)) {
            return "missingIdentityProviderMessage";
        }
        if (!this.isValidProvider(providerAlias)) {
            return "identityProviderNotFoundMessage";
        }
        if (!this.user.isEnabled()) {
            return "accountDisabledMessage";
        }
        return null;
    }

    private boolean isPasswordSet() {
        return this.user.credentialManager().isConfiguredFor("password");
    }

    private boolean isValidProvider(String providerAlias) {
        return this.realm.getIdentityProvidersStream().anyMatch(model -> Objects.equals(model.getAlias(), providerAlias));
    }
}

