/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.impl;

import com.fasterxml.jackson.databind.JavaType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTypeRepresentation;
import org.keycloak.util.JsonSerialization;

public class DefaultClientType
implements ClientType {
    private static final Logger logger = Logger.getLogger(DefaultClientType.class);
    private static final String REFERENCE_PREFIX = "ref::";
    private final KeycloakSession session;
    private final ClientTypeRepresentation clientType;
    private final Map<String, PropertyDescriptor> clientRepresentationProperties;

    public DefaultClientType(KeycloakSession session, ClientTypeRepresentation clientType, Map<String, PropertyDescriptor> clientRepresentationProperties) {
        this.session = session;
        this.clientType = clientType;
        this.clientRepresentationProperties = clientRepresentationProperties;
    }

    public String getName() {
        return this.clientType.getName();
    }

    public boolean isApplicable(String optionName) {
        ClientTypeRepresentation.PropertyConfig cfg = (ClientTypeRepresentation.PropertyConfig)this.clientType.getConfig().get(optionName);
        return cfg != null && cfg.getApplicable() != null ? cfg.getApplicable() : true;
    }

    public boolean isReadOnly(String optionName) {
        ClientTypeRepresentation.PropertyConfig cfg = (ClientTypeRepresentation.PropertyConfig)this.clientType.getConfig().get(optionName);
        return cfg != null && cfg.getReadOnly() != null ? cfg.getReadOnly() : false;
    }

    public <T> T getDefaultValue(String optionName, Class<T> optionType) {
        ClientTypeRepresentation.PropertyConfig cfg = (ClientTypeRepresentation.PropertyConfig)this.clientType.getConfig().get(optionName);
        return cfg != null && cfg.getDefaultValue() != null ? (T)optionType.cast(cfg.getDefaultValue()) : null;
    }

    public void onCreate(ClientRepresentation createdClient) throws ClientTypeException {
        for (Map.Entry property : this.clientType.getConfig().entrySet()) {
            ClientTypeRepresentation.PropertyConfig propertyConfig = (ClientTypeRepresentation.PropertyConfig)property.getValue();
            if (!propertyConfig.getApplicable().booleanValue() || propertyConfig.getDefaultValue() == null) continue;
            if (this.clientRepresentationProperties.containsKey(property.getKey())) {
                try {
                    Object converted;
                    PropertyDescriptor propertyDescriptor = this.clientRepresentationProperties.get(property.getKey());
                    Method setter = propertyDescriptor.getWriteMethod();
                    Object defaultVal = propertyConfig.getDefaultValue();
                    if (defaultVal instanceof String && defaultVal.toString().startsWith(REFERENCE_PREFIX)) {
                        throw new UnsupportedOperationException("Not supported to use ref:: references");
                    }
                    Type genericType = setter.getGenericParameterTypes()[0];
                    if (!defaultVal.getClass().equals(genericType)) {
                        JavaType jacksonType = JsonSerialization.mapper.constructType(genericType);
                        converted = JsonSerialization.mapper.convertValue(defaultVal, jacksonType);
                    } else {
                        converted = defaultVal;
                    }
                    setter.invoke((Object)createdClient, converted);
                    continue;
                }
                catch (Exception e) {
                    logger.warnf("Cannot set property '%s' on client with value '%s'. Check configuration of the client type '%s'", property.getKey(), propertyConfig.getDefaultValue(), (Object)this.clientType.getName());
                    throw new ClientTypeException("Cannot set property on client", (Throwable)e);
                }
            }
            if (createdClient.getAttributes() == null) {
                createdClient.setAttributes(new HashMap());
            }
            createdClient.getAttributes().put((String)property.getKey(), propertyConfig.getDefaultValue().toString());
        }
    }

    public void onUpdate(ClientModel currentClient, ClientRepresentation newClient) throws ClientTypeException {
        ClientRepresentation oldClient = ModelToRepresentation.toRepresentation((ClientModel)currentClient, (KeycloakSession)this.session);
        for (Map.Entry property : this.clientType.getConfig().entrySet()) {
            String propertyName = (String)property.getKey();
            ClientTypeRepresentation.PropertyConfig propertyConfig = (ClientTypeRepresentation.PropertyConfig)property.getValue();
            Object oldVal = this.getClientProperty(oldClient, propertyName);
            Object newVal = this.getClientProperty(newClient, propertyName);
            if (propertyConfig.getApplicable().booleanValue() && !propertyConfig.getReadOnly().booleanValue() || ObjectUtil.isEqualOrBothNull((Object)oldVal, (Object)newVal)) continue;
            logger.warnf("Cannot change property '%s' of client '%s' . Old value '%s', New value '%s'", new Object[]{propertyName, currentClient.getClientId(), oldVal, newVal});
            throw new ClientTypeException("Cannot change property of client as it is not allowed");
        }
    }

    private Object getClientProperty(ClientRepresentation client, String propertyName) {
        PropertyDescriptor propertyDescriptor = this.clientRepresentationProperties.get(propertyName);
        if (propertyDescriptor != null) {
            Method getter = propertyDescriptor.getReadMethod();
            try {
                return getter.invoke((Object)client, new Object[0]);
            }
            catch (Exception e) {
                logger.warnf("Cannot read property '%s' on client '%s'. Client type is '%s'", (Object)propertyName, (Object)client.getClientId(), (Object)this.clientType.getName());
                throw new ClientTypeException("Cannot read property of client", (Throwable)e);
            }
        }
        return client.getAttributes() == null ? null : client.getAttributes().get(propertyName);
    }
}

