/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

public final class AuthenticatorUtils {
    private static final Logger logger = Logger.getLogger(AuthenticatorUtils.class);

    public static String getDisabledByBruteForceEventError(BruteForceProtector protector, KeycloakSession session, RealmModel realm, UserModel user) {
        if (realm.isBruteForceProtected()) {
            if (protector.isPermanentlyLockedOut(session, realm, user)) {
                return "user_disabled";
            }
            if (protector.isTemporarilyDisabled(session, realm, user)) {
                return "user_temporarily_disabled";
            }
            return null;
        }
        return null;
    }

    public static String getDisabledByBruteForceEventError(AuthenticationFlowContext authnFlowContext, UserModel authenticatedUser) {
        return AuthenticatorUtils.getDisabledByBruteForceEventError(authnFlowContext.getProtector(), authnFlowContext.getSession(), authnFlowContext.getRealm(), authenticatedUser);
    }

    public static Map<String, Integer> parseCompletedExecutions(String note) {
        if (note == null) {
            note = "{}";
        }
        try {
            return (Map)JsonSerialization.readValue((String)note, (TypeReference)new TypeReference<Map<String, Integer>>(){});
        }
        catch (IOException e) {
            logger.warnf("Invalid format of the completed authenticators map. Saved value was: %s", (Object)note);
            throw new IllegalStateException(e);
        }
    }

    public static void updateCompletedExecutions(AuthenticationSessionModel authSession, UserSessionModel userSession, String executionId) {
        Map<String, Integer> completedExecutions = AuthenticatorUtils.parseCompletedExecutions((String)authSession.getUserSessionNotes().get("authenticators-completed"));
        if (userSession != null) {
            Map<String, Integer> prevCompleted = AuthenticatorUtils.parseCompletedExecutions(userSession.getNote("authenticators-completed"));
            logger.debugf("merging completed executions from previous authentication session %s", prevCompleted);
            completedExecutions.putAll(prevCompleted);
        }
        completedExecutions.put(executionId, Time.currentTime());
        try {
            String updated = JsonSerialization.writeValueAsString(completedExecutions);
            authSession.setUserSessionNote("authenticators-completed", updated);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

