/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.OAuthErrorException;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.TokenRefreshContext;
import org.keycloak.services.clientpolicy.context.TokenRefreshResponseContext;

public class RefreshTokenGrantType
extends OAuth2GrantTypeBase {
    private static final Logger logger = Logger.getLogger(RefreshTokenGrantType.class);

    public Response process(OAuth2GrantType.Context context) {
        AccessTokenResponse res;
        this.setContext(context);
        this.checkAndRetrieveDPoPProof(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DPOP));
        String refreshToken = (String)this.formParams.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        String scopeParameter = this.getRequestedScopes();
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRefreshContext((MultivaluedMap<String, String>)this.formParams));
            refreshToken = (String)this.formParams.getFirst((Object)"refresh_token");
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        try {
            TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.refreshAccessToken(this.session, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.realm, this.client, refreshToken, this.event, this.headers, this.request, scopeParameter);
            this.checkAndBindMtlsHoKToken(responseBuilder, this.clientConfig.isUseRefreshToken());
            this.checkAndBindDPoPToken(responseBuilder, this.clientConfig.isUseRefreshToken() && (this.client.isPublicClient() || this.client.isBearerOnly()), Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DPOP));
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRefreshResponseContext((MultivaluedMap<String, String>)this.formParams, responseBuilder));
            res = responseBuilder.build();
            if (!responseBuilder.isOfflineToken()) {
                UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, res.getSessionState());
                AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(this.client.getId());
                this.updateClientSession(clientSession);
                this.updateUserSessionFromClientAuth(userSession);
            }
        }
        catch (OAuthErrorException e) {
            logger.trace((Object)e.getMessage(), (Throwable)e);
            if ("Client certificate missing, or its thumbprint and one in the refresh token did NOT match".equals(e.getDescription())) {
                this.event.detail("reason", e.getDescription());
                this.event.error("not_allowed");
                throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.UNAUTHORIZED);
            }
            this.event.detail("reason", e.getDescription());
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
        }
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    public EventType getEventType() {
        return EventType.REFRESH_TOKEN;
    }
}

