/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.instagram;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.models.KeycloakSession;

public class InstagramIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String AUTH_URL = "https://api.instagram.com/oauth/authorize";
    public static final String TOKEN_URL = "https://api.instagram.com/oauth/access_token";
    public static final String PROFILE_URL = "https://graph.instagram.com/me";
    public static final String PROFILE_FIELDS = "id,username";
    public static final String DEFAULT_SCOPE = "user_profile";
    public static final String LEGACY_ID_FIELD = "ig_id";

    public InstagramIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            JsonNode profile = this.fetchUserProfile(accessToken, true);
            if (!profile.has("id")) {
                logger.debugf("Could not fetch user profile from instagram. Trying without %s.", (Object)LEGACY_ID_FIELD);
                profile = this.fetchUserProfile(accessToken, false);
            }
            logger.debug((Object)profile.toString());
            String id = "graph_" + this.getJsonProperty(profile, "id");
            String username = this.getJsonProperty(profile, "username");
            String legacyId = this.getJsonProperty(profile, LEGACY_ID_FIELD);
            BrokeredIdentityContext user = new BrokeredIdentityContext(id);
            user.setUsername(username);
            user.setIdpConfig(this.getConfig());
            user.setIdp((IdentityProvider)this);
            if (legacyId != null && !legacyId.isEmpty()) {
                user.setLegacyId(legacyId);
            }
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from instagram.", (Throwable)e);
        }
    }

    protected JsonNode fetchUserProfile(String accessToken, boolean includeIgId) throws IOException {
        Object fields = PROFILE_FIELDS;
        if (includeIgId) {
            fields = (String)fields + ",ig_id";
        }
        return SimpleHttp.doGet((String)PROFILE_URL, (KeycloakSession)this.session).param("access_token", accessToken).param("fields", (String)fields).asJson();
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

