/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.PasswordCredentialProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.utils.RequiredActionHelper;
import org.keycloak.validate.ValidationError;

public class UpdatePassword
implements RequiredActionProvider,
RequiredActionFactory {
    private static final Logger logger;
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES;
    public static final String MAX_AUTH_AGE_KEY = "max_auth_age";
    private final KeycloakSession session;

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    @Deprecated
    public UpdatePassword() {
        this(null);
    }

    public UpdatePassword(KeycloakSession session) {
        this.session = session;
    }

    public void evaluateTriggers(RequiredActionContext context) {
        PasswordCredentialProvider passwordProvider;
        PasswordCredentialModel password;
        if (!AuthenticatorUtil.isPasswordValidated(context.getAuthenticationSession())) {
            return;
        }
        int daysToExpirePassword = context.getRealm().getPasswordPolicy().getDaysToExpirePassword();
        if (daysToExpirePassword != -1 && (password = (passwordProvider = (PasswordCredentialProvider)context.getSession().getProvider(CredentialProvider.class, "keycloak-password")).getPassword(context.getRealm(), context.getUser())) != null) {
            if (password.getCreatedDate() == null) {
                context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                logger.debug((Object)"User is required to update password");
            } else {
                long timeToExpire;
                long timeElapsed = Time.toMillis((long)Time.currentTime()) - password.getCreatedDate();
                if (timeElapsed > (timeToExpire = TimeUnit.DAYS.toMillis(daysToExpirePassword))) {
                    context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                    logger.debug((Object)"User is required to update password");
                }
            }
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("username", (Object)context.getAuthenticationSession().getAuthenticatedUser().getUsername()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        UserModel user = context.getUser();
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        event.event(EventType.UPDATE_PASSWORD);
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        EventBuilder errorEvent = event.clone().event(EventType.UPDATE_PASSWORD_ERROR).client(authSession.getClient()).user(authSession.getAuthenticatedUser());
        if (Validation.isBlank(passwordNew)) {
            Response challenge = context.form().setAttribute("username", (Object)authSession.getAuthenticatedUser().getUsername()).addError(new FormMessage("password", "missingPasswordMessage")).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            errorEvent.error("password_missing");
            return;
        }
        if (!passwordNew.equals(passwordConfirm)) {
            Response challenge = context.form().setAttribute("username", (Object)authSession.getAuthenticatedUser().getUsername()).addError(new FormMessage("password-confirm", "notMatchPasswordMessage")).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            errorEvent.error("password_confirm_error");
            return;
        }
        if ("on".equals(formData.getFirst((Object)"logout-sessions"))) {
            AuthenticatorUtil.logoutOtherSessions(context);
        }
        try {
            user.credentialManager().updateCredential((CredentialInput)UserCredentialModel.password((String)passwordNew, (boolean)false));
            context.success();
        }
        catch (ModelException me) {
            errorEvent.detail("reason", me.getMessage()).error("password_rejected");
            Response challenge = context.form().setAttribute("username", (Object)authSession.getAuthenticatedUser().getUsername()).setError(me.getMessage(), me.getParameters()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            return;
        }
        catch (Exception ape) {
            errorEvent.detail("reason", ape.getMessage()).error("password_rejected");
            Response challenge = context.form().setAttribute("username", (Object)authSession.getAuthenticatedUser().getUsername()).setError(ape.getMessage(), new Object[0]).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            return;
        }
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return new UpdatePassword(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Update Password";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PASSWORD.name();
    }

    public boolean isOneTimeAction() {
        return true;
    }

    public int getMaxAuthAge() {
        RequiredActionConfigModel configModel;
        String providerId;
        RequiredActionProviderModel requiredAction;
        if (this.session == null) {
            return 300;
        }
        KeycloakContext keycloakContext = this.session.getContext();
        RealmModel realm = keycloakContext.getRealm();
        int maxAge = realm.getPasswordPolicy().getMaxAuthAge();
        if (maxAge >= 0) {
            return maxAge;
        }
        AuthenticationSessionModel authSession = keycloakContext.getAuthenticationSession();
        if (authSession != null && (requiredAction = RequiredActionHelper.getRequiredActionByProviderId((RealmModel)realm, (String)(providerId = authSession.getClientNote("kc_action")))) != null && (configModel = realm.getRequiredActionConfigByAlias(requiredAction.getAlias())) != null && configModel.containsConfigKey(MAX_AUTH_AGE_KEY) && (maxAge = this.parseMaxAuthAge(configModel)) >= 0) {
            return maxAge;
        }
        return 300;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return List.copyOf(CONFIG_PROPERTIES);
    }

    public void validateConfig(KeycloakSession session, RealmModel realm, RequiredActionConfigModel model) {
        int parsedMaxAuthAge;
        try {
            parsedMaxAuthAge = this.parseMaxAuthAge(model);
        }
        catch (Exception ex) {
            throw new ValidationException(new ValidationError(this.getId(), MAX_AUTH_AGE_KEY, "error-invalid-value"));
        }
        if (parsedMaxAuthAge < 0) {
            throw new ValidationException(new ValidationError(this.getId(), MAX_AUTH_AGE_KEY, "error-number-out-of-range-too-small", new Object[]{0}));
        }
    }

    private int parseMaxAuthAge(RequiredActionConfigModel model) throws NumberFormatException {
        return Integer.parseInt(model.getConfigValue(MAX_AUTH_AGE_KEY));
    }

    static {
        List properties;
        logger = Logger.getLogger(UpdatePassword.class);
        CONFIG_PROPERTIES = properties = ProviderConfigurationBuilder.create().property().name(MAX_AUTH_AGE_KEY).label("Maximum Age of Authentication").helpText("Configures the duration in seconds this action can be used after the last authentication before the user is required to re-authenticate. This parameter is used just in the context of AIA when the kc_action parameter is available in the request, which is for instance when user himself updates his password in the account console. When the 'Maximum Authentication Age' password policy is used in the realm, it's value has precedence over the value configured here.").type("String").defaultValue((Object)300).add().build();
    }
}

