/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.common.Profile;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderStorageProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrderedModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.Urls;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.Theme;

public class IdentityProviderBean {
    public static OrderedModel.OrderedModelComparator<IdentityProvider> IDP_COMPARATOR_INSTANCE = new OrderedModel.OrderedModelComparator();
    private static final String ICON_THEME_PREFIX = "kcLogoIdP-";
    protected AuthenticationFlowContext context;
    protected List<IdentityProvider> providers;
    protected KeycloakSession session;
    protected RealmModel realm;
    protected URI baseURI;

    public IdentityProviderBean(KeycloakSession session, RealmModel realm, URI baseURI, AuthenticationFlowContext context) {
        this.session = session;
        this.realm = realm;
        this.baseURI = baseURI;
        this.context = context;
    }

    public List<IdentityProvider> getProviders() {
        if (this.providers == null) {
            String existingIDP = this.getExistingIDP(this.session, this.context);
            Set<String> federatedIdentities = this.getLinkedBrokerAliases(this.session, this.realm, this.context);
            this.providers = federatedIdentities != null ? this.getFederatedIdentityProviders(federatedIdentities, existingIDP) : this.searchForIdentityProviders(existingIDP);
        }
        return this.providers;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public AuthenticationFlowContext getFlowContext() {
        return this.context;
    }

    protected IdentityProvider createIdentityProvider(RealmModel realm, URI baseURI, IdentityProviderModel identityProvider) {
        String loginUrl = Urls.identityProviderAuthnRequest(baseURI, identityProvider.getAlias(), realm.getName()).toString();
        String displayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)this.session, (IdentityProviderModel)identityProvider);
        return new IdentityProvider(identityProvider.getAlias(), displayName, identityProvider.getProviderId(), loginUrl, (String)identityProvider.getConfig().get("guiOrder"), this.getLoginIconClasses(identityProvider));
    }

    private String getLoginIconClasses(IdentityProviderModel identityProvider) {
        try {
            Theme theme = this.session.theme().getTheme(Theme.Type.LOGIN);
            Optional<String> classesFromTheme = Optional.ofNullable(this.getLogoIconClass(identityProvider, theme.getProperties()));
            Optional<String> classesFromModel = Optional.ofNullable(identityProvider.getDisplayIconClasses());
            return classesFromTheme.orElse(classesFromModel.orElse(""));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private String getLogoIconClass(IdentityProviderModel identityProvider, Properties themeProperties) throws IOException {
        String iconClass = themeProperties.getProperty(ICON_THEME_PREFIX + identityProvider.getAlias());
        if (iconClass == null) {
            return themeProperties.getProperty(ICON_THEME_PREFIX + identityProvider.getProviderId());
        }
        return iconClass;
    }

    protected String getExistingIDP(KeycloakSession session, AuthenticationFlowContext context) {
        String existingIDPAlias = null;
        if (context != null) {
            AuthenticationSessionModel authSession = context.getAuthenticationSession();
            String currentFlowPath = authSession.getAuthNote("current.flow.path");
            UserModel currentUser = context.getUser();
            if (currentUser == null && Objects.equals("first-broker-login", currentFlowPath)) {
                IdentityProviderModel existingIdp;
                SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, "BROKERED_CONTEXT");
                IdentityProviderModel identityProviderModel = existingIdp = serializedCtx == null ? null : serializedCtx.deserialize(session, authSession).getIdpConfig();
                if (existingIdp != null) {
                    existingIDPAlias = existingIdp.getAlias();
                }
            }
        }
        return existingIDPAlias;
    }

    protected Set<String> getLinkedBrokerAliases(KeycloakSession session, RealmModel realm, AuthenticationFlowContext context) {
        Set federatedIdentities;
        UserModel currentUser;
        HashSet result = null;
        if (context != null && (currentUser = context.getUser()) != null && (!(federatedIdentities = session.users().getFederatedIdentitiesStream(session.getContext().getRealm(), currentUser).map(FederatedIdentityModel::getIdentityProvider).collect(Collectors.toSet())).isEmpty() || IdentityProviderBean.organizationsDisabled(realm))) {
            result = new HashSet(federatedIdentities);
        }
        return result;
    }

    protected List<IdentityProvider> getFederatedIdentityProviders(Set<String> federatedProviders, String existingIDP) {
        return federatedProviders.stream().filter(alias -> !Objects.equals(existingIDP, alias)).map(alias -> this.session.identityProviders().getByAlias(alias)).filter(this.federatedProviderPredicate()).map(idp -> this.createIdentityProvider(this.realm, this.baseURI, (IdentityProviderModel)idp)).sorted((Comparator<IdentityProvider>)IDP_COMPARATOR_INSTANCE).toList();
    }

    protected Predicate<IdentityProviderModel> federatedProviderPredicate() {
        return IdentityProviderStorageProvider.LoginFilter.getLoginPredicate();
    }

    protected List<IdentityProvider> searchForIdentityProviders(String existingIDP) {
        return this.session.identityProviders().getForLogin(IdentityProviderStorageProvider.FetchMode.REALM_ONLY, null).filter(idp -> !Objects.equals(existingIDP, idp.getAlias())).map(idp -> this.createIdentityProvider(this.realm, this.baseURI, (IdentityProviderModel)idp)).sorted((Comparator<IdentityProvider>)IDP_COMPARATOR_INSTANCE).toList();
    }

    private static boolean organizationsDisabled(RealmModel realm) {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) || !realm.isOrganizationsEnabled();
    }

    public static class IdentityProvider
    implements OrderedModel {
        private final String alias;
        private final String providerId;
        private final String loginUrl;
        private final String guiOrder;
        private final String displayName;
        private final String iconClasses;

        public IdentityProvider(String alias, String displayName, String providerId, String loginUrl, String guiOrder) {
            this(alias, displayName, providerId, loginUrl, guiOrder, "");
        }

        public IdentityProvider(String alias, String displayName, String providerId, String loginUrl, String guiOrder, String iconClasses) {
            this.alias = alias;
            this.displayName = displayName;
            this.providerId = providerId;
            this.loginUrl = loginUrl;
            this.guiOrder = guiOrder;
            this.iconClasses = iconClasses;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getLoginUrl() {
            return this.loginUrl;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public String getGuiOrder() {
            return this.guiOrder;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getIconClasses() {
            return this.iconClasses;
        }
    }
}

