/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.DisplayTypeAuthenticatorFactory;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.ForkFlowException;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.sessions.CommonClientSessionModel;

public class DefaultAuthenticationFlow
implements AuthenticationFlow {
    private static final Logger logger = Logger.getLogger(DefaultAuthenticationFlow.class);
    Response alternativeChallenge = null;
    AuthenticationExecutionModel challengedAlternativeExecution = null;
    boolean alternativeSuccessful = false;
    List<AuthenticationExecutionModel> executions;
    Iterator<AuthenticationExecutionModel> executionIterator;
    AuthenticationProcessor processor;
    AuthenticationFlowModel flow;

    public DefaultAuthenticationFlow(AuthenticationProcessor processor, AuthenticationFlowModel flow) {
        this.processor = processor;
        this.flow = flow;
        this.executions = processor.getRealm().getAuthenticationExecutions(flow.getId());
        this.executionIterator = this.executions.iterator();
    }

    protected boolean isProcessed(AuthenticationExecutionModel model) {
        if (model.isDisabled()) {
            return true;
        }
        CommonClientSessionModel.ExecutionStatus status = (CommonClientSessionModel.ExecutionStatus)this.processor.getAuthenticationSession().getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == CommonClientSessionModel.ExecutionStatus.SUCCESS || status == CommonClientSessionModel.ExecutionStatus.SKIPPED || status == CommonClientSessionModel.ExecutionStatus.ATTEMPTED || status == CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED;
    }

    protected Authenticator createAuthenticator(AuthenticatorFactory factory) {
        Authenticator authenticator;
        String display = this.processor.getAuthenticationSession().getAuthNote("display");
        if (display == null) {
            return (Authenticator)factory.create(this.processor.getSession());
        }
        if (factory instanceof DisplayTypeAuthenticatorFactory && (authenticator = ((DisplayTypeAuthenticatorFactory)factory).createDisplay(this.processor.getSession(), display)) != null) {
            return authenticator;
        }
        if ("console".equalsIgnoreCase(display)) {
            this.processor.getAuthenticationSession().removeAuthNote("display");
            throw new AuthenticationFlowException(AuthenticationFlowError.DISPLAY_NOT_SUPPORTED, ConsoleDisplayMode.browserContinue((KeycloakSession)this.processor.getSession(), (String)this.processor.getRefreshUrl(true).toString()));
        }
        return (Authenticator)factory.create(this.processor.getSession());
    }

    public Response processAction(String actionExecution) {
        logger.debugv("processAction: {0}", (Object)actionExecution);
        while (this.executionIterator.hasNext()) {
            AuthenticationExecutionModel model = this.executionIterator.next();
            logger.debugv("check: {0} requirement: {1}", (Object)model.getAuthenticator(), (Object)model.getRequirement().toString());
            if (this.isProcessed(model)) {
                logger.debug((Object)"execution is processed");
                if (this.alternativeSuccessful || !model.isAlternative() || !this.processor.isSuccessful(model)) continue;
                this.alternativeSuccessful = true;
                continue;
            }
            if (model.isAuthenticatorFlow()) {
                AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
                Response flowChallenge = null;
                try {
                    flowChallenge = authenticationFlow.processAction(actionExecution);
                }
                catch (AuthenticationFlowException afe) {
                    if (model.isAlternative()) {
                        logger.debug((Object)"Thrown exception in alternative Subflow. Ignoring Subflow");
                        this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.ATTEMPTED);
                        return this.processFlow();
                    }
                    throw afe;
                }
                if (flowChallenge == null) {
                    this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SUCCESS);
                    if (model.isAlternative()) {
                        this.alternativeSuccessful = true;
                    }
                    return this.processFlow();
                }
                return flowChallenge;
            }
            if (!model.getId().equals(actionExecution)) continue;
            AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
            }
            Authenticator authenticator = this.createAuthenticator(factory);
            AuthenticationProcessor.Result result = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
            logger.debugv("action: {0}", (Object)model.getAuthenticator());
            authenticator.action((AuthenticationFlowContext)result);
            Response response = this.processResult(result, true);
            if (response == null) {
                this.processor.getAuthenticationSession().removeAuthNote("current.authentication.execution");
                return this.processFlow();
            }
            return response;
        }
        throw new AuthenticationFlowException("action is not in current execution", AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response processFlow() {
        logger.debug((Object)"processFlow");
        while (this.executionIterator.hasNext()) {
            AuthenticationExecutionModel model = this.executionIterator.next();
            logger.debugv("check execution: {0} requirement: {1}", (Object)model.getAuthenticator(), (Object)model.getRequirement().toString());
            if (this.isProcessed(model)) {
                logger.debug((Object)"execution is processed");
                if (this.alternativeSuccessful || !model.isAlternative() || !this.processor.isSuccessful(model)) continue;
                this.alternativeSuccessful = true;
                continue;
            }
            if (model.isAlternative() && this.alternativeSuccessful) {
                logger.debug((Object)"Skip alternative execution");
                this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SKIPPED);
                continue;
            }
            if (model.isAuthenticatorFlow()) {
                logger.debug((Object)"execution is flow");
                AuthenticationFlow authenticationFlow = this.processor.createFlowExecution(model.getFlowId(), model);
                Response flowChallenge = null;
                try {
                    flowChallenge = authenticationFlow.processFlow();
                }
                catch (AuthenticationFlowException afe) {
                    if (model.isAlternative()) {
                        logger.debug((Object)"Thrown exception in alternative Subflow. Ignoring Subflow");
                        this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.ATTEMPTED);
                        continue;
                    }
                    throw afe;
                }
                if (flowChallenge == null) {
                    this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SUCCESS);
                    if (!model.isAlternative()) continue;
                    this.alternativeSuccessful = true;
                    continue;
                }
                if (!model.isAlternative()) {
                    if (model.isRequired()) {
                        this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                        return flowChallenge;
                    }
                    if (model.isOptional()) {
                        this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SKIPPED);
                        continue;
                    }
                    this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
                this.alternativeChallenge = flowChallenge;
                this.challengedAlternativeExecution = model;
                return flowChallenge;
            }
            AuthenticatorFactory factory = (AuthenticatorFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, model.getAuthenticator());
            if (factory == null) {
                throw new RuntimeException("Unable to find factory for AuthenticatorFactory: " + model.getAuthenticator() + " did you forget to declare it in a META-INF/services file?");
            }
            Authenticator authenticator = this.createAuthenticator(factory);
            logger.debugv("authenticator: {0}", (Object)factory.getId());
            UserModel authUser = this.processor.getAuthenticationSession().getAuthenticatedUser();
            if (authenticator.requiresUser() && authUser == null) {
                if (this.alternativeChallenge != null) {
                    this.processor.getAuthenticationSession().setExecutionStatus(this.challengedAlternativeExecution.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                    return this.alternativeChallenge;
                }
                throw new AuthenticationFlowException("authenticator: " + factory.getId(), AuthenticationFlowError.UNKNOWN_USER);
            }
            boolean configuredFor = false;
            if (authenticator.requiresUser() && authUser != null && !(configuredFor = authenticator.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser))) {
                if (model.isRequired()) {
                    if (factory.isUserSetupAllowed()) {
                        logger.debugv("authenticator SETUP_REQUIRED: {0}", (Object)factory.getId());
                        this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                        authenticator.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getAuthenticationSession().getAuthenticatedUser());
                        continue;
                    }
                    throw new AuthenticationFlowException(AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED);
                }
                if (model.isOptional()) {
                    this.processor.getAuthenticationSession().setExecutionStatus(model.getId(), CommonClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
            }
            AuthenticationProcessor.Result context = this.processor.createAuthenticatorContext(model, authenticator, this.executions);
            logger.debugv("invoke authenticator.authenticate: {0}", (Object)factory.getId());
            authenticator.authenticate((AuthenticationFlowContext)context);
            Response response = this.processResult(context, false);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    public Response processResult(AuthenticationProcessor.Result result, boolean isAction) {
        AuthenticationExecutionModel execution = result.getExecution();
        FlowStatus status = result.getStatus();
        switch (status) {
            case SUCCESS: {
                logger.debugv("authenticator SUCCESS: {0}", (Object)execution.getAuthenticator());
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.SUCCESS);
                if (execution.isAlternative()) {
                    this.alternativeSuccessful = true;
                }
                return null;
            }
            case FAILED: {
                logger.debugv("authenticator FAILED: {0}", (Object)execution.getAuthenticator());
                this.processor.logFailure();
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.FAILED);
                if (result.getChallenge() != null) {
                    return this.sendChallenge(result, execution);
                }
                throw new AuthenticationFlowException(result.getError());
            }
            case FORK: {
                logger.debugv("reset browser login from authenticator: {0}", (Object)execution.getAuthenticator());
                this.processor.getAuthenticationSession().setAuthNote("current.authentication.execution", execution.getId());
                throw new ForkFlowException(result.getSuccessMessage(), result.getErrorMessage());
            }
            case FORCE_CHALLENGE: {
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case CHALLENGE: {
                logger.debugv("authenticator CHALLENGE: {0}", (Object)execution.getAuthenticator());
                if (execution.isRequired()) {
                    this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                    return this.sendChallenge(result, execution);
                }
                UserModel authenticatedUser = this.processor.getAuthenticationSession().getAuthenticatedUser();
                if (execution.isOptional() && authenticatedUser != null && result.getAuthenticator().configuredFor(this.processor.getSession(), this.processor.getRealm(), authenticatedUser)) {
                    this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                    return this.sendChallenge(result, execution);
                }
                if (execution.isAlternative()) {
                    this.alternativeChallenge = result.getChallenge();
                    this.challengedAlternativeExecution = execution;
                } else {
                    this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.SKIPPED);
                }
                return null;
            }
            case FAILURE_CHALLENGE: {
                logger.debugv("authenticator FAILURE_CHALLENGE: {0}", (Object)execution.getAuthenticator());
                this.processor.logFailure();
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
                return this.sendChallenge(result, execution);
            }
            case ATTEMPTED: {
                logger.debugv("authenticator ATTEMPTED: {0}", (Object)execution.getAuthenticator());
                if (execution.getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
                    throw new AuthenticationFlowException(AuthenticationFlowError.INVALID_CREDENTIALS);
                }
                this.processor.getAuthenticationSession().setExecutionStatus(execution.getId(), CommonClientSessionModel.ExecutionStatus.ATTEMPTED);
                return null;
            }
            case FLOW_RESET: {
                this.processor.resetFlow();
                return this.processor.authenticate();
            }
        }
        logger.debugv("authenticator INTERNAL_ERROR: {0}", (Object)execution.getAuthenticator());
        ServicesLogger.LOGGER.unknownResultStatus();
        throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response sendChallenge(AuthenticationProcessor.Result result, AuthenticationExecutionModel execution) {
        this.processor.getAuthenticationSession().setAuthNote("current.authentication.execution", execution.getId());
        return result.getChallenge();
    }
}

