/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.keycloak.vault.VaultRawSecret;

public class DefaultVaultRawSecret
implements VaultRawSecret {
    private static final VaultRawSecret EMPTY_VAULT_SECRET = new VaultRawSecret(){

        public Optional<ByteBuffer> getRawSecret() {
            return Optional.empty();
        }

        public void close() {
        }
    };
    private final ByteBuffer rawSecret;

    public static VaultRawSecret forBuffer(Optional<ByteBuffer> buffer) {
        if (buffer == null || !buffer.isPresent()) {
            return EMPTY_VAULT_SECRET;
        }
        return new DefaultVaultRawSecret(buffer.get());
    }

    private DefaultVaultRawSecret(ByteBuffer rawSecret) {
        this.rawSecret = rawSecret;
    }

    public Optional<ByteBuffer> getRawSecret() {
        return Optional.of(this.rawSecret);
    }

    public void close() {
        if (this.rawSecret.hasArray()) {
            ThreadLocalRandom.current().nextBytes(this.rawSecret.array());
        }
    }
}

