/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.locale;

import java.util.Locale;
import java.util.Set;
import org.keycloak.locale.LocaleSelection;

public class LocaleNegotiator {
    private Set<String> supportedLocales;

    public LocaleNegotiator(Set<String> supportedLocales) {
        this.supportedLocales = supportedLocales;
    }

    public LocaleSelection invoke(String ... localeStrings) {
        for (String localeString : localeStrings) {
            if (localeString == null) continue;
            Locale result = null;
            Locale search = Locale.forLanguageTag(localeString);
            for (String languageTag : this.supportedLocales) {
                Locale locale = Locale.forLanguageTag(languageTag);
                if (!locale.getLanguage().equals(search.getLanguage())) continue;
                if (search.getCountry().equals("") ^ locale.getCountry().equals("") && result == null) {
                    result = locale;
                }
                if (!locale.getCountry().equals(search.getCountry())) continue;
                return new LocaleSelection(localeString, locale);
            }
            if (result == null) continue;
            return new LocaleSelection(localeString, result);
        }
        return null;
    }
}

