/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.resetcred;

import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.authenticators.resetcred.AbstractSetRequiredActionAuthenticator;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class ResetOTP
extends AbstractSetRequiredActionAuthenticator
implements CredentialValidator<OTPCredentialProvider> {
    public static final String PROVIDER_ID = "reset-otp";

    public void authenticate(AuthenticationFlowContext context) {
        context.getAuthenticationSession().addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        context.success();
    }

    public OTPCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (OTPCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return this.getCredentialProvider(session).isConfiguredFor(realm, user);
    }

    public String getDisplayType() {
        return "Reset OTP";
    }

    public String getHelpText() {
        return "Sets the Configure OTP required action.";
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

