/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.account.ClientRepresentation;
import org.keycloak.representations.account.ConsentRepresentation;
import org.keycloak.representations.account.ConsentScopeRepresentation;
import org.keycloak.representations.account.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.account.AccountCredentialResource;
import org.keycloak.services.resources.account.LinkedAccountsResource;
import org.keycloak.services.resources.account.SessionResource;
import org.keycloak.services.resources.account.resources.ResourcesService;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.theme.Theme;

public class AccountRestService {
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    protected ClientConnection clientConnection;
    private final KeycloakSession session;
    private final ClientModel client;
    private final EventBuilder event;
    private EventStoreProvider eventStore;
    private Auth auth;
    private final RealmModel realm;
    private final UserModel user;
    private final Locale locale;

    public AccountRestService(KeycloakSession session, Auth auth, ClientModel client, EventBuilder event) {
        this.session = session;
        this.auth = auth;
        this.realm = auth.getRealm();
        this.user = auth.getUser();
        this.client = client;
        this.event = event;
        this.locale = session.getContext().resolveLocale(this.user);
    }

    public void init() {
        this.eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
    }

    @Path(value="/")
    @OPTIONS
    @NoCache
    public Response preflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response account() {
        this.auth.requireOneOf("manage-account", "view-profile");
        UserModel user = this.auth.getUser();
        UserRepresentation rep = new UserRepresentation();
        rep.setUsername(user.getUsername());
        rep.setFirstName(user.getFirstName());
        rep.setLastName(user.getLastName());
        rep.setEmail(user.getEmail());
        rep.setEmailVerified(user.isEmailVerified());
        rep.setAttributes(user.getAttributes());
        return Cors.add(this.request, Response.ok((Object)rep)).auth().allowedOrigins(this.auth.getToken()).build();
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response updateAccount(UserRepresentation userRep) {
        this.auth.require("manage-account");
        this.event.event(EventType.UPDATE_PROFILE).client(this.auth.getClient()).user(this.user);
        try {
            UserModel existing;
            boolean emailChanged;
            boolean usernameChanged;
            RealmModel realm = this.session.getContext().getRealm();
            boolean bl = usernameChanged = userRep.getUsername() != null && !userRep.getUsername().equals(this.user.getUsername());
            if (realm.isEditUsernameAllowed()) {
                if (usernameChanged) {
                    UserModel existing2 = this.session.users().getUserByUsername(userRep.getUsername(), realm);
                    if (existing2 != null) {
                        return ErrorResponse.exists("usernameExistsMessage");
                    }
                    this.user.setUsername(userRep.getUsername());
                }
            } else if (usernameChanged) {
                return ErrorResponse.error("readOnlyUsernameMessage", Response.Status.BAD_REQUEST);
            }
            boolean bl2 = emailChanged = userRep.getEmail() != null && !userRep.getEmail().equals(this.user.getEmail());
            if (emailChanged && !realm.isDuplicateEmailsAllowed() && (existing = this.session.users().getUserByEmail(userRep.getEmail(), realm)) != null) {
                return ErrorResponse.exists("emailExistsMessage");
            }
            if (emailChanged && realm.isRegistrationEmailAsUsername() && !realm.isDuplicateEmailsAllowed() && (existing = this.session.users().getUserByUsername(userRep.getEmail(), realm)) != null) {
                return ErrorResponse.exists("usernameExistsMessage");
            }
            if (emailChanged) {
                String oldEmail = this.user.getEmail();
                this.user.setEmail(userRep.getEmail());
                this.user.setEmailVerified(false);
                this.event.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", userRep.getEmail()).success();
                if (realm.isRegistrationEmailAsUsername()) {
                    this.user.setUsername(userRep.getEmail());
                }
            }
            this.user.setFirstName(userRep.getFirstName());
            this.user.setLastName(userRep.getLastName());
            if (userRep.getAttributes() != null) {
                for (String string : this.user.getAttributes().keySet()) {
                    if (userRep.getAttributes().containsKey(string)) continue;
                    this.user.removeAttribute(string);
                }
                for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                    this.user.setAttribute((String)entry.getKey(), (List)entry.getValue());
                }
            }
            this.event.success();
            return Cors.add(this.request, Response.ok()).auth().allowedOrigins(this.auth.getToken()).build();
        }
        catch (ReadOnlyException e) {
            return ErrorResponse.error("readOnlyUserMessage", Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="/sessions")
    public SessionResource sessions() {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-profile");
        return new SessionResource(this.session, this.auth, this.request);
    }

    @Path(value="/credentials")
    public AccountCredentialResource credentials() {
        AccountRestService.checkAccountApiEnabled();
        return new AccountCredentialResource(this.session, this.event, this.user, this.auth);
    }

    @Path(value="/resources")
    public ResourcesService resources() {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-profile");
        return new ResourcesService(this.session, this.user, this.auth, this.request);
    }

    @Path(value="/applications/{clientId}")
    @GET
    @Produces(value={"application/json"})
    public Response getApplication(@PathParam(value="clientId") String clientId) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-applications");
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null || client.isBearerOnly() || client.getBaseUrl() == null) {
            return Cors.add(this.request, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No client with clientId: " + clientId + " found."))).build();
        }
        LinkedList<String> inUseClients = new LinkedList<String>();
        if (!this.session.sessions().getUserSessions(this.realm, client).isEmpty()) {
            inUseClients.add(clientId);
        }
        LinkedList<String> offlineClients = new LinkedList<String>();
        if (this.session.sessions().getOfflineSessionsCount(this.realm, client) > 0L) {
            offlineClients.add(clientId);
        }
        UserConsentModel consentModel = this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId());
        Map<String, UserConsentModel> consentModels = Collections.singletonMap(client.getClientId(), consentModel);
        return Cors.add(this.request, Response.ok((Object)this.modelToRepresentation(client, inUseClients, offlineClients, consentModels))).build();
    }

    private ClientRepresentation modelToRepresentation(ClientModel model, List<String> inUseClients, List<String> offlineClients, Map<String, UserConsentModel> consents) {
        ClientRepresentation representation = new ClientRepresentation();
        representation.setClientId(model.getClientId());
        representation.setClientName(StringPropertyReplacer.replaceProperties((String)model.getName(), (Properties)this.getProperties()));
        representation.setDescription(model.getDescription());
        representation.setUserConsentRequired(model.isConsentRequired());
        representation.setInUse(inUseClients.contains(model.getClientId()));
        representation.setOfflineAccess(offlineClients.contains(model.getClientId()));
        representation.setBaseUrl(model.getBaseUrl());
        UserConsentModel consentModel = consents.get(model.getClientId());
        if (consentModel != null) {
            representation.setConsent(this.modelToRepresentation(consentModel));
        }
        return representation;
    }

    private ConsentRepresentation modelToRepresentation(UserConsentModel model) {
        List grantedScopes = model.getGrantedClientScopes().stream().map(m -> new ConsentScopeRepresentation(m.getId(), m.getName(), StringPropertyReplacer.replaceProperties((String)m.getConsentScreenText(), (Properties)this.getProperties()))).collect(Collectors.toList());
        return new ConsentRepresentation(grantedScopes, model.getCreatedDate(), model.getLastUpdatedDate());
    }

    private Properties getProperties() {
        try {
            return this.session.theme().getTheme(Theme.Type.ACCOUNT).getMessages(this.locale);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Path(value="/applications/{clientId}/consent")
    @GET
    @Produces(value={"application/json"})
    public Response getConsent(@PathParam(value="clientId") String clientId) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-consent", "manage-consent");
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            return Cors.add(this.request, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No client with clientId: " + clientId + " found."))).build();
        }
        UserConsentModel consent = this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId());
        if (consent == null) {
            return Cors.add(this.request, Response.noContent()).build();
        }
        return Cors.add(this.request, Response.ok((Object)this.modelToRepresentation(consent))).build();
    }

    @Path(value="/applications/{clientId}/consent")
    @DELETE
    public Response revokeConsent(@PathParam(value="clientId") String clientId) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "manage-consent");
        this.event.event(EventType.REVOKE_GRANT);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            this.event.event(EventType.REVOKE_GRANT_ERROR);
            String msg = String.format("No client with clientId: %s found.", clientId);
            this.event.error(msg);
            return Cors.add(this.request, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg)).build();
        }
        this.session.users().revokeConsentForClient(this.realm, this.user.getId(), client.getId());
        this.event.success();
        return Cors.add(this.request, Response.accepted()).build();
    }

    @Path(value="/applications/{clientId}/consent")
    @POST
    @Produces(value={"application/json"})
    public Response grantConsent(@PathParam(value="clientId") String clientId, ConsentRepresentation consent) {
        return this.upsert(clientId, consent);
    }

    @Path(value="/applications/{clientId}/consent")
    @PUT
    @Produces(value={"application/json"})
    public Response updateConsent(@PathParam(value="clientId") String clientId, ConsentRepresentation consent) {
        return this.upsert(clientId, consent);
    }

    @Path(value="/totp/remove")
    @DELETE
    public Response removeTOTP() {
        this.auth.require("manage-account");
        this.session.userCredentialManager().disableCredentialType(this.realm, this.user, "otp");
        this.event.event(EventType.REMOVE_TOTP).client(this.auth.getClient()).user(this.auth.getUser()).success();
        return Cors.add(this.request, Response.accepted()).build();
    }

    private Response upsert(String clientId, ConsentRepresentation consent) {
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "manage-consent");
        this.event.event(EventType.GRANT_CONSENT);
        ClientModel client = this.realm.getClientByClientId(clientId);
        if (client == null) {
            this.event.event(EventType.GRANT_CONSENT_ERROR);
            String msg = String.format("No client with clientId: %s found.", clientId);
            this.event.error(msg);
            return Cors.add(this.request, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg)).build();
        }
        try {
            UserConsentModel grantedConsent = this.createConsent(client, consent);
            if (this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId()) == null) {
                this.session.users().addConsent(this.realm, this.user.getId(), grantedConsent);
            } else {
                this.session.users().updateConsent(this.realm, this.user.getId(), grantedConsent);
            }
            this.event.success();
            grantedConsent = this.session.users().getConsentByClient(this.realm, this.user.getId(), client.getId());
            return Cors.add(this.request, Response.ok((Object)this.modelToRepresentation(grantedConsent))).build();
        }
        catch (IllegalArgumentException e) {
            return Cors.add(this.request, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage())).build();
        }
    }

    private UserConsentModel createConsent(ClientModel client, ConsentRepresentation requested) throws IllegalArgumentException {
        UserConsentModel consent = new UserConsentModel(client);
        Map<String, ClientScopeModel> availableGrants = this.realm.getClientScopes().stream().collect(Collectors.toMap(ClientScopeModel::getId, s -> s));
        if (client.isConsentRequired()) {
            availableGrants.put(client.getId(), (ClientScopeModel)client);
        }
        for (ConsentScopeRepresentation scopeRepresentation : requested.getGrantedScopes()) {
            ClientScopeModel scopeModel = availableGrants.get(scopeRepresentation.getId());
            if (scopeModel == null) {
                String msg = String.format("Scope id %s does not exist for client %s.", scopeRepresentation, consent.getClient().getName());
                this.event.error(msg);
                throw new IllegalArgumentException(msg);
            }
            consent.addGrantedClientScope(scopeModel);
        }
        return consent;
    }

    @Path(value="/linked-accounts")
    public LinkedAccountsResource linkedAccounts() {
        return new LinkedAccountsResource(this.session, this.request, this.client, this.auth, this.event, this.user);
    }

    @Path(value="/applications")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response applications() {
        ClientModel client3;
        AccountRestService.checkAccountApiEnabled();
        this.auth.requireOneOf("manage-account", "view-applications");
        HashSet<ClientModel> clients = new HashSet<ClientModel>();
        LinkedList<String> inUseClients = new LinkedList<String>();
        List sessions = this.session.sessions().getUserSessions(this.realm, this.user);
        for (UserSessionModel s : sessions) {
            for (AuthenticatedClientSessionModel a : s.getAuthenticatedClientSessions().values()) {
                ClientModel client2 = a.getClient();
                clients.add(client2);
                inUseClients.add(client2.getClientId());
            }
        }
        LinkedList<String> offlineClients = new LinkedList<String>();
        List offlineSessions = this.session.sessions().getOfflineUserSessions(this.realm, this.user);
        for (UserSessionModel s : offlineSessions) {
            for (AuthenticatedClientSessionModel a : s.getAuthenticatedClientSessions().values()) {
                client3 = a.getClient();
                clients.add(client3);
                offlineClients.add(client3.getClientId());
            }
        }
        HashMap<String, UserConsentModel> consentModels = new HashMap<String, UserConsentModel>();
        List consents = this.session.users().getConsents(this.realm, this.user.getId());
        for (Object consent : consents) {
            client3 = consent.getClient();
            clients.add(client3);
            consentModels.put(client3.getClientId(), (UserConsentModel)consent);
        }
        List alwaysDisplayClients = this.realm.getAlwaysDisplayInConsoleClients();
        for (ClientModel client3 : alwaysDisplayClients) {
            clients.add(client3);
        }
        LinkedList<ClientRepresentation> apps = new LinkedList<ClientRepresentation>();
        for (ClientModel client4 : clients) {
            if (client4.isBearerOnly() || client4.getBaseUrl() == null) continue;
            apps.add(this.modelToRepresentation(client4, inUseClients, offlineClients, consentModels));
        }
        return Cors.add(this.request, Response.ok(apps)).auth().allowedOrigins(this.auth.getToken()).build();
    }

    private static void checkAccountApiEnabled() {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ACCOUNT_API)) {
            throw new NotFoundException();
        }
    }
}

